/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.util.Map;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.job.IJobManager;
import org.apache.hyracks.control.cc.job.JobRun;
import org.apache.hyracks.control.cc.job.TaskAttempt;
import org.apache.hyracks.control.cc.work.AbstractTaskLifecycleWork;
import org.apache.hyracks.control.common.job.profiling.om.JobProfile;
import org.apache.hyracks.control.common.job.profiling.om.JobletProfile;
import org.apache.hyracks.control.common.job.profiling.om.TaskProfile;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskCompleteWork
extends AbstractTaskLifecycleWork {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TaskProfile statistics;

    public TaskCompleteWork(ClusterControllerService ccs, JobId jobId, TaskAttemptId taId, String nodeId, TaskProfile statistics) {
        super(ccs, jobId, taId, nodeId);
        this.statistics = statistics;
    }

    @Override
    protected void performEvent(TaskAttempt ta) {
        IJobManager jobManager = this.ccs.getJobManager();
        JobRun run = jobManager.get(this.jobId);
        if (run == null) {
            LOGGER.debug("node completed task for unknown job {}:{}:{}", (Object)this.nodeId, (Object)this.jobId, (Object)this.taId);
            return;
        }
        LOGGER.debug("node completed task {}:{}:{}", (Object)this.nodeId, (Object)this.jobId, (Object)this.taId);
        if (this.statistics != null) {
            JobProfile jobProfile = run.getJobProfile();
            Map jobletProfiles = jobProfile.getJobletProfiles();
            JobletProfile jobletProfile = (JobletProfile)jobletProfiles.get(this.nodeId);
            if (jobletProfile == null) {
                jobletProfile = new JobletProfile(this.nodeId);
                jobletProfiles.put(this.nodeId, jobletProfile);
            }
            jobletProfile.getTaskProfiles().put(this.taId, this.statistics);
        }
        run.getExecutor().notifyTaskComplete(ta);
    }

    public String toString() {
        return this.getName() + ": [" + this.nodeId + "[" + this.jobId + ":" + this.taId + "]";
    }

    public Level logLevel() {
        return Level.TRACE;
    }
}

