/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.filter.range.compartor;

import org.apache.asterix.column.filter.FalseColumnFilterEvaluator;
import org.apache.asterix.column.filter.FilterAccessorProvider;
import org.apache.asterix.column.filter.IColumnFilterEvaluator;
import org.apache.asterix.column.filter.TrueColumnFilterEvaluator;
import org.apache.asterix.column.filter.range.IColumnRangeFilterEvaluatorFactory;
import org.apache.asterix.column.filter.range.IColumnRangeFilterValueAccessor;
import org.apache.asterix.column.filter.range.IColumnRangeFilterValueAccessorFactory;
import org.apache.asterix.column.filter.range.accessor.NoOpColumnRangeFilterValueAccessor;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.hyracks.api.exceptions.HyracksDataException;

abstract class AbstractColumnFilterComparatorFactory
implements IColumnRangeFilterEvaluatorFactory {
    private static final long serialVersionUID = 4229059703449173694L;
    private final IColumnRangeFilterValueAccessorFactory left;
    private final IColumnRangeFilterValueAccessorFactory right;

    AbstractColumnFilterComparatorFactory(IColumnRangeFilterValueAccessorFactory left, IColumnRangeFilterValueAccessorFactory right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public final IColumnFilterEvaluator create(FilterAccessorProvider filterAccessorProvider) throws HyracksDataException {
        IColumnRangeFilterValueAccessor leftAccessor = this.left.create(filterAccessorProvider);
        IColumnRangeFilterValueAccessor rightAccessor = this.right.create(filterAccessorProvider);
        ATypeTag leftTypeTag = leftAccessor.getTypeTag();
        ATypeTag rightTypeTag = rightAccessor.getTypeTag();
        if (this.isNoOp(leftAccessor, rightAccessor) || leftTypeTag != rightTypeTag && ATypeHierarchy.isCompatible((ATypeTag)leftTypeTag, (ATypeTag)rightTypeTag)) {
            return TrueColumnFilterEvaluator.INSTANCE;
        }
        if (this.cannotCompare(leftTypeTag, rightTypeTag)) {
            return FalseColumnFilterEvaluator.INSTANCE;
        }
        return this.createComparator(leftAccessor, rightAccessor);
    }

    private boolean isNoOp(IColumnRangeFilterValueAccessor leftAccessor, IColumnRangeFilterValueAccessor rightAccessor) {
        return leftAccessor == NoOpColumnRangeFilterValueAccessor.INSTANCE || rightAccessor == NoOpColumnRangeFilterValueAccessor.INSTANCE;
    }

    private boolean cannotCompare(ATypeTag leftTypeTag, ATypeTag rightTypeTag) {
        return rightTypeTag == ATypeTag.MISSING || leftTypeTag != rightTypeTag;
    }

    protected abstract IColumnFilterEvaluator createComparator(IColumnRangeFilterValueAccessor var1, IColumnRangeFilterValueAccessor var2);

    protected abstract String getOpt();

    public String toString() {
        return this.left.toString() + " " + this.getOpt() + " " + this.right.toString();
    }

    static abstract class AbstractComparator
    implements IColumnFilterEvaluator {
        protected final IColumnRangeFilterValueAccessor left;
        protected final IColumnRangeFilterValueAccessor right;

        AbstractComparator(IColumnRangeFilterValueAccessor left, IColumnRangeFilterValueAccessor right) {
            this.left = left;
            this.right = right;
        }
    }
}

