/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.validation;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class ColumnPropertiesValidationUtil {
    private static final Set<String> UNSUPPORTED_MERGE_POLICIES = Set.of("correlated-prefix");

    private ColumnPropertiesValidationUtil() {
    }

    public static void validate(SourceLocation sourceLocation, DatasetConfig.DatasetFormat format, String mergePolicy, List<String> filterFields) throws AlgebricksException {
        if (format != DatasetConfig.DatasetFormat.COLUMN) {
            return;
        }
        if (UNSUPPORTED_MERGE_POLICIES.contains(mergePolicy.toLowerCase())) {
            throw CompilationException.create((ErrorCode)ErrorCode.UNSUPPORTED_COLUMN_MERGE_POLICY, (SourceLocation)sourceLocation, (Serializable[])new Serializable[]{mergePolicy});
        }
        if (filterFields != null && !filterFields.isEmpty()) {
            throw CompilationException.create((ErrorCode)ErrorCode.UNSUPPORTED_COLUMN_LSM_FILTER, (SourceLocation)sourceLocation, (Serializable[])new Serializable[0]);
        }
    }
}

