/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.dataset.adapter;

import java.io.Serializable;
import java.util.Objects;
import org.apache.asterix.common.metadata.DataverseName;

public class AdapterIdentifier
implements Serializable {
    private static final long serialVersionUID = 3L;
    private final String databaseName;
    private final DataverseName dataverseName;
    private final String adapterName;

    public AdapterIdentifier(String databaseName, DataverseName dataverse, String name) {
        this.databaseName = Objects.requireNonNull(databaseName);
        this.dataverseName = dataverse;
        this.adapterName = name;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public DataverseName getDataverseName() {
        return this.dataverseName;
    }

    public String getName() {
        return this.adapterName;
    }

    public int hashCode() {
        return Objects.hash(this.databaseName, this.dataverseName + "@" + this.adapterName);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdapterIdentifier)) {
            return false;
        }
        AdapterIdentifier a = (AdapterIdentifier)o;
        return Objects.equals(this.databaseName, a.databaseName) && this.dataverseName.equals((Object)a.dataverseName) && this.adapterName.equals(a.adapterName);
    }
}

