/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.writer.printer;

import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.asterix.external.writer.compressor.IExternalFileCompressStreamFactory;
import org.apache.asterix.external.writer.printer.TextualOutputStreamDelegate;
import org.apache.asterix.runtime.writer.IExternalFilePrinter;
import org.apache.hyracks.algebricks.data.IPrinter;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;

final class TextualExternalFilePrinter
implements IExternalFilePrinter {
    private final IPrinter printer;
    private final IExternalFileCompressStreamFactory compressStreamFactory;
    private TextualOutputStreamDelegate delegate;
    private PrintStream printStream;

    TextualExternalFilePrinter(IPrinter printer, IExternalFileCompressStreamFactory compressStreamFactory) {
        this.printer = printer;
        this.compressStreamFactory = compressStreamFactory;
    }

    public void open() throws HyracksDataException {
        this.printer.init();
    }

    public void newStream(OutputStream outputStream) throws HyracksDataException {
        if (this.printStream != null) {
            this.close();
        }
        this.delegate = new TextualOutputStreamDelegate(this.compressStreamFactory.createStream(outputStream));
        this.printStream = new PrintStream(this.delegate);
    }

    public void print(IValueReference value) throws HyracksDataException {
        this.printer.print(value.getByteArray(), value.getStartOffset(), value.getLength(), this.printStream);
        this.printStream.println();
        this.delegate.checkError();
    }

    public void close() throws HyracksDataException {
        if (this.printStream != null) {
            this.printStream.close();
            this.printStream = null;
            this.delegate.checkError();
            this.delegate = null;
        }
    }
}

