/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mojo;

import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.reflect.ReflectData;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class InduceMojo
extends AbstractMojo {
    private File[] javaSourceDirectories;
    private File avroOutputDirectory;
    private String encoding;
    private boolean allowNull;
    private String reflectDataImplementation;
    protected MavenProject project;
    private ClassLoader classLoader;
    private ReflectData reflectData;

    public void execute() throws MojoExecutionException {
        this.classLoader = this.getClassLoader();
        this.reflectData = this.getReflectData();
        if (this.encoding == null) {
            this.encoding = Charset.defaultCharset().name();
            this.getLog().warn((CharSequence)("Property project.build.sourceEncoding not set, using system default " + this.encoding));
        }
        for (File sourceDirectory : this.javaSourceDirectories) {
            this.induceClasses(sourceDirectory);
        }
    }

    private void induceClasses(File sourceDirectory) throws MojoExecutionException {
        File[] files = sourceDirectory.listFiles();
        if (files == null) {
            throw new MojoExecutionException("Unable to list files from directory: " + sourceDirectory.getName());
        }
        for (File inputFile : files) {
            if (inputFile.isDirectory()) {
                this.induceClasses(inputFile);
                continue;
            }
            String className = this.parseClassName(inputFile.getPath());
            if (className == null) continue;
            Class<?> klass = this.loadClass(this.classLoader, className);
            String fileName = this.getOutputFileName(klass);
            File outputFile = new File(fileName);
            outputFile.getParentFile().mkdirs();
            try (PrintWriter writer = new PrintWriter(fileName, this.encoding);){
                if (klass.isInterface()) {
                    writer.println(this.reflectData.getProtocol(klass).toString(true));
                    continue;
                }
                writer.println(this.reflectData.getSchema(klass).toString(true));
            }
            catch (AvroRuntimeException e) {
                throw new MojoExecutionException("Failed to resolve schema or protocol for class " + klass.getCanonicalName(), (Exception)((Object)e));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to write output file for class " + klass.getCanonicalName(), e);
            }
        }
    }

    private String parseClassName(String fileName) {
        String indentifier = "java" + File.separator;
        int index = fileName.lastIndexOf(indentifier);
        String namespacedFileName = fileName.substring(index + indentifier.length());
        if (!namespacedFileName.endsWith(".java")) {
            return null;
        }
        return namespacedFileName.replace(File.separator, ".").replaceFirst("\\.java$", "");
    }

    private String getOutputFileName(Class klass) {
        String filename = this.avroOutputDirectory.getPath() + File.separator + klass.getName().replace(".", File.separator);
        if (klass.isInterface()) {
            return filename.concat(".avpr");
        }
        return filename.concat(".avsc");
    }

    private ReflectData getReflectData() throws MojoExecutionException {
        if (this.reflectDataImplementation == null) {
            return this.allowNull ? ReflectData.AllowNull.get() : ReflectData.get();
        }
        try {
            Constructor<ReflectData> constructor = this.loadClass(this.classLoader, this.reflectDataImplementation).asSubclass(ReflectData.class).getConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Could not load ReflectData custom implementation %s. Make sure that it has a no-args constructor", this.reflectDataImplementation), e);
        }
    }

    private Class<?> loadClass(ClassLoader classLoader, String className) throws MojoExecutionException {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Failed to load class " + className, (Exception)e);
        }
    }

    private ClassLoader getClassLoader() throws MojoExecutionException {
        URLClassLoader classLoader;
        try {
            List classpathElements = this.project.getRuntimeClasspathElements();
            if (null == classpathElements) {
                return Thread.currentThread().getContextClassLoader();
            }
            URL[] urls = new URL[classpathElements.size()];
            for (int i = 0; i < classpathElements.size(); ++i) {
                urls[i] = new File((String)classpathElements.get(i)).toURI().toURL();
            }
            classLoader = new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to obtain ClassLoader", e);
        }
        return classLoader;
    }
}

