/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.json.gson.rpc;

import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.json.gson.GsonXMLStreamReader;
import org.apache.axis2.json.gson.rpc.JsonUtils;
import org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonInOnlyRPCMessageReceiver
extends RPCInOnlyMessageReceiver {
    private static final Log log = LogFactory.getLog(JsonInOnlyRPCMessageReceiver.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invokeBusinessLogic(MessageContext inMessage) throws AxisFault {
        Object tempObj = inMessage.getProperty("isJsonStream");
        boolean isJsonStream = tempObj != null ? Boolean.valueOf(tempObj.toString()) : false;
        if (isJsonStream) {
            Object o = inMessage.getProperty("GsonXMLStreamReader");
            if (o == null) throw new AxisFault("GsonXMLStreamReader should have put as a property of messageContext to evaluate JSON message");
            GsonXMLStreamReader gsonXMLStreamReader = (GsonXMLStreamReader)o;
            JsonReader jsonReader = gsonXMLStreamReader.getJsonReader();
            if (jsonReader == null) {
                throw new AxisFault("JsonReader should not be null");
            }
            Object serviceObj = this.getTheImplementationObject(inMessage);
            AxisOperation op = inMessage.getOperationContext().getAxisOperation();
            String operation = op.getName().getLocalPart();
            log.debug((Object)("JsonInOnlyRPCMessageReceiver.invokeBusinessLogic() executing invokeService() with operation: " + operation));
            this.invokeService(jsonReader, serviceObj, operation);
            return;
        } else {
            super.invokeBusinessLogic(inMessage);
        }
    }

    public void invokeService(JsonReader jsonReader, Object serviceObj, String operation_name) throws AxisFault {
        Class<?> implClass = serviceObj.getClass();
        Method[] allMethods = implClass.getDeclaredMethods();
        Method method = JsonUtils.getOpMethod(operation_name, allMethods);
        Class[] paramClasses = method.getParameterTypes();
        try {
            int paramCount = paramClasses.length;
            JsonUtils.invokeServiceClass(jsonReader, serviceObj, method, paramClasses, paramCount);
        }
        catch (IllegalAccessException e) {
            String msg = "Does not have access to the definition of the specified class, field, method or constructor";
            log.error((Object)msg, (Throwable)e);
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (InvocationTargetException e) {
            String msg = "Exception occurred while trying to invoke service method " + (method != null ? method.getName() : "null");
            log.error((Object)msg, (Throwable)e);
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (IOException e) {
            String msg = "Exception occur while encording or access to the input string at the JsonRpcMessageReceiver";
            log.error((Object)msg, (Throwable)e);
            throw AxisFault.makeFault((Throwable)e);
        }
    }
}

