/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.intf;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;
import org.apache.axiom.om.impl.intf.factory.AxiomElementType;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPVersion;
import org.apache.axiom.soap.impl.intf.AxiomSOAPBody;
import org.apache.axiom.soap.impl.intf.AxiomSOAPEnvelope;
import org.apache.axiom.soap.impl.intf.AxiomSOAPFault;
import org.apache.axiom.soap.impl.intf.AxiomSOAPFaultCode;
import org.apache.axiom.soap.impl.intf.AxiomSOAPFaultDetail;
import org.apache.axiom.soap.impl.intf.AxiomSOAPFaultReason;
import org.apache.axiom.soap.impl.intf.AxiomSOAPFaultRole;
import org.apache.axiom.soap.impl.intf.AxiomSOAPHeader;
import org.apache.axiom.soap.impl.intf.AxiomSOAPHeaderBlock;

public abstract class SOAPHelper {
    private final SOAPVersion version;
    private final OMNamespace namespace;
    private final String specName;
    private final AxiomElementType<? extends AxiomSOAPEnvelope> envelopeType;
    private final AxiomElementType<? extends AxiomSOAPHeader> headerType;
    private final QName headerQName;
    private final AxiomElementType<? extends AxiomSOAPHeaderBlock> headerBlockType;
    private final AxiomElementType<? extends AxiomSOAPBody> bodyType;
    private final QName bodyQName;
    private final AxiomElementType<? extends AxiomSOAPFault> faultType;
    private final QName faultQName;
    private final AxiomElementType<? extends AxiomSOAPFaultCode> faultCodeType;
    private final AxiomElementType<? extends AxiomSOAPFaultReason> faultReasonType;
    private final AxiomElementType<? extends AxiomSOAPFaultRole> faultRoleType;
    private final AxiomElementType<? extends AxiomSOAPFaultDetail> faultDetailType;
    private final QName mustUnderstandAttributeQName;
    private final QName roleAttributeQName;
    private final QName relayAttributeQName;

    protected SOAPHelper(SOAPVersion version, String specName, AxiomElementType<? extends AxiomSOAPEnvelope> envelopeType, AxiomElementType<? extends AxiomSOAPHeader> headerType, AxiomElementType<? extends AxiomSOAPHeaderBlock> headerBlockType, AxiomElementType<? extends AxiomSOAPBody> bodyType, AxiomElementType<? extends AxiomSOAPFault> faultType, AxiomElementType<? extends AxiomSOAPFaultCode> faultCodeType, AxiomElementType<? extends AxiomSOAPFaultReason> faultReasonType, AxiomElementType<? extends AxiomSOAPFaultRole> faultRoleType, AxiomElementType<? extends AxiomSOAPFaultDetail> faultDetailType, String roleAttributeLocalName, String relayAttributeLocalName) {
        this.version = version;
        this.namespace = new OMNamespaceImpl(version.getEnvelopeURI(), "soapenv");
        this.specName = specName;
        this.envelopeType = envelopeType;
        this.headerType = headerType;
        this.headerQName = new QName(version.getEnvelopeURI(), "Header", "soapenv");
        this.headerBlockType = headerBlockType;
        this.bodyType = bodyType;
        this.bodyQName = new QName(version.getEnvelopeURI(), "Body", "soapenv");
        this.faultType = faultType;
        this.faultQName = new QName(version.getEnvelopeURI(), "Fault", "soapenv");
        this.faultCodeType = faultCodeType;
        this.faultReasonType = faultReasonType;
        this.faultRoleType = faultRoleType;
        this.faultDetailType = faultDetailType;
        this.mustUnderstandAttributeQName = new QName(version.getEnvelopeURI(), "mustUnderstand", "soapenv");
        this.roleAttributeQName = new QName(version.getEnvelopeURI(), roleAttributeLocalName, "soapenv");
        this.relayAttributeQName = relayAttributeLocalName == null ? null : new QName(version.getEnvelopeURI(), relayAttributeLocalName, "soapenv");
    }

    public final SOAPVersion getVersion() {
        return this.version;
    }

    public abstract SOAPFactory getSOAPFactory(OMMetaFactory var1);

    public final String getEnvelopeURI() {
        return this.version.getEnvelopeURI();
    }

    public final OMNamespace getNamespace() {
        return this.namespace;
    }

    public final String getSpecName() {
        return this.specName;
    }

    public final AxiomElementType<? extends AxiomSOAPEnvelope> getEnvelopeType() {
        return this.envelopeType;
    }

    public final AxiomElementType<? extends AxiomSOAPHeader> getHeaderType() {
        return this.headerType;
    }

    public final QName getHeaderQName() {
        return this.headerQName;
    }

    public final AxiomElementType<? extends AxiomSOAPHeaderBlock> getHeaderBlockType() {
        return this.headerBlockType;
    }

    public final AxiomElementType<? extends AxiomSOAPBody> getBodyType() {
        return this.bodyType;
    }

    public final QName getBodyQName() {
        return this.bodyQName;
    }

    public final AxiomElementType<? extends AxiomSOAPFault> getFaultType() {
        return this.faultType;
    }

    public final QName getFaultQName() {
        return this.faultQName;
    }

    public final AxiomElementType<? extends AxiomSOAPFaultCode> getFaultCodeType() {
        return this.faultCodeType;
    }

    public final QName getFaultCodeQName() {
        return this.version.getFaultCodeQName();
    }

    public final AxiomElementType<? extends AxiomSOAPFaultReason> getFaultReasonType() {
        return this.faultReasonType;
    }

    public final QName getFaultReasonQName() {
        return this.version.getFaultReasonQName();
    }

    public final AxiomElementType<? extends AxiomSOAPFaultRole> getFaultRoleType() {
        return this.faultRoleType;
    }

    public final QName getFaultRoleQName() {
        return this.version.getFaultRoleQName();
    }

    public final AxiomElementType<? extends AxiomSOAPFaultDetail> getFaultDetailType() {
        return this.faultDetailType;
    }

    public final QName getFaultDetailQName() {
        return this.version.getFaultDetailQName();
    }

    public final QName getMustUnderstandAttributeQName() {
        return this.mustUnderstandAttributeQName;
    }

    public final QName getRoleAttributeQName() {
        return this.roleAttributeQName;
    }

    public final QName getRelayAttributeQName() {
        return this.relayAttributeQName;
    }

    public abstract Boolean parseBoolean(String var1);

    public abstract String formatBoolean(boolean var1);
}

