/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.NetServerBase;
import io.vertx.core.net.impl.NetSocketImpl;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.core.streams.ReadStream;

public class NetServerImpl
extends NetServerBase<NetSocketImpl>
implements NetServer {
    private final NetSocketStream connectStream = new NetSocketStream();
    private Handler<NetSocket> handler;
    private Handler<Void> endHandler;

    public NetServerImpl(VertxInternal vertx, NetServerOptions options) {
        super(vertx, options);
    }

    @Override
    public synchronized Handler<NetSocket> connectHandler() {
        return this.handler;
    }

    @Override
    public synchronized NetServer connectHandler(Handler<NetSocket> handler) {
        if (this.isListening()) {
            throw new IllegalStateException("Cannot set connectHandler when server is listening");
        }
        this.handler = handler;
        return this;
    }

    @Override
    protected void initChannel(ChannelPipeline pipeline) {
        if (this.sslHelper.isSSL()) {
            SslHandler sslHandler = this.sslHelper.createSslHandler(this.vertx);
            pipeline.addLast("ssl", (ChannelHandler)sslHandler);
        }
        if (this.logEnabled) {
            pipeline.addLast("logging", (ChannelHandler)new LoggingHandler());
        }
        if (this.sslHelper.isSSL()) {
            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        }
        if (this.options.getIdleTimeout() > 0) {
            pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0, 0, this.options.getIdleTimeout()));
        }
    }

    @Override
    protected void handleMsgReceived(NetSocketImpl conn, Object msg) {
        ByteBuf buf = (ByteBuf)msg;
        conn.handleDataReceived(Buffer.buffer(buf));
    }

    @Override
    protected Object safeObject(Object msg, ByteBufAllocator allocator) {
        if (msg instanceof ByteBuf) {
            return VertxHandler.safeBuffer((ByteBuf)msg, allocator);
        }
        return msg;
    }

    @Override
    public NetServer listen(int port, String host) {
        return this.listen(port, host, (Handler)null);
    }

    @Override
    public NetServer listen(int port) {
        return this.listen(port, "0.0.0.0", (Handler)null);
    }

    @Override
    public NetServer listen(int port, Handler<AsyncResult<NetServer>> listenHandler) {
        return this.listen(port, "0.0.0.0", (Handler)listenHandler);
    }

    @Override
    public NetServer listen() {
        this.listen(null);
        return this;
    }

    @Override
    public synchronized NetServer listen(Handler<AsyncResult<NetServer>> listenHandler) {
        return this.listen(this.options.getPort(), this.options.getHost(), (Handler)listenHandler);
    }

    @Override
    public synchronized NetServerImpl listen(int port, String host, Handler<AsyncResult<NetServer>> listenHandler) {
        this.listen(this.handler, port, host, ar -> {
            if (listenHandler != null) {
                listenHandler.handle(ar.map(this));
            }
        });
        return this;
    }

    @Override
    public ReadStream<NetSocket> connectStream() {
        return this.connectStream;
    }

    @Override
    public synchronized void close(Handler<AsyncResult<Void>> done) {
        if (this.endHandler != null) {
            Handler<Void> handler = this.endHandler;
            this.endHandler = null;
            Handler<AsyncResult<Void>> next = done;
            done = event -> {
                if (event.succeeded()) {
                    handler.handle((Void)event.result());
                }
                if (next != null) {
                    next.handle((AsyncResult<Void>)event);
                }
            };
        }
        super.close(done);
    }

    @Override
    protected NetSocketImpl createConnection(VertxInternal vertx, Channel channel, ContextImpl context, SSLHelper helper, TCPMetrics metrics) {
        return new NetSocketImpl(vertx, channel, context, helper, metrics);
    }

    private class NetSocketStream
    implements ReadStream<NetSocket> {
        private NetSocketStream() {
        }

        public NetSocketStream handler(Handler<NetSocket> handler) {
            NetServerImpl.this.connectHandler(handler);
            return this;
        }

        public NetSocketStream pause() {
            NetServerImpl.this.pauseAccepting();
            return this;
        }

        public NetSocketStream resume() {
            NetServerImpl.this.resumeAccepting();
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NetSocketStream endHandler(Handler<Void> handler) {
            NetServerImpl netServerImpl = NetServerImpl.this;
            synchronized (netServerImpl) {
                NetServerImpl.this.endHandler = handler;
                return this;
            }
        }

        @Override
        public NetSocketStream exceptionHandler(Handler<Throwable> handler) {
            return this;
        }
    }
}

