/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.bookkeeper.common.concurrent.FutureEventListener;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.bookkeeper.stats.AlertStatsLogger;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.distributedlog.BKLogHandler;
import org.apache.distributedlog.BKLogSegmentWriter;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.MaxLogSegmentSequenceNo;
import org.apache.distributedlog.MaxTxId;
import org.apache.distributedlog.common.util.PermitLimiter;
import org.apache.distributedlog.config.DynamicDistributedLogConfiguration;
import org.apache.distributedlog.exceptions.DLIllegalStateException;
import org.apache.distributedlog.exceptions.EndOfStreamException;
import org.apache.distributedlog.exceptions.LockingException;
import org.apache.distributedlog.exceptions.LogSegmentNotFoundException;
import org.apache.distributedlog.exceptions.TransactionIdOutOfOrderException;
import org.apache.distributedlog.exceptions.UnexpectedException;
import org.apache.distributedlog.function.GetLastTxIdFunction;
import org.apache.distributedlog.impl.ZKLogSegmentFilters;
import org.apache.distributedlog.lock.DistributedLock;
import org.apache.distributedlog.logsegment.LogSegmentEntryStore;
import org.apache.distributedlog.logsegment.LogSegmentEntryWriter;
import org.apache.distributedlog.logsegment.LogSegmentFilter;
import org.apache.distributedlog.logsegment.LogSegmentMetadataCache;
import org.apache.distributedlog.logsegment.RollingPolicy;
import org.apache.distributedlog.logsegment.SizeBasedRollingPolicy;
import org.apache.distributedlog.logsegment.TimeBasedRollingPolicy;
import org.apache.distributedlog.metadata.LogMetadataForWriter;
import org.apache.distributedlog.metadata.LogSegmentMetadataStoreUpdater;
import org.apache.distributedlog.metadata.LogStreamMetadataStore;
import org.apache.distributedlog.metadata.MetadataUpdater;
import org.apache.distributedlog.util.Allocator;
import org.apache.distributedlog.util.DLUtils;
import org.apache.distributedlog.util.FailpointUtils;
import org.apache.distributedlog.util.Transaction;
import org.apache.distributedlog.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BKLogWriteHandler
extends BKLogHandler {
    static final Logger LOG = LoggerFactory.getLogger(BKLogWriteHandler.class);
    private static Transaction.OpListener<LogSegmentEntryWriter> NULL_OP_LISTENER = new Transaction.OpListener<LogSegmentEntryWriter>(){

        @Override
        public void onCommit(LogSegmentEntryWriter r) {
        }

        @Override
        public void onAbort(Throwable t) {
        }
    };
    protected final LogMetadataForWriter logMetadataForWriter;
    protected final Allocator<LogSegmentEntryWriter, Object> logSegmentAllocator;
    protected final DistributedLock lock;
    protected final MaxTxId maxTxId;
    protected final MaxLogSegmentSequenceNo maxLogSegmentSequenceNo;
    protected final boolean validateLogSegmentSequenceNumber;
    protected final int regionId;
    protected final RollingPolicy rollingPolicy;
    protected CompletableFuture<? extends DistributedLock> lockFuture = null;
    protected final PermitLimiter writeLimiter;
    protected final FeatureProvider featureProvider;
    protected final DynamicDistributedLogConfiguration dynConf;
    protected final MetadataUpdater metadataUpdater;
    protected final LinkedList<Long> inprogressLSSNs;
    private final CompletableFuture<Versioned<List<LogSegmentMetadata>>> fetchForWrite;
    private CompletableFuture<Versioned<List<LogSegmentMetadata>>> fetchForTruncation;
    private final RecoverLogSegmentFunction recoverLogSegmentFunction = new RecoverLogSegmentFunction();
    private final Function<List<LogSegmentMetadata>, CompletableFuture<Long>> recoverLogSegmentsFunction = new Function<List<LogSegmentMetadata>, CompletableFuture<Long>>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompletableFuture<Long> apply(List<LogSegmentMetadata> segmentList) {
            LOG.info("Initiating Recovery For {} : {}", (Object)BKLogWriteHandler.this.getFullyQualifiedName(), segmentList);
            Object object = BKLogWriteHandler.this;
            synchronized (object) {
                if (BKLogWriteHandler.this.lastLedgerRollingTimeMillis < 0L) {
                    BKLogWriteHandler.this.lastLedgerRollingTimeMillis = Utils.nowInMillis();
                }
            }
            if (BKLogWriteHandler.this.validateLogSegmentSequenceNumber) {
                object = BKLogWriteHandler.this.inprogressLSSNs;
                synchronized (object) {
                    for (LogSegmentMetadata segment : segmentList) {
                        if (!segment.isInProgress()) continue;
                        BKLogWriteHandler.this.inprogressLSSNs.addLast(segment.getLogSegmentSequenceNumber());
                    }
                }
            }
            return ((CompletableFuture)FutureUtils.processList(segmentList, (Function)BKLogWriteHandler.this.recoverLogSegmentFunction, (ExecutorService)BKLogWriteHandler.this.scheduler).thenApply(BKLogWriteHandler.this.removeEmptySegments)).thenApply((Function)GetLastTxIdFunction.INSTANCE);
        }
    };
    private final Function<List<LogSegmentMetadata>, List<LogSegmentMetadata>> removeEmptySegments = new Function<List<LogSegmentMetadata>, List<LogSegmentMetadata>>(){

        @Override
        public List<LogSegmentMetadata> apply(List<LogSegmentMetadata> segmentList) {
            Iterator<LogSegmentMetadata> iter = segmentList.iterator();
            while (iter.hasNext()) {
                LogSegmentMetadata segment = iter.next();
                if (segment != null) continue;
                iter.remove();
            }
            return segmentList;
        }
    };
    private final StatsLogger perLogStatsLogger;
    private final OpStatsLogger closeOpStats;
    private final OpStatsLogger openOpStats;
    private final OpStatsLogger recoverOpStats;
    private final OpStatsLogger deleteOpStats;

    BKLogWriteHandler(LogMetadataForWriter logMetadata, DistributedLogConfiguration conf, LogStreamMetadataStore streamMetadataStore, LogSegmentMetadataCache metadataCache, LogSegmentEntryStore entryStore, OrderedScheduler scheduler, Allocator<LogSegmentEntryWriter, Object> segmentAllocator, StatsLogger statsLogger, StatsLogger perLogStatsLogger, AlertStatsLogger alertStatsLogger, String clientId, int regionId, PermitLimiter writeLimiter, FeatureProvider featureProvider, DynamicDistributedLogConfiguration dynConf, DistributedLock lock) {
        super(logMetadata, conf, streamMetadataStore, metadataCache, entryStore, scheduler, statsLogger, alertStatsLogger, clientId);
        this.logMetadataForWriter = logMetadata;
        this.logSegmentAllocator = segmentAllocator;
        this.perLogStatsLogger = perLogStatsLogger;
        this.writeLimiter = writeLimiter;
        this.featureProvider = featureProvider;
        this.dynConf = dynConf;
        this.lock = lock;
        this.metadataUpdater = LogSegmentMetadataStoreUpdater.createMetadataUpdater(conf, this.metadataStore);
        this.regionId = conf.getEncodeRegionIDInLogSegmentMetadata() ? regionId : 0;
        this.validateLogSegmentSequenceNumber = conf.isLogSegmentSequenceNumberValidationEnabled();
        this.maxLogSegmentSequenceNo = new MaxLogSegmentSequenceNo(logMetadata.getMaxLSSNData());
        this.inprogressLSSNs = new LinkedList();
        this.maxTxId = new MaxTxId(logMetadata.getMaxTxIdData());
        this.fetchForWrite = this.readLogSegmentsFromStore(LogSegmentMetadata.COMPARATOR, ZKLogSegmentFilters.WRITE_HANDLE_FILTER, null);
        this.setLastLedgerRollingTimeMillis(Utils.nowInMillis());
        this.rollingPolicy = conf.getLogSegmentRollingIntervalMinutes() > 0 ? new TimeBasedRollingPolicy((long)(conf.getLogSegmentRollingIntervalMinutes() * 60) * 1000L) : new SizeBasedRollingPolicy(conf.getMaxLogSegmentBytes());
        StatsLogger segmentsStatsLogger = statsLogger.scope("segments");
        this.openOpStats = segmentsStatsLogger.getOpStatsLogger("open");
        this.closeOpStats = segmentsStatsLogger.getOpStatsLogger("close");
        this.recoverOpStats = segmentsStatsLogger.getOpStatsLogger("recover");
        this.deleteOpStats = segmentsStatsLogger.getOpStatsLogger("delete");
    }

    private CompletableFuture<List<LogSegmentMetadata>> getCachedLogSegmentsAfterFirstFetch(final Comparator<LogSegmentMetadata> comparator) {
        final CompletableFuture<List<LogSegmentMetadata>> promise = new CompletableFuture<List<LogSegmentMetadata>>();
        this.fetchForWrite.whenComplete((BiConsumer)new FutureEventListener<Versioned<List<LogSegmentMetadata>>>(){

            public void onFailure(Throwable cause) {
                promise.completeExceptionally(cause);
            }

            public void onSuccess(Versioned<List<LogSegmentMetadata>> result) {
                try {
                    promise.complete(BKLogWriteHandler.this.getCachedLogSegments(comparator));
                }
                catch (UnexpectedException e) {
                    promise.completeExceptionally(e);
                }
            }
        });
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<List<LogSegmentMetadata>> getCachedLogSegmentsAfterFirstFullFetch(final Comparator<LogSegmentMetadata> comparator) {
        CompletableFuture<Versioned<List<LogSegmentMetadata>>> result;
        BKLogWriteHandler bKLogWriteHandler = this;
        synchronized (bKLogWriteHandler) {
            if (null == this.fetchForTruncation) {
                this.fetchForTruncation = this.readLogSegmentsFromStore(LogSegmentMetadata.COMPARATOR, LogSegmentFilter.DEFAULT_FILTER, null);
            }
            result = this.fetchForTruncation;
        }
        final CompletableFuture<List<LogSegmentMetadata>> promise = new CompletableFuture<List<LogSegmentMetadata>>();
        result.whenComplete((BiConsumer)new FutureEventListener<Versioned<List<LogSegmentMetadata>>>(){

            public void onFailure(Throwable cause) {
                FutureUtils.completeExceptionally((CompletableFuture)promise, (Throwable)cause);
            }

            public void onSuccess(Versioned<List<LogSegmentMetadata>> result) {
                try {
                    FutureUtils.complete((CompletableFuture)promise, BKLogWriteHandler.this.getCachedLogSegments(comparator));
                }
                catch (UnexpectedException e) {
                    FutureUtils.completeExceptionally((CompletableFuture)promise, (Throwable)e);
                }
            }
        });
        return promise;
    }

    void storeMaxSequenceNumber(Transaction<Object> txn, final MaxLogSegmentSequenceNo maxSeqNo, final long seqNo, final boolean isInprogress) {
        this.metadataStore.storeMaxLogSegmentSequenceNumber(txn, this.logMetadata, maxSeqNo.getVersionedData(seqNo), new Transaction.OpListener<Version>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCommit(Version version) {
                if (BKLogWriteHandler.this.validateLogSegmentSequenceNumber) {
                    LinkedList<Long> linkedList = BKLogWriteHandler.this.inprogressLSSNs;
                    synchronized (linkedList) {
                        if (isInprogress) {
                            BKLogWriteHandler.this.inprogressLSSNs.add(seqNo);
                        } else {
                            BKLogWriteHandler.this.inprogressLSSNs.removeFirst();
                        }
                    }
                }
                maxSeqNo.update(version, seqNo);
            }

            @Override
            public void onAbort(Throwable t) {
            }
        });
    }

    void storeMaxTxId(Transaction<Object> txn, final MaxTxId maxTxId, final long txId) {
        this.metadataStore.storeMaxTxnId(txn, this.logMetadataForWriter, maxTxId.getVersionedData(txId), new Transaction.OpListener<Version>(){

            @Override
            public void onCommit(Version version) {
                maxTxId.update(version, txId);
            }

            @Override
            public void onAbort(Throwable t) {
            }
        });
    }

    void writeLogSegment(Transaction<Object> txn, final LogSegmentMetadata metadata) {
        this.metadataStore.createLogSegment(txn, metadata, new Transaction.OpListener<Void>(){

            @Override
            public void onCommit(Void r) {
                BKLogWriteHandler.this.addLogSegmentToCache(metadata.getSegmentName(), metadata);
            }

            @Override
            public void onAbort(Throwable t) {
            }
        });
    }

    void deleteLogSegment(Transaction<Object> txn, final LogSegmentMetadata metadata) {
        this.metadataStore.deleteLogSegment(txn, metadata, new Transaction.OpListener<Void>(){

            @Override
            public void onCommit(Void r) {
                BKLogWriteHandler.this.removeLogSegmentFromCache(metadata.getSegmentName());
            }

            @Override
            public void onAbort(Throwable t) {
            }
        });
    }

    void deleteLog() throws IOException {
        this.lock.checkOwnershipAndReacquire();
        Utils.ioResult(this.purgeLogSegmentsOlderThanTxnId(-1L));
        Utils.closeQuietly(this.lock);
    }

    CompletableFuture<? extends DistributedLock> lockHandler() {
        if (null != this.lockFuture) {
            return this.lockFuture;
        }
        this.lockFuture = this.lock.asyncAcquire();
        return this.lockFuture;
    }

    CompletableFuture<Void> unlockHandler() {
        if (null != this.lockFuture) {
            return this.lock.asyncClose();
        }
        return FutureUtils.Void();
    }

    public BKLogSegmentWriter startLogSegment(long txId) throws IOException {
        return this.startLogSegment(txId, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BKLogSegmentWriter startLogSegment(long txId, boolean bestEffort, boolean allowMaxTxID) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        boolean success = false;
        try {
            BKLogSegmentWriter writer = this.doStartLogSegment(txId, bestEffort, allowMaxTxID);
            success = true;
            BKLogSegmentWriter bKLogSegmentWriter = writer;
            return bKLogSegmentWriter;
        }
        finally {
            if (success) {
                this.openOpStats.registerSuccessfulEvent(stopwatch.stop().elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
            } else {
                this.openOpStats.registerFailedEvent(stopwatch.stop().elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
            }
        }
    }

    protected long assignLogSegmentSequenceNumber() throws IOException {
        long logSegmentSeqNo = 0L;
        boolean logSegmentsFound = false;
        if (LogSegmentMetadata.supportsLogSegmentSequenceNo(this.conf.getDLLedgerMetadataLayoutVersion())) {
            List<LogSegmentMetadata> ledgerListDesc = this.getCachedLogSegments(LogSegmentMetadata.DESC_COMPARATOR);
            Long nextLogSegmentSeqNo = DLUtils.nextLogSegmentSequenceNumber(ledgerListDesc);
            if (null == nextLogSegmentSeqNo) {
                logSegmentsFound = false;
                logSegmentSeqNo = this.conf.getFirstLogSegmentSequenceNumber();
            } else {
                logSegmentsFound = true;
                logSegmentSeqNo = nextLogSegmentSeqNo;
            }
        }
        if (!logSegmentsFound && 0L == this.maxLogSegmentSequenceNo.getSequenceNumber()) {
            LOG.info("No max ledger sequence number found while creating log segment {} for {}.", (Object)logSegmentSeqNo, (Object)this.getFullyQualifiedName());
        } else if (this.maxLogSegmentSequenceNo.getSequenceNumber() + 1L != logSegmentSeqNo && this.maxLogSegmentSequenceNo.getSequenceNumber() != logSegmentSeqNo) {
            LOG.warn("Unexpected max log segment sequence number {} for {} : list of cached segments = {}", new Object[]{this.maxLogSegmentSequenceNo.getSequenceNumber(), this.getFullyQualifiedName(), this.getCachedLogSegments(LogSegmentMetadata.DESC_COMPARATOR)});
            throw new DLIllegalStateException("Unexpected max log segment sequence number " + this.maxLogSegmentSequenceNo.getSequenceNumber() + " for " + this.getFullyQualifiedName() + ", expected " + (logSegmentSeqNo - 1L));
        }
        return logSegmentSeqNo;
    }

    protected BKLogSegmentWriter doStartLogSegment(long txId, boolean bestEffort, boolean allowMaxTxID) throws IOException {
        return Utils.ioResult(this.asyncStartLogSegment(txId, bestEffort, allowMaxTxID));
    }

    protected CompletableFuture<BKLogSegmentWriter> asyncStartLogSegment(final long txId, final boolean bestEffort, final boolean allowMaxTxID) {
        final CompletableFuture<BKLogSegmentWriter> promise = new CompletableFuture<BKLogSegmentWriter>();
        try {
            this.lock.checkOwnershipAndReacquire();
        }
        catch (LockingException e) {
            FutureUtils.completeExceptionally(promise, (Throwable)e);
            return promise;
        }
        this.fetchForWrite.whenComplete((BiConsumer)new FutureEventListener<Versioned<List<LogSegmentMetadata>>>(){

            public void onFailure(Throwable cause) {
                FutureUtils.completeExceptionally((CompletableFuture)promise, (Throwable)cause);
            }

            public void onSuccess(Versioned<List<LogSegmentMetadata>> list) {
                BKLogWriteHandler.this.doStartLogSegment(txId, bestEffort, allowMaxTxID, promise);
            }
        });
        return promise;
    }

    protected void doStartLogSegment(final long txId, final boolean bestEffort, boolean allowMaxTxID, final CompletableFuture<BKLogSegmentWriter> promise) {
        if (txId < 0L || !allowMaxTxID && txId == Long.MAX_VALUE) {
            FutureUtils.completeExceptionally(promise, (Throwable)new IOException("Invalid Transaction Id " + txId));
            return;
        }
        long highestTxIdWritten = this.maxTxId.get();
        if (txId < highestTxIdWritten) {
            if (highestTxIdWritten == Long.MAX_VALUE) {
                LOG.error("We've already marked the stream as ended and attempting to start a new log segment");
                FutureUtils.completeExceptionally(promise, (Throwable)new EndOfStreamException("Writing to a stream after it has been marked as completed"));
                return;
            }
            LOG.error("We've already seen TxId {} the max TXId is {}", (Object)txId, (Object)highestTxIdWritten);
            FutureUtils.completeExceptionally(promise, (Throwable)new TransactionIdOutOfOrderException(txId, highestTxIdWritten));
            return;
        }
        try {
            this.logSegmentAllocator.allocate();
        }
        catch (IOException e) {
            this.failStartLogSegment(promise, bestEffort, e);
            return;
        }
        final Transaction<Object> txn = this.streamMetadataStore.newTransaction();
        try {
            FailpointUtils.checkFailPoint(FailpointUtils.FailPointName.FP_StartLogSegmentBeforeLedgerCreate);
        }
        catch (IOException ioe) {
            this.failStartLogSegment(promise, bestEffort, ioe);
            return;
        }
        this.logSegmentAllocator.tryObtain(txn, NULL_OP_LISTENER).whenComplete((BiConsumer)new FutureEventListener<LogSegmentEntryWriter>(){

            public void onSuccess(LogSegmentEntryWriter entryWriter) {
                BKLogWriteHandler.this.createInprogressLogSegment(txn, txId, entryWriter, bestEffort, promise);
            }

            public void onFailure(Throwable cause) {
                BKLogWriteHandler.this.failStartLogSegment(promise, bestEffort, cause);
            }
        });
    }

    private void failStartLogSegment(CompletableFuture<BKLogSegmentWriter> promise, boolean bestEffort, Throwable cause) {
        if (bestEffort) {
            FutureUtils.complete(promise, null);
        } else {
            FutureUtils.completeExceptionally(promise, (Throwable)cause);
        }
    }

    private void createInprogressLogSegment(Transaction<Object> txn, final long txId, final LogSegmentEntryWriter entryWriter, boolean bestEffort, final CompletableFuture<BKLogSegmentWriter> promise) {
        long logSegmentSeqNo;
        try {
            FailpointUtils.checkFailPoint(FailpointUtils.FailPointName.FP_StartLogSegmentOnAssignLogSegmentSequenceNumber);
            logSegmentSeqNo = this.assignLogSegmentSequenceNumber();
        }
        catch (IOException e) {
            txn.abort(e);
            this.failStartLogSegment(promise, bestEffort, e);
            return;
        }
        String inprogressZnodePath = this.inprogressZNode(entryWriter.getLogSegmentId(), txId, logSegmentSeqNo);
        final LogSegmentMetadata l = new LogSegmentMetadata.LogSegmentMetadataBuilder(inprogressZnodePath, this.conf.getDLLedgerMetadataLayoutVersion(), entryWriter.getLogSegmentId(), txId).setLogSegmentSequenceNo(logSegmentSeqNo).setRegionId(this.regionId).setEnvelopeEntries(LogSegmentMetadata.supportsEnvelopedEntries(this.conf.getDLLedgerMetadataLayoutVersion())).build();
        this.writeLogSegment(txn, l);
        LOG.debug("Try storing max sequence number in startLogSegment {} : {}", (Object)inprogressZnodePath, (Object)logSegmentSeqNo);
        this.storeMaxSequenceNumber(txn, this.maxLogSegmentSequenceNo, logSegmentSeqNo, true);
        txn.execute().whenCompleteAsync((BiConsumer)new FutureEventListener<Void>(){

            public void onSuccess(Void value) {
                try {
                    FutureUtils.complete((CompletableFuture)promise, (Object)new BKLogSegmentWriter(BKLogWriteHandler.this.getFullyQualifiedName(), l.getSegmentName(), BKLogWriteHandler.this.conf, BKLogWriteHandler.this.conf.getDLLedgerMetadataLayoutVersion(), entryWriter, BKLogWriteHandler.this.lock, txId, logSegmentSeqNo, BKLogWriteHandler.this.scheduler, BKLogWriteHandler.this.statsLogger, BKLogWriteHandler.this.perLogStatsLogger, BKLogWriteHandler.this.alertStatsLogger, BKLogWriteHandler.this.writeLimiter, BKLogWriteHandler.this.featureProvider, BKLogWriteHandler.this.dynConf));
                }
                catch (IOException ioe) {
                    BKLogWriteHandler.this.failStartLogSegment(promise, false, ioe);
                }
            }

            public void onFailure(Throwable cause) {
                BKLogWriteHandler.this.failStartLogSegment(promise, false, cause);
            }
        }, (Executor)this.scheduler);
    }

    boolean shouldStartNewSegment(BKLogSegmentWriter writer) {
        return this.rollingPolicy.shouldRollover(writer, this.lastLedgerRollingTimeMillis);
    }

    CompletableFuture<LogSegmentMetadata> completeAndCloseLogSegment(BKLogSegmentWriter writer) {
        CompletableFuture<LogSegmentMetadata> promise = new CompletableFuture<LogSegmentMetadata>();
        this.completeAndCloseLogSegment(writer, promise);
        return promise;
    }

    private void completeAndCloseLogSegment(final BKLogSegmentWriter writer, final CompletableFuture<LogSegmentMetadata> promise) {
        writer.asyncClose().whenComplete((BiConsumer)new FutureEventListener<Void>(){

            public void onSuccess(Void value) {
                if (writer.shouldFailCompleteLogSegment()) {
                    FutureUtils.completeExceptionally((CompletableFuture)promise, (Throwable)new IOException("LogSegmentWriter for " + writer.getFullyQualifiedLogSegment() + " is already in error."));
                    return;
                }
                BKLogWriteHandler.this.doCompleteAndCloseLogSegment(BKLogWriteHandler.this.inprogressZNodeName(writer.getLogSegmentId(), writer.getStartTxId(), writer.getLogSegmentSequenceNumber()), writer.getLogSegmentSequenceNumber(), writer.getLogSegmentId(), writer.getStartTxId(), writer.getLastTxId(), writer.getPositionWithinLogSegment(), writer.getLastDLSN().getEntryId(), writer.getLastDLSN().getSlotId(), promise);
            }

            public void onFailure(Throwable cause) {
                FutureUtils.completeExceptionally((CompletableFuture)promise, (Throwable)cause);
            }
        });
    }

    @VisibleForTesting
    LogSegmentMetadata completeAndCloseLogSegment(long logSegmentSeqNo, long logSegmentId, long firstTxId, long lastTxId, int recordCount) throws IOException {
        return this.completeAndCloseLogSegment(this.inprogressZNodeName(logSegmentId, firstTxId, logSegmentSeqNo), logSegmentSeqNo, logSegmentId, firstTxId, lastTxId, recordCount, -1L, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LogSegmentMetadata completeAndCloseLogSegment(String inprogressZnodeName, long logSegmentSeqNo, long logSegmentId, long firstTxId, long lastTxId, int recordCount, long lastEntryId, long lastSlotId) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        boolean success = false;
        try {
            LogSegmentMetadata completedLogSegment = this.doCompleteAndCloseLogSegment(inprogressZnodeName, logSegmentSeqNo, logSegmentId, firstTxId, lastTxId, recordCount, lastEntryId, lastSlotId);
            success = true;
            LogSegmentMetadata logSegmentMetadata = completedLogSegment;
            return logSegmentMetadata;
        }
        finally {
            if (success) {
                this.closeOpStats.registerSuccessfulEvent(stopwatch.stop().elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
            } else {
                this.closeOpStats.registerFailedEvent(stopwatch.stop().elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
            }
        }
    }

    protected long computeStartSequenceId(LogSegmentMetadata segment) throws IOException {
        if (!segment.isInProgress()) {
            return segment.getStartSequenceId();
        }
        long startSequenceId = -1L;
        if (LogSegmentMetadata.supportsSequenceId(this.conf.getDLLedgerMetadataLayoutVersion()) && segment.supportsSequenceId()) {
            List<LogSegmentMetadata> logSegmentDescList = this.getCachedLogSegments(LogSegmentMetadata.DESC_COMPARATOR);
            startSequenceId = DLUtils.computeStartSequenceId(logSegmentDescList, segment);
        }
        return startSequenceId;
    }

    protected LogSegmentMetadata doCompleteAndCloseLogSegment(String inprogressZnodeName, long logSegmentSeqNo, long logSegmentId, long firstTxId, long lastTxId, int recordCount, long lastEntryId, long lastSlotId) throws IOException {
        CompletableFuture<LogSegmentMetadata> promise = new CompletableFuture<LogSegmentMetadata>();
        this.doCompleteAndCloseLogSegment(inprogressZnodeName, logSegmentSeqNo, logSegmentId, firstTxId, lastTxId, recordCount, lastEntryId, lastSlotId, promise);
        return Utils.ioResult(promise);
    }

    protected void doCompleteAndCloseLogSegment(final String inprogressZnodeName, final long logSegmentSeqNo, final long logSegmentId, final long firstTxId, final long lastTxId, final int recordCount, final long lastEntryId, final long lastSlotId, final CompletableFuture<LogSegmentMetadata> promise) {
        this.fetchForWrite.whenComplete((BiConsumer)new FutureEventListener<Versioned<List<LogSegmentMetadata>>>(){

            public void onFailure(Throwable cause) {
                FutureUtils.completeExceptionally((CompletableFuture)promise, (Throwable)cause);
            }

            public void onSuccess(Versioned<List<LogSegmentMetadata>> segments) {
                BKLogWriteHandler.this.doCompleteAndCloseLogSegmentAfterLogSegmentListFetched(inprogressZnodeName, logSegmentSeqNo, logSegmentId, firstTxId, lastTxId, recordCount, lastEntryId, lastSlotId, promise);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCompleteAndCloseLogSegmentAfterLogSegmentListFetched(final String inprogressZnodeName, long logSegmentSeqNo, long logSegmentId, long firstTxId, long lastTxId, int recordCount, long lastEntryId, long lastSlotId, final CompletableFuture<LogSegmentMetadata> promise) {
        long startSequenceId;
        try {
            this.lock.checkOwnershipAndReacquire();
        }
        catch (IOException ioe) {
            FutureUtils.completeExceptionally(promise, (Throwable)ioe);
            return;
        }
        LOG.debug("Completing and Closing Log Segment {} {}", (Object)firstTxId, (Object)lastTxId);
        LogSegmentMetadata inprogressLogSegment = this.readLogSegmentFromCache(inprogressZnodeName);
        if (inprogressLogSegment.getLogSegmentId() != logSegmentId) {
            FutureUtils.completeExceptionally(promise, (Throwable)new IOException("Active ledger has different ID to inprogress. " + inprogressLogSegment.getLogSegmentId() + " found, " + logSegmentId + " expected"));
            return;
        }
        if (inprogressLogSegment.getFirstTxId() != firstTxId) {
            FutureUtils.completeExceptionally(promise, (Throwable)new IOException("Transaction id not as expected, " + inprogressLogSegment.getFirstTxId() + " found, " + firstTxId + " expected"));
            return;
        }
        if (this.validateLogSegmentSequenceNumber) {
            LinkedList<Long> linkedList = this.inprogressLSSNs;
            synchronized (linkedList) {
                if (this.inprogressLSSNs.isEmpty()) {
                    FutureUtils.completeExceptionally(promise, (Throwable)new UnexpectedException("Didn't find matched inprogress log segments when completing inprogress " + inprogressLogSegment));
                    return;
                }
                long leastInprogressLSSN = this.inprogressLSSNs.getFirst();
                if (inprogressLogSegment.getLogSegmentSequenceNumber() != logSegmentSeqNo || leastInprogressLSSN != logSegmentSeqNo) {
                    FutureUtils.completeExceptionally(promise, (Throwable)new UnexpectedException("Didn't find matched inprogress log segments when completing inprogress " + inprogressLogSegment));
                    return;
                }
            }
        }
        long maxSeqNo = Math.max(logSegmentSeqNo, this.maxLogSegmentSequenceNo.getSequenceNumber());
        if (this.maxLogSegmentSequenceNo.getSequenceNumber() == logSegmentSeqNo || this.maxLogSegmentSequenceNo.getSequenceNumber() == logSegmentSeqNo + 1L) {
            LOG.info("Try storing max sequence number {} in completing {}.", new Object[]{logSegmentSeqNo, inprogressLogSegment.getZkPath()});
        } else {
            LOG.warn("Unexpected max ledger sequence number {} found while completing log segment {} for {}", new Object[]{this.maxLogSegmentSequenceNo.getSequenceNumber(), logSegmentSeqNo, this.getFullyQualifiedName()});
            if (this.validateLogSegmentSequenceNumber) {
                FutureUtils.completeExceptionally(promise, (Throwable)new DLIllegalStateException("Unexpected max log segment sequence number " + this.maxLogSegmentSequenceNo.getSequenceNumber() + " for " + this.getFullyQualifiedName() + ", expected " + (logSegmentSeqNo - 1L)));
                return;
            }
        }
        String pathForCompletedLedger = this.completedLedgerZNode(firstTxId, lastTxId, logSegmentSeqNo);
        try {
            startSequenceId = this.computeStartSequenceId(inprogressLogSegment);
        }
        catch (IOException ioe) {
            FutureUtils.completeExceptionally(promise, (Throwable)ioe);
            return;
        }
        final LogSegmentMetadata completedLogSegment = inprogressLogSegment.completeLogSegment(pathForCompletedLedger, lastTxId, recordCount, lastEntryId, lastSlotId, startSequenceId);
        this.setLastLedgerRollingTimeMillis(completedLogSegment.getCompletionTime());
        Transaction<Object> txn = this.streamMetadataStore.newTransaction();
        this.writeLogSegment(txn, completedLogSegment);
        this.deleteLogSegment(txn, inprogressLogSegment);
        this.storeMaxSequenceNumber(txn, this.maxLogSegmentSequenceNo, maxSeqNo, false);
        LOG.debug("Trying storing LastTxId in Finalize Path {} LastTxId {}", (Object)pathForCompletedLedger, (Object)lastTxId);
        this.storeMaxTxId(txn, this.maxTxId, lastTxId);
        txn.execute().whenCompleteAsync((BiConsumer)new FutureEventListener<Void>(){

            public void onSuccess(Void value) {
                LOG.info("Completed {} to {} for {} : {}", new Object[]{inprogressZnodeName, completedLogSegment.getSegmentName(), BKLogWriteHandler.this.getFullyQualifiedName(), completedLogSegment});
                FutureUtils.complete((CompletableFuture)promise, (Object)completedLogSegment);
            }

            public void onFailure(Throwable cause) {
                FutureUtils.completeExceptionally((CompletableFuture)promise, (Throwable)cause);
            }
        }, (Executor)this.scheduler);
    }

    public CompletableFuture<Long> recoverIncompleteLogSegments() {
        try {
            FailpointUtils.checkFailPoint(FailpointUtils.FailPointName.FP_RecoverIncompleteLogSegments);
        }
        catch (IOException ioe) {
            return FutureUtils.exception((Throwable)ioe);
        }
        return this.getCachedLogSegmentsAfterFirstFetch(LogSegmentMetadata.COMPARATOR).thenCompose(this.recoverLogSegmentsFunction);
    }

    CompletableFuture<List<LogSegmentMetadata>> setLogSegmentsOlderThanDLSNTruncated(DLSN dlsn) {
        if (DLSN.InvalidDLSN == dlsn) {
            ArrayList emptyList = new ArrayList(0);
            return FutureUtils.value(emptyList);
        }
        return this.getCachedLogSegmentsAfterFirstFullFetch(LogSegmentMetadata.COMPARATOR).thenCompose(logSegments -> this.setLogSegmentsOlderThanDLSNTruncated((List<LogSegmentMetadata>)logSegments, dlsn));
    }

    private CompletableFuture<List<LogSegmentMetadata>> setLogSegmentsOlderThanDLSNTruncated(List<LogSegmentMetadata> logSegments, DLSN dlsn) {
        LogSegmentMetadata l;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting truncation status on logs older than {} from {} for {}", new Object[]{dlsn, logSegments, this.getFullyQualifiedName()});
        }
        ArrayList<LogSegmentMetadata> truncateList = new ArrayList<LogSegmentMetadata>(logSegments.size());
        LogSegmentMetadata partialTruncate = null;
        LOG.info("{}: Truncating log segments older than {}", (Object)this.getFullyQualifiedName(), (Object)dlsn);
        for (int i = 0; i < logSegments.size() && !(l = logSegments.get(i)).isInProgress(); ++i) {
            if (l.getLastDLSN().compareTo(dlsn) < 0) {
                LOG.debug("{}: Truncating log segment {} ", (Object)this.getFullyQualifiedName(), (Object)l);
                truncateList.add(l);
                continue;
            }
            if (l.getFirstDLSN().compareTo(dlsn) >= 0) break;
            if (null != partialTruncate) {
                String logMsg = String.format("Potential metadata inconsistency for stream %s at segment %s", this.getFullyQualifiedName(), l);
                LOG.error(logMsg);
                return FutureUtils.exception((Throwable)new DLIllegalStateException(logMsg));
            }
            LOG.info("{}: Partially truncating log segment {} older than {}.", new Object[]{this.getFullyQualifiedName(), l, dlsn});
            partialTruncate = l;
        }
        return this.setLogSegmentTruncationStatus(truncateList, partialTruncate, dlsn);
    }

    private int getNumCandidateLogSegmentsToPurge(List<LogSegmentMetadata> logSegments) {
        if (logSegments.isEmpty()) {
            return 0;
        }
        int numCandidateLogSegments = 0;
        for (LogSegmentMetadata segment : logSegments) {
            if (segment.isInProgress()) break;
            ++numCandidateLogSegments;
        }
        return numCandidateLogSegments - 1;
    }

    CompletableFuture<List<LogSegmentMetadata>> purgeLogSegmentsOlderThanTimestamp(final long minTimestampToKeep) {
        if (minTimestampToKeep >= Utils.nowInMillis()) {
            return FutureUtils.exception((Throwable)new IllegalArgumentException("Invalid timestamp " + minTimestampToKeep + " to purge logs for " + this.getFullyQualifiedName()));
        }
        return this.getCachedLogSegmentsAfterFirstFullFetch(LogSegmentMetadata.COMPARATOR).thenCompose(new Function<List<LogSegmentMetadata>, CompletableFuture<List<LogSegmentMetadata>>>(){

            @Override
            public CompletableFuture<List<LogSegmentMetadata>> apply(List<LogSegmentMetadata> logSegments) {
                LogSegmentMetadata l;
                ArrayList<LogSegmentMetadata> purgeList = new ArrayList<LogSegmentMetadata>(logSegments.size());
                int numCandidates = BKLogWriteHandler.this.getNumCandidateLogSegmentsToPurge(logSegments);
                for (int iterator = 0; !(iterator >= numCandidates || !(l = logSegments.get(iterator)).isTruncated() && BKLogWriteHandler.this.conf.getExplicitTruncationByApplication() || l.isInProgress() || l.getCompletionTime() >= minTimestampToKeep); ++iterator) {
                    purgeList.add(l);
                }
                LOG.info("Deleting log segments older than {} for {} : {}", new Object[]{minTimestampToKeep, BKLogWriteHandler.this.getFullyQualifiedName(), purgeList});
                return BKLogWriteHandler.this.deleteLogSegments(purgeList);
            }
        });
    }

    CompletableFuture<List<LogSegmentMetadata>> purgeLogSegmentsOlderThanTxnId(long minTxIdToKeep) {
        return this.getCachedLogSegmentsAfterFirstFullFetch(LogSegmentMetadata.COMPARATOR).thenCompose(logSegments -> {
            int numLogSegmentsToProcess = minTxIdToKeep < 0L ? logSegments.size() : this.getNumCandidateLogSegmentsToPurge((List<LogSegmentMetadata>)logSegments);
            ArrayList purgeList = Lists.newArrayListWithExpectedSize((int)numLogSegmentsToProcess);
            for (int iterator = 0; iterator < numLogSegmentsToProcess; ++iterator) {
                LogSegmentMetadata l = (LogSegmentMetadata)logSegments.get(iterator);
                if (minTxIdToKeep >= 0L && (!l.isTruncated() && this.conf.getExplicitTruncationByApplication() || l.isInProgress() || l.getLastTxId() >= minTxIdToKeep)) break;
                purgeList.add(l);
            }
            return this.deleteLogSegments(purgeList);
        });
    }

    private CompletableFuture<List<LogSegmentMetadata>> setLogSegmentTruncationStatus(List<LogSegmentMetadata> truncateList, LogSegmentMetadata partialTruncate, DLSN minActiveDLSN) {
        ArrayList listToTruncate = Lists.newArrayListWithCapacity((int)(truncateList.size() + 1));
        ArrayList listAfterTruncated = Lists.newArrayListWithCapacity((int)(truncateList.size() + 1));
        Transaction<Object> updateTxn = this.metadataUpdater.transaction();
        for (LogSegmentMetadata l : truncateList) {
            if (l.isTruncated()) continue;
            LogSegmentMetadata newSegment = this.metadataUpdater.setLogSegmentTruncated(updateTxn, l);
            listToTruncate.add(l);
            listAfterTruncated.add(newSegment);
        }
        if (null != partialTruncate && (partialTruncate.isNonTruncated() || partialTruncate.isPartiallyTruncated() && partialTruncate.getMinActiveDLSN().compareTo(minActiveDLSN) < 0)) {
            LogSegmentMetadata newSegment = this.metadataUpdater.setLogSegmentPartiallyTruncated(updateTxn, partialTruncate, minActiveDLSN);
            listToTruncate.add(partialTruncate);
            listAfterTruncated.add(newSegment);
        }
        return updateTxn.execute().thenApply(value -> {
            for (int i = 0; i < listToTruncate.size(); ++i) {
                this.removeLogSegmentFromCache(((LogSegmentMetadata)listToTruncate.get(i)).getSegmentName());
                LogSegmentMetadata newSegment = (LogSegmentMetadata)listAfterTruncated.get(i);
                this.addLogSegmentToCache(newSegment.getSegmentName(), newSegment);
            }
            return listAfterTruncated;
        });
    }

    private CompletableFuture<List<LogSegmentMetadata>> deleteLogSegments(List<LogSegmentMetadata> logs) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Purging logs for {} : {}", (Object)this.getFullyQualifiedName(), logs);
        }
        return FutureUtils.processList(logs, segment -> this.deleteLogSegment((LogSegmentMetadata)segment), (ExecutorService)this.scheduler);
    }

    private CompletableFuture<LogSegmentMetadata> deleteLogSegment(LogSegmentMetadata ledgerMetadata) {
        LOG.info("Deleting ledger {} for {}", (Object)ledgerMetadata, (Object)this.getFullyQualifiedName());
        final CompletableFuture<LogSegmentMetadata> promise = new CompletableFuture<LogSegmentMetadata>();
        final Stopwatch stopwatch = Stopwatch.createStarted();
        promise.whenComplete((BiConsumer)new FutureEventListener<LogSegmentMetadata>(){

            public void onSuccess(LogSegmentMetadata segment) {
                BKLogWriteHandler.this.deleteOpStats.registerSuccessfulEvent(stopwatch.stop().elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
            }

            public void onFailure(Throwable cause) {
                BKLogWriteHandler.this.deleteOpStats.registerFailedEvent(stopwatch.stop().elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
            }
        });
        this.entryStore.deleteLogSegment(ledgerMetadata).whenComplete((BiConsumer)new FutureEventListener<LogSegmentMetadata>(){

            public void onFailure(Throwable cause) {
                FutureUtils.completeExceptionally((CompletableFuture)promise, (Throwable)cause);
            }

            public void onSuccess(LogSegmentMetadata segment) {
                BKLogWriteHandler.this.deleteLogSegmentMetadata(segment, promise);
            }
        });
        return promise;
    }

    private void deleteLogSegmentMetadata(final LogSegmentMetadata segmentMetadata, final CompletableFuture<LogSegmentMetadata> promise) {
        Transaction<Object> deleteTxn = this.metadataStore.transaction();
        this.metadataStore.deleteLogSegment(deleteTxn, segmentMetadata, new Transaction.OpListener<Void>(){

            @Override
            public void onCommit(Void r) {
                BKLogWriteHandler.this.removeLogSegmentFromCache(segmentMetadata.getZNodeName());
                promise.complete(segmentMetadata);
            }

            @Override
            public void onAbort(Throwable t) {
                if (t instanceof LogSegmentNotFoundException) {
                    BKLogWriteHandler.this.removeLogSegmentFromCache(segmentMetadata.getZNodeName());
                    promise.complete(segmentMetadata);
                    return;
                }
                LOG.error("Couldn't purge {} for {}: with error {}", new Object[]{segmentMetadata, BKLogWriteHandler.this.getFullyQualifiedName(), t});
                promise.completeExceptionally(t);
            }
        });
        deleteTxn.execute();
    }

    public CompletableFuture<Void> asyncClose() {
        return Utils.closeSequence((ExecutorService)this.scheduler, this.lock, this.logSegmentAllocator);
    }

    @Override
    public CompletableFuture<Void> asyncAbort() {
        return this.asyncClose();
    }

    String completedLedgerZNodeName(long firstTxId, long lastTxId, long logSegmentSeqNo) {
        if (1 == this.conf.getLogSegmentNameVersion()) {
            return String.format("%s_%018d", "logrecs", logSegmentSeqNo);
        }
        return String.format("%s_%018d_%018d", "logrecs", firstTxId, lastTxId);
    }

    String completedLedgerZNode(long firstTxId, long lastTxId, long logSegmentSeqNo) {
        return String.format("%s/%s", this.logMetadata.getLogSegmentsPath(), this.completedLedgerZNodeName(firstTxId, lastTxId, logSegmentSeqNo));
    }

    String inprogressZNodeName(long logSegmentId, long firstTxId, long logSegmentSeqNo) {
        if (1 == this.conf.getLogSegmentNameVersion()) {
            return String.format("%s_%018d", "inprogress", logSegmentSeqNo);
        }
        return "inprogress_" + Long.toString(firstTxId, 16);
    }

    String inprogressZNode(long logSegmentId, long firstTxId, long logSegmentSeqNo) {
        return this.logMetadata.getLogSegmentsPath() + "/" + this.inprogressZNodeName(logSegmentId, firstTxId, logSegmentSeqNo);
    }

    String inprogressZNode(String inprogressZNodeName) {
        return this.logMetadata.getLogSegmentsPath() + "/" + inprogressZNodeName;
    }

    class RecoverLogSegmentFunction
    implements Function<LogSegmentMetadata, CompletableFuture<LogSegmentMetadata>> {
        RecoverLogSegmentFunction() {
        }

        @Override
        public CompletableFuture<LogSegmentMetadata> apply(LogSegmentMetadata l) {
            if (!l.isInProgress()) {
                return FutureUtils.value((Object)l);
            }
            LOG.info("Recovering last record in log segment {} for {}.", (Object)l, (Object)BKLogWriteHandler.this.getFullyQualifiedName());
            return BKLogWriteHandler.this.asyncReadLastRecord(l, true, true, true).thenCompose(lastRecord -> this.completeLogSegment(l, (LogRecordWithDLSN)lastRecord));
        }

        private CompletableFuture<LogSegmentMetadata> completeLogSegment(LogSegmentMetadata l, LogRecordWithDLSN lastRecord) {
            LOG.info("Recovered last record in log segment {} for {}.", (Object)l, (Object)BKLogWriteHandler.this.getFullyQualifiedName());
            long endTxId = -99L;
            int recordCount = 0;
            long lastEntryId = -1L;
            long lastSlotId = -1L;
            if (null != lastRecord) {
                endTxId = lastRecord.getTransactionId();
                recordCount = lastRecord.getLastPositionWithinLogSegment();
                lastEntryId = lastRecord.getDlsn().getEntryId();
                lastSlotId = lastRecord.getDlsn().getSlotId();
            }
            if (endTxId == -999L) {
                LOG.error("Unrecoverable corruption has occurred in segment " + l.toString() + " at path " + l.getZkPath() + ". Unable to continue recovery.");
                return FutureUtils.exception((Throwable)new IOException("Unrecoverable corruption, please check logs."));
            }
            if (endTxId == -99L) {
                LOG.info("Inprogress segment {} is empty, deleting", (Object)l);
                return BKLogWriteHandler.this.deleteLogSegment(l).thenApply(result -> {
                    LinkedList<Long> linkedList = BKLogWriteHandler.this.inprogressLSSNs;
                    synchronized (linkedList) {
                        BKLogWriteHandler.this.inprogressLSSNs.remove(l.getLogSegmentSequenceNumber());
                    }
                    return null;
                });
            }
            CompletableFuture<LogSegmentMetadata> promise = new CompletableFuture<LogSegmentMetadata>();
            BKLogWriteHandler.this.doCompleteAndCloseLogSegment(l.getZNodeName(), l.getLogSegmentSequenceNumber(), l.getLogSegmentId(), l.getFirstTxId(), endTxId, recordCount, lastEntryId, lastSlotId, promise);
            return promise;
        }
    }
}

