/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Map;

public final class HttpUtils {
    private static final CustomCompressor compressor = new CustomCompressor();
    private static final AsciiString TIMEOUT_EQ = AsciiString.of((CharSequence)"timeout=");

    private HttpUtils() {
    }

    private static int indexOfSlash(CharSequence str, int start) {
        for (int i = start; i < str.length(); ++i) {
            if (str.charAt(i) != '/') continue;
            return i;
        }
        return -1;
    }

    private static boolean matches(CharSequence path, int start, String what) {
        return HttpUtils.matches(path, start, what, false);
    }

    private static boolean matches(CharSequence path, int start, String what, boolean exact) {
        if (exact && path.length() - start != what.length()) {
            return false;
        }
        if (path.length() - start >= what.length()) {
            for (int i = 0; i < what.length(); ++i) {
                if (path.charAt(start + i) == what.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String removeDots(CharSequence path) {
        if (path == null) {
            return null;
        }
        StringBuilder obuf = new StringBuilder(path.length());
        int i = 0;
        while (i < path.length()) {
            int pos;
            if (HttpUtils.matches(path, i, "./")) {
                i += 2;
                continue;
            }
            if (HttpUtils.matches(path, i, "../")) {
                i += 3;
                continue;
            }
            if (HttpUtils.matches(path, i, "/./")) {
                i += 2;
                continue;
            }
            if (HttpUtils.matches(path, i, "/.", true)) {
                path = "/";
                i = 0;
                continue;
            }
            if (HttpUtils.matches(path, i, "/../")) {
                i += 3;
                pos = obuf.lastIndexOf("/");
                if (pos == -1) continue;
                obuf.delete(pos, obuf.length());
                continue;
            }
            if (HttpUtils.matches(path, i, "/..", true)) {
                path = "/";
                i = 0;
                pos = obuf.lastIndexOf("/");
                if (pos == -1) continue;
                obuf.delete(pos, obuf.length());
                continue;
            }
            if (HttpUtils.matches(path, i, ".", true) || HttpUtils.matches(path, i, "..", true)) break;
            if (path.charAt(i) == '/') {
                ++i;
                if (obuf.length() == 0 || obuf.charAt(obuf.length() - 1) != '/') {
                    obuf.append('/');
                }
            }
            if ((pos = HttpUtils.indexOfSlash(path, i)) != -1) {
                obuf.append(path, i, pos);
                i = pos;
                continue;
            }
            obuf.append(path, i, path.length());
            break;
        }
        return obuf.toString();
    }

    public static URI resolveURIReference(String base, String ref) throws URISyntaxException {
        return HttpUtils.resolveURIReference(URI.create(base), ref);
    }

    public static URI resolveURIReference(URI base, String ref) throws URISyntaxException {
        String query;
        String path;
        String authority;
        String scheme;
        URI _ref = URI.create(ref);
        if (_ref.getScheme() != null) {
            scheme = _ref.getScheme();
            authority = _ref.getAuthority();
            path = HttpUtils.removeDots(_ref.getPath());
            query = _ref.getRawQuery();
        } else {
            if (_ref.getAuthority() != null) {
                authority = _ref.getAuthority();
                path = _ref.getPath();
                query = _ref.getRawQuery();
            } else {
                if (_ref.getPath().length() == 0) {
                    path = base.getPath();
                    query = _ref.getRawQuery() != null ? _ref.getRawQuery() : base.getRawQuery();
                } else {
                    if (_ref.getPath().startsWith("/")) {
                        path = HttpUtils.removeDots(_ref.getPath());
                    } else {
                        int index;
                        String basePath = base.getPath();
                        String mergedPath = base.getAuthority() != null && basePath.length() == 0 ? "/" + _ref.getPath() : ((index = basePath.lastIndexOf(47)) > -1 ? basePath.substring(0, index + 1) + _ref.getPath() : _ref.getPath());
                        path = HttpUtils.removeDots(mergedPath);
                    }
                    query = _ref.getRawQuery();
                }
                authority = base.getAuthority();
            }
            scheme = base.getScheme();
        }
        return new URI(scheme, authority, path, query, _ref.getFragment());
    }

    static String parsePath(String uri) {
        int i;
        if (uri.charAt(0) == '/') {
            i = 0;
        } else {
            i = uri.indexOf("://");
            if (i == -1) {
                i = 0;
            } else if ((i = uri.indexOf(47, i + 3)) == -1) {
                return "/";
            }
        }
        int queryStart = uri.indexOf(63, i);
        if (queryStart == -1) {
            queryStart = uri.length();
        }
        return uri.substring(i, queryStart);
    }

    static String parseQuery(String uri) {
        int i = uri.indexOf(63);
        if (i == -1) {
            return null;
        }
        return uri.substring(i + 1, uri.length());
    }

    static String absoluteURI(String serverOrigin, HttpServerRequest req) throws URISyntaxException {
        String host;
        URI uri = new URI(req.uri());
        String scheme = uri.getScheme();
        String absoluteURI = scheme != null && (scheme.equals("http") || scheme.equals("https")) ? uri.toString() : ((host = req.host()) != null ? req.scheme() + "://" + host + uri : serverOrigin + uri);
        return absoluteURI;
    }

    static MultiMap params(String uri) {
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(uri);
        Map prms = queryStringDecoder.parameters();
        CaseInsensitiveHeaders params = new CaseInsensitiveHeaders();
        if (!prms.isEmpty()) {
            for (Map.Entry entry : prms.entrySet()) {
                params.add((String)entry.getKey(), (Iterable)entry.getValue());
            }
        }
        return params;
    }

    public static void fromVertxInitialSettings(boolean server, Http2Settings vertxSettings, io.netty.handler.codec.http2.Http2Settings nettySettings) {
        if (vertxSettings != null) {
            Map<Integer, Long> extraSettings;
            if (!server && !vertxSettings.isPushEnabled()) {
                nettySettings.pushEnabled(vertxSettings.isPushEnabled());
            }
            if (vertxSettings.getHeaderTableSize() != 4096L) {
                nettySettings.put('\u0001', Long.valueOf(vertxSettings.getHeaderTableSize()));
            }
            if (vertxSettings.getInitialWindowSize() != 65535) {
                nettySettings.initialWindowSize(vertxSettings.getInitialWindowSize());
            }
            if (vertxSettings.getMaxConcurrentStreams() != 0xFFFFFFFFL) {
                nettySettings.maxConcurrentStreams(vertxSettings.getMaxConcurrentStreams());
            }
            if (vertxSettings.getMaxFrameSize() != 16384) {
                nettySettings.maxFrameSize(vertxSettings.getMaxFrameSize());
            }
            if (vertxSettings.getMaxHeaderListSize() != Integer.MAX_VALUE) {
                nettySettings.maxHeaderListSize(vertxSettings.getMaxHeaderListSize());
            }
            if ((extraSettings = vertxSettings.getExtraSettings()) != null) {
                extraSettings.forEach((code, setting) -> nettySettings.put((char)code.intValue(), setting));
            }
        }
    }

    public static io.netty.handler.codec.http2.Http2Settings fromVertxSettings(Http2Settings settings) {
        io.netty.handler.codec.http2.Http2Settings converted = new io.netty.handler.codec.http2.Http2Settings();
        converted.pushEnabled(settings.isPushEnabled());
        converted.maxFrameSize(settings.getMaxFrameSize());
        converted.initialWindowSize(settings.getInitialWindowSize());
        converted.headerTableSize(settings.getHeaderTableSize());
        converted.maxConcurrentStreams(settings.getMaxConcurrentStreams());
        converted.maxHeaderListSize(settings.getMaxHeaderListSize());
        if (settings.getExtraSettings() != null) {
            settings.getExtraSettings().forEach((key, value) -> converted.put((char)key.intValue(), value));
        }
        return converted;
    }

    public static Http2Settings toVertxSettings(io.netty.handler.codec.http2.Http2Settings settings) {
        Long headerTableSize;
        Integer initialWindowSize;
        Integer maxFrameSize;
        Long maxHeaderListSize;
        Long maxConcurrentStreams;
        Http2Settings converted = new Http2Settings();
        Boolean pushEnabled = settings.pushEnabled();
        if (pushEnabled != null) {
            converted.setPushEnabled(pushEnabled);
        }
        if ((maxConcurrentStreams = settings.maxConcurrentStreams()) != null) {
            converted.setMaxConcurrentStreams(maxConcurrentStreams);
        }
        if ((maxHeaderListSize = settings.maxHeaderListSize()) != null) {
            converted.setMaxHeaderListSize(maxHeaderListSize);
        }
        if ((maxFrameSize = settings.maxFrameSize()) != null) {
            converted.setMaxFrameSize(maxFrameSize);
        }
        if ((initialWindowSize = settings.initialWindowSize()) != null) {
            converted.setInitialWindowSize(initialWindowSize);
        }
        if ((headerTableSize = settings.headerTableSize()) != null) {
            converted.setHeaderTableSize(headerTableSize);
        }
        settings.forEach((key, value) -> {
            if (key.charValue() > '\u0006') {
                converted.set(key.charValue(), (long)value);
            }
        });
        return converted;
    }

    static io.netty.handler.codec.http2.Http2Settings decodeSettings(String base64Settings) {
        try {
            io.netty.handler.codec.http2.Http2Settings settings = new io.netty.handler.codec.http2.Http2Settings();
            Buffer buffer = Buffer.buffer(Base64.getUrlDecoder().decode(base64Settings));
            int len = buffer.length();
            for (int pos = 0; pos < len; pos += 4) {
                int i = buffer.getUnsignedShort(pos);
                long j = buffer.getUnsignedInt(pos += 2);
                settings.put((char)i, Long.valueOf(j));
            }
            return settings;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String encodeSettings(Http2Settings settings) {
        Buffer buffer = Buffer.buffer();
        HttpUtils.fromVertxSettings(settings).forEach((c, l) -> {
            buffer.appendUnsignedShort(c.charValue());
            buffer.appendUnsignedInt((long)l);
        });
        return Base64.getUrlEncoder().encodeToString(buffer.getBytes());
    }

    public static ByteBuf generateWSCloseFrameByteBuf(short statusCode, String reason) {
        if (reason != null) {
            return Unpooled.copiedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.copyShort((int)statusCode), Unpooled.copiedBuffer((CharSequence)reason, (Charset)Charset.forName("UTF-8"))});
        }
        return Unpooled.copyShort((int)statusCode);
    }

    static String determineContentEncoding(Http2Headers headers) {
        ZlibWrapper wrapper;
        String acceptEncoding;
        String string = acceptEncoding = headers.get((Object)HttpHeaderNames.ACCEPT_ENCODING) != null ? ((CharSequence)headers.get((Object)HttpHeaderNames.ACCEPT_ENCODING)).toString() : null;
        if (acceptEncoding != null && (wrapper = compressor.determineWrapper(acceptEncoding)) != null) {
            switch (wrapper) {
                case GZIP: {
                    return "gzip";
                }
                case ZLIB: {
                    return "deflate";
                }
            }
        }
        return null;
    }

    static io.netty.handler.codec.http.HttpMethod toNettyHttpMethod(HttpMethod method, String rawMethod) {
        switch (method) {
            case CONNECT: {
                return io.netty.handler.codec.http.HttpMethod.CONNECT;
            }
            case GET: {
                return io.netty.handler.codec.http.HttpMethod.GET;
            }
            case PUT: {
                return io.netty.handler.codec.http.HttpMethod.PUT;
            }
            case POST: {
                return io.netty.handler.codec.http.HttpMethod.POST;
            }
            case DELETE: {
                return io.netty.handler.codec.http.HttpMethod.DELETE;
            }
            case HEAD: {
                return io.netty.handler.codec.http.HttpMethod.HEAD;
            }
            case OPTIONS: {
                return io.netty.handler.codec.http.HttpMethod.OPTIONS;
            }
            case TRACE: {
                return io.netty.handler.codec.http.HttpMethod.TRACE;
            }
            case PATCH: {
                return io.netty.handler.codec.http.HttpMethod.PATCH;
            }
        }
        return io.netty.handler.codec.http.HttpMethod.valueOf((String)rawMethod);
    }

    static io.netty.handler.codec.http.HttpVersion toNettyHttpVersion(HttpVersion version) {
        switch (version) {
            case HTTP_1_0: {
                return io.netty.handler.codec.http.HttpVersion.HTTP_1_0;
            }
            case HTTP_1_1: {
                return io.netty.handler.codec.http.HttpVersion.HTTP_1_1;
            }
        }
        throw new IllegalArgumentException("Unsupported HTTP version: " + (Object)((Object)version));
    }

    static HttpVersion toVertxHttpVersion(io.netty.handler.codec.http.HttpVersion version) {
        if (version == io.netty.handler.codec.http.HttpVersion.HTTP_1_0) {
            return HttpVersion.HTTP_1_0;
        }
        if (version == io.netty.handler.codec.http.HttpVersion.HTTP_1_1) {
            return HttpVersion.HTTP_1_1;
        }
        return null;
    }

    static HttpMethod toVertxMethod(String method) {
        try {
            return HttpMethod.valueOf(method);
        }
        catch (IllegalArgumentException e) {
            return HttpMethod.OTHER;
        }
    }

    public static int parseKeepAliveHeaderTimeout(CharSequence value) {
        int len = value.length();
        int pos = 0;
        while (pos < len) {
            int to;
            int next;
            int idx = AsciiString.indexOf((CharSequence)value, (char)',', (int)pos);
            if (idx == -1) {
                idx = next = len;
            } else {
                next = idx + 1;
            }
            while (pos < idx && value.charAt(pos) == ' ') {
                ++pos;
            }
            for (to = idx; to > pos && value.charAt(to - 1) == ' '; --to) {
            }
            if (AsciiString.regionMatches((CharSequence)value, (boolean)true, (int)pos, (CharSequence)TIMEOUT_EQ, (int)0, (int)TIMEOUT_EQ.length()) && (pos += TIMEOUT_EQ.length()) < to) {
                int ret = 0;
                while (pos < to) {
                    char ch;
                    if ((ch = value.charAt(pos++)) >= '0' && ch < '9') {
                        ret = ret * 10 + (ch - 48);
                        continue;
                    }
                    ret = -1;
                    break;
                }
                if (ret > -1) {
                    return ret;
                }
            }
            pos = next;
        }
        return -1;
    }

    public static void validateHeader(CharSequence name, CharSequence value) {
        HttpUtils.validateHeader(name);
        HttpUtils.validateHeader(value);
    }

    public static void validateHeader(CharSequence name, Iterable<? extends CharSequence> values) {
        HttpUtils.validateHeader(name);
        values.forEach(HttpUtils::validateHeader);
    }

    public static void validateHeader(CharSequence value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c != '\r' && c != '\n') continue;
            throw new IllegalArgumentException("Illegal header character: " + c);
        }
    }

    private static class CustomCompressor
    extends HttpContentCompressor {
        private CustomCompressor() {
        }

        public ZlibWrapper determineWrapper(String acceptEncoding) {
            return super.determineWrapper(acceptEncoding);
        }
    }
}

