/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.HashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.Set;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.net.BookieId;

public class LedgerFragment {
    private final Set<Integer> bookieIndexes;
    private final List<BookieId> ensemble;
    private final long firstEntryId;
    private final long lastKnownEntryId;
    private final long ledgerId;
    private final DistributionSchedule schedule;
    private final boolean isLedgerClosed;

    LedgerFragment(LedgerHandle lh, long firstEntryId, long lastKnownEntryId, Set<Integer> bookieIndexes) {
        this.ledgerId = lh.getId();
        this.firstEntryId = firstEntryId;
        this.lastKnownEntryId = lastKnownEntryId;
        this.bookieIndexes = bookieIndexes;
        this.ensemble = lh.getLedgerMetadata().getEnsembleAt(firstEntryId);
        this.schedule = lh.getDistributionSchedule();
        NavigableMap<Long, ? extends List<BookieId>> ensembles = lh.getLedgerMetadata().getAllEnsembles();
        this.isLedgerClosed = lh.getLedgerMetadata().isClosed() || !this.ensemble.equals(ensembles.get(ensembles.lastKey())) && lh.getLastAddConfirmed() >= (Long)ensembles.lastKey() - 1L;
    }

    LedgerFragment(LedgerFragment lf, Set<Integer> subset) {
        this.ledgerId = lf.ledgerId;
        this.firstEntryId = lf.firstEntryId;
        this.lastKnownEntryId = lf.lastKnownEntryId;
        this.bookieIndexes = subset;
        this.ensemble = lf.ensemble;
        this.schedule = lf.schedule;
        this.isLedgerClosed = lf.isLedgerClosed;
    }

    public LedgerFragment subset(Set<Integer> subset) {
        return new LedgerFragment(this, subset);
    }

    public boolean isClosed() {
        return this.isLedgerClosed;
    }

    long getLedgerId() {
        return this.ledgerId;
    }

    public long getFirstEntryId() {
        return this.firstEntryId;
    }

    public long getLastKnownEntryId() {
        return this.lastKnownEntryId;
    }

    public BookieId getAddress(int bookieIndex) {
        return this.ensemble.get(bookieIndex);
    }

    public Set<BookieId> getAddresses() {
        HashSet<BookieId> addresses = new HashSet<BookieId>();
        for (int bookieIndex : this.bookieIndexes) {
            addresses.add(this.ensemble.get(bookieIndex));
        }
        return addresses;
    }

    public Set<Integer> getBookiesIndexes() {
        return this.bookieIndexes;
    }

    public long getFirstStoredEntryId() {
        long firstEntry = -1L;
        for (int bookieIndex : this.bookieIndexes) {
            Long firstStoredEntryForBookie = this.getFirstStoredEntryId(bookieIndex);
            if (firstStoredEntryForBookie == -1L) continue;
            if (firstEntry == -1L) {
                firstEntry = firstStoredEntryForBookie;
                continue;
            }
            firstEntry = Math.min(firstEntry, firstStoredEntryForBookie);
        }
        return firstEntry;
    }

    public Long getFirstStoredEntryId(int bookieIndex) {
        long firstEntry = this.firstEntryId;
        for (int i = 0; i < this.ensemble.size() && firstEntry <= this.lastKnownEntryId; ++firstEntry, ++i) {
            if (!this.schedule.hasEntry(firstEntry, bookieIndex)) continue;
            return firstEntry;
        }
        return -1L;
    }

    public long getLastStoredEntryId() {
        long lastEntry = -1L;
        for (int bookieIndex : this.bookieIndexes) {
            Long lastStoredEntryIdForBookie = this.getLastStoredEntryId(bookieIndex);
            if (lastStoredEntryIdForBookie == -1L) continue;
            if (lastEntry == -1L) {
                lastEntry = lastStoredEntryIdForBookie;
                continue;
            }
            lastEntry = Math.max(lastEntry, lastStoredEntryIdForBookie);
        }
        return lastEntry;
    }

    public Long getLastStoredEntryId(int bookieIndex) {
        long lastEntry = this.lastKnownEntryId;
        for (int i = 0; i < this.ensemble.size() && lastEntry >= this.firstEntryId; --lastEntry, ++i) {
            if (!this.schedule.hasEntry(lastEntry, bookieIndex)) continue;
            return lastEntry;
        }
        return -1L;
    }

    public boolean isStoredEntryId(long entryId, int bookieIndex) {
        return this.schedule.hasEntry(entryId, bookieIndex);
    }

    public List<BookieId> getEnsemble() {
        return this.ensemble;
    }

    public String toString() {
        return String.format("Fragment(LedgerID: %d, FirstEntryID: %d[%d], LastKnownEntryID: %d[%d], Host: %s, Closed: %s)", this.ledgerId, this.firstEntryId, this.getFirstStoredEntryId(), this.lastKnownEntryId, this.getLastStoredEntryId(), this.getAddresses(), this.isLedgerClosed);
    }
}

