/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.util.HashedWheelTimer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookiesHealthInfo;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.client.ITopologyAwareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicyImpl;
import org.apache.bookkeeper.client.TopologyAwareEnsemblePlacementPolicy;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.feature.Feature;
import org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieNode;
import org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.bookkeeper.net.NetworkTopologyImpl;
import org.apache.bookkeeper.net.Node;
import org.apache.bookkeeper.proto.BookieAddressResolver;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionAwareEnsemblePlacementPolicy
extends RackawareEnsemblePlacementPolicy {
    static final Logger LOG = LoggerFactory.getLogger(RegionAwareEnsemblePlacementPolicy.class);
    public static final String REPP_REGIONS_TO_WRITE = "reppRegionsToWrite";
    public static final String REPP_MINIMUM_REGIONS_FOR_DURABILITY = "reppMinimumRegionsForDurability";
    public static final String REPP_ENABLE_DURABILITY_ENFORCEMENT_IN_REPLACE = "reppEnableDurabilityEnforcementInReplace";
    public static final String REPP_DISABLE_DURABILITY_FEATURE_NAME = "reppDisableDurabilityFeatureName";
    public static final String REPP_DISALLOW_BOOKIE_PLACEMENT_IN_REGION_FEATURE_NAME = "reppDisallowBookiePlacementInRegionFeatureName";
    public static final String REPP_DISABLE_DURABILITY_ENFORCEMENT_FEATURE = "reppDisableDurabilityEnforcementFeature";
    public static final String REPP_ENABLE_VALIDATION = "reppEnableValidation";
    public static final String REGION_AWARE_ANOMALOUS_ENSEMBLE = "region_aware_anomalous_ensemble";
    static final int MINIMUM_REGIONS_FOR_DURABILITY_DEFAULT = 2;
    static final int REGIONID_DISTANCE_FROM_LEAVES = 2;
    static final String UNKNOWN_REGION = "UnknownRegion";
    static final int REMOTE_NODE_IN_REORDER_SEQUENCE = 2;
    protected final Map<String, TopologyAwareEnsemblePlacementPolicy> perRegionPlacement = new HashMap<String, TopologyAwareEnsemblePlacementPolicy>();
    protected final ConcurrentMap<BookieId, String> address2Region = new ConcurrentHashMap<BookieId, String>();
    protected FeatureProvider featureProvider;
    protected String disallowBookiePlacementInRegionFeatureName;
    protected String myRegion = null;
    protected int minRegionsForDurability = 0;
    protected boolean enableValidation = true;
    protected boolean enforceDurabilityInReplace = false;
    protected Feature disableDurabilityFeature;
    private int lastRegionIndex = 0;

    RegionAwareEnsemblePlacementPolicy() {
    }

    protected String getLocalRegion(BookieNode node) {
        if (null == node || null == node.getAddr()) {
            return UNKNOWN_REGION;
        }
        return this.getRegion(node.getAddr());
    }

    protected String getRegion(BookieId addr) {
        String region = (String)this.address2Region.get(addr);
        if (null == region) {
            region = this.parseBookieRegion(addr);
            this.address2Region.putIfAbsent(addr, region);
        }
        return region;
    }

    protected String parseBookieRegion(BookieId addr) {
        String networkLocation = this.resolveNetworkLocation(addr);
        if ("/default-region/default-rack".equals(networkLocation)) {
            return UNKNOWN_REGION;
        }
        String[] parts = networkLocation.split("/");
        if (parts.length <= 1) {
            return UNKNOWN_REGION;
        }
        return parts[1];
    }

    @Override
    public void handleBookiesThatLeft(Set<BookieId> leftBookies) {
        super.handleBookiesThatLeft(leftBookies);
        for (TopologyAwareEnsemblePlacementPolicy policy : this.perRegionPlacement.values()) {
            policy.handleBookiesThatLeft(leftBookies);
        }
    }

    @Override
    public void handleBookiesThatJoined(Set<BookieId> joinedBookies) {
        HashMap<String, HashSet<BookieId>> perRegionClusterChange = new HashMap<String, HashSet<BookieId>>();
        for (BookieId bookieId : joinedBookies) {
            HashSet<BookieId> regionSet;
            BookieNode node = this.createBookieNode(bookieId);
            this.topology.add(node);
            this.knownBookies.put(bookieId, node);
            this.historyBookies.put(bookieId, node);
            String region = this.getLocalRegion(node);
            if (null == this.perRegionPlacement.get(region)) {
                this.perRegionPlacement.put(region, new RackawareEnsemblePlacementPolicy().initialize(this.dnsResolver, this.timer, this.reorderReadsRandom, this.stabilizePeriodSeconds, this.reorderThresholdPendingRequests, this.isWeighted, this.maxWeightMultiple, this.minNumRacksPerWriteQuorum, this.enforceMinNumRacksPerWriteQuorum, this.ignoreLocalNodeInPlacementPolicy, this.statsLogger, this.bookieAddressResolver).withDefaultRack("/default-region/default-rack"));
            }
            if (null == (regionSet = (HashSet<BookieId>)perRegionClusterChange.get(region))) {
                regionSet = new HashSet<BookieId>();
                regionSet.add(bookieId);
                perRegionClusterChange.put(region, regionSet);
            } else {
                regionSet.add(bookieId);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Cluster changed : bookie {} joined the cluster.", (Object)bookieId);
        }
        for (Map.Entry entry : this.perRegionPlacement.entrySet()) {
            HashSet<BookieId> regionSet = (HashSet<BookieId>)perRegionClusterChange.get(entry.getKey());
            if (null == regionSet) {
                regionSet = new HashSet<BookieId>();
            }
            ((TopologyAwareEnsemblePlacementPolicy)entry.getValue()).handleBookiesThatJoined(regionSet);
        }
    }

    @Override
    public void onBookieRackChange(List<BookieId> bookieAddressList) {
        this.rwLock.writeLock().lock();
        try {
            bookieAddressList.forEach(bookieAddress -> {
                try {
                    BookieNode node = (BookieNode)this.knownBookies.get(bookieAddress);
                    if (node != null) {
                        String newRegion;
                        String oldRegion;
                        BookieNode newNode = this.createBookieNode((BookieId)bookieAddress);
                        if (!newNode.getNetworkLocation().equals(node.getNetworkLocation())) {
                            this.topology.remove(node);
                            this.topology.add(newNode);
                            this.knownBookies.put(bookieAddress, newNode);
                            this.historyBookies.put(bookieAddress, newNode);
                        }
                        if ((oldRegion = this.getRegion((BookieId)bookieAddress)).equals(newRegion = this.parseBookieRegion(newNode.getAddr()))) {
                            TopologyAwareEnsemblePlacementPolicy regionPlacement = this.perRegionPlacement.get(oldRegion);
                            regionPlacement.onBookieRackChange(Collections.singletonList(bookieAddress));
                        } else {
                            this.address2Region.put((BookieId)bookieAddress, newRegion);
                            TopologyAwareEnsemblePlacementPolicy oldRegionPlacement = this.perRegionPlacement.get(oldRegion);
                            oldRegionPlacement.handleBookiesThatLeft(Collections.singleton(bookieAddress));
                            TopologyAwareEnsemblePlacementPolicy newRegionPlacement = this.perRegionPlacement.get(newRegion);
                            if (newRegionPlacement == null) {
                                newRegionPlacement = new RackawareEnsemblePlacementPolicy().initialize(this.dnsResolver, this.timer, this.reorderReadsRandom, this.stabilizePeriodSeconds, this.reorderThresholdPendingRequests, this.isWeighted, this.maxWeightMultiple, this.minNumRacksPerWriteQuorum, this.enforceMinNumRacksPerWriteQuorum, this.ignoreLocalNodeInPlacementPolicy, this.statsLogger, this.bookieAddressResolver).withDefaultRack("/default-region/default-rack");
                                this.perRegionPlacement.put(newRegion, newRegionPlacement);
                            }
                            newRegionPlacement.handleBookiesThatJoined(Collections.singleton(bookieAddress));
                        }
                    }
                }
                catch (IllegalArgumentException | NetworkTopologyImpl.InvalidTopologyException e) {
                    LOG.error("Failed to update bookie rack info: {} ", bookieAddress, (Object)e);
                }
            });
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public RegionAwareEnsemblePlacementPolicy initialize(ClientConfiguration conf, Optional<DNSToSwitchMapping> optionalDnsResolver, HashedWheelTimer timer, FeatureProvider featureProvider, StatsLogger statsLogger, BookieAddressResolver bookieAddressResolver) {
        ((RackawareEnsemblePlacementPolicyImpl)super.initialize(conf, (Optional)optionalDnsResolver, timer, featureProvider, statsLogger, bookieAddressResolver)).withDefaultRack("/default-region/default-rack");
        this.myRegion = this.getLocalRegion(this.localNode);
        this.enableValidation = conf.getBoolean(REPP_ENABLE_VALIDATION, true);
        String regionsString = conf.getString(REPP_REGIONS_TO_WRITE, null);
        if (null != regionsString) {
            String[] regions;
            for (String region : regions = regionsString.split(";")) {
                this.perRegionPlacement.put(region, new RackawareEnsemblePlacementPolicy(true).initialize(this.dnsResolver, timer, this.reorderReadsRandom, this.stabilizePeriodSeconds, this.reorderThresholdPendingRequests, this.isWeighted, this.maxWeightMultiple, this.minNumRacksPerWriteQuorum, this.enforceMinNumRacksPerWriteQuorum, this.ignoreLocalNodeInPlacementPolicy, statsLogger, bookieAddressResolver).withDefaultRack("/default-region/default-rack"));
            }
            this.minRegionsForDurability = conf.getInt(REPP_MINIMUM_REGIONS_FOR_DURABILITY, 2);
            if (this.minRegionsForDurability > 0) {
                this.enforceDurability = true;
                this.enforceDurabilityInReplace = conf.getBoolean(REPP_ENABLE_DURABILITY_ENFORCEMENT_IN_REPLACE, true);
            }
            if (regions.length < this.minRegionsForDurability) {
                throw new IllegalArgumentException("Regions provided are insufficient to meet the durability constraints");
            }
        }
        this.featureProvider = featureProvider;
        this.disallowBookiePlacementInRegionFeatureName = conf.getString(REPP_DISALLOW_BOOKIE_PLACEMENT_IN_REGION_FEATURE_NAME);
        this.disableDurabilityFeature = conf.getFeature(REPP_DISABLE_DURABILITY_ENFORCEMENT_FEATURE, null);
        if (null == this.disableDurabilityFeature) {
            this.disableDurabilityFeature = featureProvider.getFeature(conf.getString(REPP_DISABLE_DURABILITY_FEATURE_NAME, "repp_disable_durability_enforcement"));
        }
        return this;
    }

    protected List<BookieNode> selectRandomFromRegions(Set<String> availableRegions, int numBookies, Set<Node> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> predicate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> ensemble) throws BKException.BKNotEnoughBookiesException {
        ArrayList<BookieNode> availableBookies = new ArrayList<BookieNode>();
        for (BookieNode bookieNode : this.knownBookies.values()) {
            if (!availableRegions.contains(this.getLocalRegion(bookieNode))) continue;
            availableBookies.add(bookieNode);
        }
        return this.selectRandomInternal(availableBookies, numBookies, excludeBookies, predicate, ensemble);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnsemblePlacementPolicy.PlacementResult<List<BookieId>> newEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, Set<BookieId> excludedBookies) throws BKException.BKNotEnoughBookiesException {
        int effectiveMinRegionsForDurability;
        int n = effectiveMinRegionsForDurability = this.disableDurabilityFeature.isAvailable() ? 1 : this.minRegionsForDurability;
        if (ackQuorumSize < effectiveMinRegionsForDurability) {
            throw new IllegalArgumentException("Ack Quorum size provided are insufficient to meet the durability constraints");
        }
        if (ensembleSize < writeQuorumSize) {
            throw new IllegalArgumentException("write quorum (" + writeQuorumSize + ") cannot exceed ensemble size (" + ensembleSize + ")");
        }
        if (writeQuorumSize < ackQuorumSize) {
            throw new IllegalArgumentException("ack quorum (" + ackQuorumSize + ") cannot exceed write quorum size (" + writeQuorumSize + ")");
        }
        if (effectiveMinRegionsForDurability > 0 && ackQuorumSize <= writeQuorumSize - writeQuorumSize / effectiveMinRegionsForDurability) {
            throw new IllegalArgumentException("ack quorum (" + ackQuorumSize + ") violates the requirement to satisfy durability constraints when running in degraded mode");
        }
        this.rwLock.readLock().lock();
        try {
            TopologyAwareEnsemblePlacementPolicy.RRTopologyAwareCoverageEnsemble ensemble;
            int remainingEnsembleBeforeIteration;
            Set<BookieId> comprehensiveExclusionBookiesSet = this.addDefaultRackBookiesIfMinNumRacksIsEnforced(excludedBookies);
            Set<Node> excludeNodes = this.convertBookiesToNodes(comprehensiveExclusionBookiesSet);
            ArrayList<String> availableRegions = new ArrayList<String>();
            for (String region : this.perRegionPlacement.keySet()) {
                if (null != this.disallowBookiePlacementInRegionFeatureName && this.featureProvider.scope(region).getFeature(this.disallowBookiePlacementInRegionFeatureName).isAvailable()) continue;
                availableRegions.add(region);
            }
            int numRegionsAvailable = availableRegions.size();
            if (numRegionsAvailable < 1) {
                if (this.perRegionPlacement.keySet().size() >= 1) {
                    LOG.error("No regions available, invalid configuration");
                }
                List<BookieNode> bns = this.selectRandom(ensembleSize, excludeNodes, TopologyAwareEnsemblePlacementPolicy.TruePredicate.INSTANCE, TopologyAwareEnsemblePlacementPolicy.EnsembleForReplacementWithNoConstraints.INSTANCE);
                ArrayList<BookieId> addrs = new ArrayList<BookieId>(ensembleSize);
                for (BookieNode bn : bns) {
                    addrs.add(bn.getAddr());
                }
                EnsemblePlacementPolicy.PlacementResult<ArrayList<BookieId>> placementResult = EnsemblePlacementPolicy.PlacementResult.of(addrs, this.isEnsembleAdheringToPlacementPolicy(addrs, writeQuorumSize, ackQuorumSize));
                return placementResult;
            }
            if (numRegionsAvailable < 2) {
                TopologyAwareEnsemblePlacementPolicy.RRTopologyAwareCoverageEnsemble ensemble2 = new TopologyAwareEnsemblePlacementPolicy.RRTopologyAwareCoverageEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, 2, (Set<String>)(effectiveMinRegionsForDurability > 0 ? new HashSet<String>(this.perRegionPlacement.keySet()) : null), effectiveMinRegionsForDurability, this.minNumRacksPerWriteQuorum);
                TopologyAwareEnsemblePlacementPolicy nextPolicy = this.perRegionPlacement.get(availableRegions.iterator().next());
                EnsemblePlacementPolicy.PlacementResult<List<BookieId>> placementResult = nextPolicy.newEnsemble(ensembleSize, writeQuorumSize, writeQuorumSize, comprehensiveExclusionBookiesSet, ensemble2, ensemble2);
                return placementResult;
            }
            int remainingEnsemble = ensembleSize;
            int remainingWriteQuorum = writeQuorumSize;
            HashMap<String, Pair> regionsWiseAllocation = new HashMap<String, Pair>();
            for (String region : availableRegions) {
                regionsWiseAllocation.put(region, Pair.of((Object)0, (Object)0));
            }
            HashSet<String> regionsReachedMaxAllocation = new HashSet<String>();
            do {
                int numRemainingRegions = numRegionsAvailable - regionsReachedMaxAllocation.size();
                ensemble = new TopologyAwareEnsemblePlacementPolicy.RRTopologyAwareCoverageEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, 2, (Set<String>)(effectiveMinRegionsForDurability > 0 ? new HashSet<String>(this.perRegionPlacement.keySet()) : null), effectiveMinRegionsForDurability, this.minNumRacksPerWriteQuorum);
                remainingEnsembleBeforeIteration = remainingEnsemble;
                int regionsToAllocate = numRemainingRegions;
                int startRegionIndex = this.lastRegionIndex % numRegionsAvailable;
                for (int i = 0; i < numRegionsAvailable; ++i) {
                    String region = (String)availableRegions.get(startRegionIndex % numRegionsAvailable);
                    ++startRegionIndex;
                    Pair currentAllocation = (Pair)regionsWiseAllocation.get(region);
                    TopologyAwareEnsemblePlacementPolicy policyWithinRegion = this.perRegionPlacement.get(region);
                    if (!regionsReachedMaxAllocation.contains(region)) {
                        if (numRemainingRegions <= 0) {
                            LOG.error("Inconsistent State: This should never happen");
                            throw new BKException.BKNotEnoughBookiesException();
                        }
                        boolean success = false;
                        for (int addToEnsembleSize = Math.min(remainingEnsemble, remainingEnsemble / regionsToAllocate + (remainingEnsemble % regionsToAllocate == 0 ? 0 : 1)); addToEnsembleSize > 0; --addToEnsembleSize) {
                            int addToWriteQuorum = Math.max(1, Math.min(remainingWriteQuorum, Math.round(1.0f * (float)writeQuorumSize * (float)addToEnsembleSize / (float)ensembleSize)));
                            TopologyAwareEnsemblePlacementPolicy.RRTopologyAwareCoverageEnsemble tempEnsemble = new TopologyAwareEnsemblePlacementPolicy.RRTopologyAwareCoverageEnsemble(ensemble);
                            int newEnsembleSize = (Integer)currentAllocation.getLeft() + addToEnsembleSize;
                            int newWriteQuorumSize = (Integer)currentAllocation.getRight() + addToWriteQuorum;
                            try {
                                List<BookieId> allocated = policyWithinRegion.newEnsemble(newEnsembleSize, newWriteQuorumSize, newWriteQuorumSize, comprehensiveExclusionBookiesSet, tempEnsemble, tempEnsemble).getResult();
                                ensemble = tempEnsemble;
                                remainingEnsemble -= addToEnsembleSize;
                                remainingWriteQuorum -= addToWriteQuorum;
                                regionsWiseAllocation.put(region, Pair.of((Object)newEnsembleSize, (Object)newWriteQuorumSize));
                                success = true;
                                --regionsToAllocate;
                                this.lastRegionIndex = startRegionIndex;
                                LOG.info("Region {} allocating bookies with ensemble size {} and write quorum size {} : {}", new Object[]{region, newEnsembleSize, newWriteQuorumSize, allocated});
                                break;
                            }
                            catch (BKException.BKNotEnoughBookiesException exc) {
                                LOG.warn("Could not allocate {} bookies in region {}, try allocating {} bookies", new Object[]{newEnsembleSize, region, newEnsembleSize - 1});
                                continue;
                            }
                        }
                        if (!success) {
                            regionsReachedMaxAllocation.add(region);
                        }
                    }
                    if (!regionsReachedMaxAllocation.contains(region) || (Integer)currentAllocation.getLeft() <= 0) continue;
                    LOG.info("Allocating {} bookies in region {} : ensemble {} exclude {}", new Object[]{currentAllocation.getLeft(), region, comprehensiveExclusionBookiesSet, ensemble});
                    policyWithinRegion.newEnsemble((Integer)currentAllocation.getLeft(), (Integer)currentAllocation.getRight(), (Integer)currentAllocation.getRight(), comprehensiveExclusionBookiesSet, ensemble, ensemble);
                    LOG.info("Allocated {} bookies in region {} : {}", new Object[]{currentAllocation.getLeft(), region, ensemble});
                }
            } while (!regionsReachedMaxAllocation.containsAll(regionsWiseAllocation.keySet()) && remainingEnsemble > 0 && remainingEnsemble < remainingEnsembleBeforeIteration);
            List<BookieId> bookieList = ensemble.toList();
            if (ensembleSize != bookieList.size()) {
                LOG.error("Not enough {} bookies are available to form an ensemble : {}.", (Object)ensembleSize, bookieList);
                throw new BKException.BKNotEnoughBookiesException();
            }
            if (this.enableValidation && !ensemble.validate()) {
                LOG.error("Not enough {} bookies are available to form a valid ensemble : {}.", (Object)ensembleSize, bookieList);
                throw new BKException.BKNotEnoughBookiesException();
            }
            LOG.info("Bookies allocated successfully {}", (Object)ensemble);
            List<BookieId> ensembleList = ensemble.toList();
            EnsemblePlacementPolicy.PlacementResult<List<BookieId>> placementResult = EnsemblePlacementPolicy.PlacementResult.of(ensembleList, this.isEnsembleAdheringToPlacementPolicy(ensembleList, writeQuorumSize, ackQuorumSize));
            return placementResult;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnsemblePlacementPolicy.PlacementResult<BookieId> replaceBookie(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, List<BookieId> currentEnsemble, BookieId bookieToReplace, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        this.rwLock.readLock().lock();
        try {
            boolean enforceDurability = this.enforceDurabilityInReplace && !this.disableDurabilityFeature.isAvailable();
            int effectiveMinRegionsForDurability = enforceDurability ? this.minRegionsForDurability : 1;
            Set<BookieId> comprehensiveExclusionBookiesSet = this.addDefaultRackBookiesIfMinNumRacksIsEnforced(excludeBookies);
            Set<Node> excludeNodes = this.convertBookiesToNodes(comprehensiveExclusionBookiesSet);
            TopologyAwareEnsemblePlacementPolicy.RRTopologyAwareCoverageEnsemble ensemble = new TopologyAwareEnsemblePlacementPolicy.RRTopologyAwareCoverageEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, 2, (Set<String>)(effectiveMinRegionsForDurability > 0 ? new HashSet<String>(this.perRegionPlacement.keySet()) : null), effectiveMinRegionsForDurability, this.minNumRacksPerWriteQuorum);
            BookieNode bookieNodeToReplace = (BookieNode)this.knownBookies.get(bookieToReplace);
            if (null == bookieNodeToReplace) {
                bookieNodeToReplace = this.createBookieNode(bookieToReplace);
            }
            excludeNodes.add(bookieNodeToReplace);
            for (BookieId bookieAddress : currentEnsemble) {
                if (bookieAddress.equals(bookieToReplace)) continue;
                BookieNode bn = (BookieNode)this.knownBookies.get(bookieAddress);
                if (null == bn) {
                    bn = this.createBookieNode(bookieAddress);
                }
                excludeNodes.add(bn);
                if (!ensemble.apply(bn, (ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode>)ensemble)) {
                    LOG.warn("Anomalous ensemble detected");
                    if (null != this.statsLogger) {
                        this.statsLogger.getCounter(REGION_AWARE_ANOMALOUS_ENSEMBLE).inc();
                    }
                    enforceDurability = false;
                }
                ensemble.addNode(bn);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Try to choose a new bookie to replace {}, excluding {}.", (Object)bookieToReplace, excludeNodes);
            }
            BookieNode candidate = this.replaceFromRack(bookieNodeToReplace, excludeNodes, ensemble, ensemble, enforceDurability);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Bookie {} is chosen to replace bookie {}.", (Object)candidate, (Object)bookieNodeToReplace);
            }
            BookieId candidateAddr = candidate.getAddr();
            ArrayList<BookieId> newEnsemble = new ArrayList<BookieId>(currentEnsemble);
            if (currentEnsemble.isEmpty()) {
                newEnsemble.add(candidateAddr);
            } else {
                newEnsemble.set(currentEnsemble.indexOf(bookieToReplace), candidateAddr);
            }
            EnsemblePlacementPolicy.PlacementResult<BookieId> placementResult = EnsemblePlacementPolicy.PlacementResult.of(candidateAddr, this.isEnsembleAdheringToPlacementPolicy(newEnsemble, writeQuorumSize, ackQuorumSize));
            return placementResult;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    protected BookieNode replaceFromRack(BookieNode bookieNodeToReplace, Set<Node> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> predicate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> ensemble, boolean enforceDurability) throws BKException.BKNotEnoughBookiesException {
        TopologyAwareEnsemblePlacementPolicy regionPolicy;
        HashSet<String> availableRegions = new HashSet<String>();
        for (String region : this.perRegionPlacement.keySet()) {
            if (null != this.disallowBookiePlacementInRegionFeatureName && this.featureProvider.scope(region).getFeature(this.disallowBookiePlacementInRegionFeatureName).isAvailable()) continue;
            availableRegions.add(region);
        }
        String regionForBookieToReplace = this.getLocalRegion(bookieNodeToReplace);
        if (availableRegions.contains(regionForBookieToReplace) && null != (regionPolicy = this.perRegionPlacement.get(regionForBookieToReplace))) {
            try {
                return regionPolicy.selectFromNetworkLocation(bookieNodeToReplace.getNetworkLocation(), excludeBookies, TopologyAwareEnsemblePlacementPolicy.TruePredicate.INSTANCE, TopologyAwareEnsemblePlacementPolicy.EnsembleForReplacementWithNoConstraints.INSTANCE, true);
            }
            catch (BKException.BKNotEnoughBookiesException e) {
                LOG.warn("Failed to choose a bookie from {} : excluded {}, fallback to choose bookie randomly from the cluster.", (Object)bookieNodeToReplace.getNetworkLocation(), excludeBookies);
            }
        }
        return this.selectRandomFromRegions(availableRegions, 1, excludeBookies, enforceDurability ? predicate : TopologyAwareEnsemblePlacementPolicy.TruePredicate.INSTANCE, enforceDurability ? ensemble : TopologyAwareEnsemblePlacementPolicy.EnsembleForReplacementWithNoConstraints.INSTANCE).get(0);
    }

    @Override
    public final DistributionSchedule.WriteSet reorderReadSequence(List<BookieId> ensemble, BookiesHealthInfo bookiesHealthInfo, DistributionSchedule.WriteSet writeSet) {
        if (UNKNOWN_REGION.equals(this.myRegion)) {
            return super.reorderReadSequence(ensemble, bookiesHealthInfo, writeSet);
        }
        HashMap<Integer, String> writeSetWithRegion = new HashMap<Integer, String>();
        for (int i = 0; i < writeSet.size(); ++i) {
            int idx = writeSet.get(i);
            writeSetWithRegion.put(idx, this.getRegion(ensemble.get(idx)));
        }
        return super.reorderReadSequenceWithRegion(ensemble, writeSet, writeSetWithRegion, bookiesHealthInfo, true, this.myRegion, 2);
    }

    @Override
    public final DistributionSchedule.WriteSet reorderReadLACSequence(List<BookieId> ensemble, BookiesHealthInfo bookiesHealthInfo, DistributionSchedule.WriteSet writeSet) {
        if (UNKNOWN_REGION.equals(this.myRegion)) {
            return super.reorderReadLACSequence(ensemble, bookiesHealthInfo, writeSet);
        }
        DistributionSchedule.WriteSet finalList = this.reorderReadSequence(ensemble, bookiesHealthInfo, writeSet);
        finalList.addMissingIndices(ensemble.size());
        return finalList;
    }

    @Override
    public EnsemblePlacementPolicy.PlacementPolicyAdherence isEnsembleAdheringToPlacementPolicy(List<BookieId> ensembleList, int writeQuorumSize, int ackQuorumSize) {
        return EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT;
    }
}

