/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.util.Arrays;
import java.util.Collection;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKParameterized;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=ZKParameterized.RunnerFactory.class)
public class PortAssignmentTest {
    private final String strProcessCount;
    private final String cmdLine;
    private final int expectedMinimumPort;
    private final int expectedMaximumPort;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"8", "threadid=1", 11221, 13913}, {"8", "threadid=2", 13914, 16606}, {"8", "threadid=3", 16607, 19299}, {"8", "threadid=4", 19300, 21992}, {"8", "threadid=5", 21993, 24685}, {"8", "threadid=6", 24686, 27378}, {"8", "threadid=7", 27379, 30071}, {"8", "threadid=8", 30072, 32764}, {"1", "threadid=1", 11221, Short.MAX_VALUE}, {"2", "threadid=1", 11221, 21993}, {"2", "threadid=2", 21994, 32766}, {null, null, 11221, Short.MAX_VALUE}, {"", "", 11221, Short.MAX_VALUE});
    }

    public PortAssignmentTest(String strProcessCount, String cmdLine, int expectedMinimumPort, int expectedMaximumPort) {
        this.strProcessCount = strProcessCount;
        this.cmdLine = cmdLine;
        this.expectedMinimumPort = expectedMinimumPort;
        this.expectedMaximumPort = expectedMaximumPort;
    }

    @Test
    public void testSetupPortRange() {
        PortAssignment.PortRange portRange = PortAssignment.setupPortRange(this.strProcessCount, this.cmdLine);
        Assert.assertEquals((String)this.buildAssertionMessage("minimum"), (long)this.expectedMinimumPort, (long)portRange.getMinimum());
        Assert.assertEquals((String)this.buildAssertionMessage("maximum"), (long)this.expectedMaximumPort, (long)portRange.getMaximum());
    }

    private String buildAssertionMessage(String checkType) {
        return String.format("strProcessCount = %s, cmdLine = %s, checking %s", this.strProcessCount, this.cmdLine, checkType);
    }
}

