/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.storage.impl.store;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import org.apache.bookkeeper.common.coder.ByteArrayCoder;
import org.apache.bookkeeper.common.coder.Coder;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.exceptions.ObjectClosedException;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.common.util.SharedResourceManager;
import org.apache.bookkeeper.statelib.StateStores;
import org.apache.bookkeeper.statelib.api.StateStoreSpec;
import org.apache.bookkeeper.statelib.api.checkpoint.CheckpointStore;
import org.apache.bookkeeper.statelib.api.mvcc.MVCCAsyncStore;
import org.apache.bookkeeper.stream.protocol.RangeId;
import org.apache.bookkeeper.stream.storage.StorageResources;
import org.apache.bookkeeper.stream.storage.conf.StorageConfiguration;
import org.apache.bookkeeper.stream.storage.impl.store.MVCCStoreFactory;
import org.apache.distributedlog.api.namespace.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MVCCStoreFactoryImpl
implements MVCCStoreFactory {
    private static final Logger log = LoggerFactory.getLogger(MVCCStoreFactoryImpl.class);
    private final Supplier<MVCCAsyncStore<byte[], byte[]>> storeSupplier;
    private final StorageResources storageResources;
    private final OrderedScheduler writeIOScheduler;
    private final OrderedScheduler readIOScheduler;
    private final OrderedScheduler checkpointScheduler;
    private final File[] localStateDirs;
    private final Supplier<CheckpointStore> checkpointStoreSupplier;
    private CheckpointStore checkpointStore;
    private final Map<Long, Map<RangeId, MVCCAsyncStore<byte[], byte[]>>> stores;
    private final boolean serveReadOnlyTable;
    private boolean closed = false;
    private final StorageConfiguration storageConf;

    public MVCCStoreFactoryImpl(Supplier<Namespace> namespaceSupplier, Supplier<CheckpointStore> checkpointStoreSupplier, File[] localStoreDirs, StorageResources storageResources, boolean serveReadOnlyTable, StorageConfiguration storageConf) {
        this.storeSupplier = StateStores.mvccKvBytesStoreSupplier(namespaceSupplier);
        this.storageResources = storageResources;
        this.writeIOScheduler = (OrderedScheduler)SharedResourceManager.shared().get(storageResources.ioWriteScheduler());
        this.readIOScheduler = (OrderedScheduler)SharedResourceManager.shared().get(storageResources.ioReadScheduler());
        this.checkpointScheduler = (OrderedScheduler)SharedResourceManager.shared().get(storageResources.checkpointScheduler());
        this.localStateDirs = localStoreDirs;
        this.checkpointStoreSupplier = checkpointStoreSupplier;
        this.storageConf = storageConf;
        this.stores = Maps.newHashMap();
        this.serveReadOnlyTable = serveReadOnlyTable;
    }

    private ScheduledExecutorService chooseWriteIOExecutor(long streamId) {
        return this.writeIOScheduler.chooseThread(streamId);
    }

    private ScheduledExecutorService chooseReadIOExecutor(long streamId) {
        return this.readIOScheduler.chooseThread(streamId);
    }

    private ScheduledExecutorService chooseCheckpointIOExecutor(long streamId) {
        return this.checkpointScheduler.chooseThread(streamId);
    }

    private File chooseLocalStoreDir(long streamId) {
        int idx = (int)(streamId % (long)this.localStateDirs.length);
        return this.localStateDirs[idx];
    }

    static String normalizedName(long id) {
        return String.format("%018d", id);
    }

    static String streamName(long scId, long streamId, long rangeId) {
        return String.format("%s_%018d_%018d_%018d", "streams", scId, streamId, rangeId);
    }

    private synchronized void addStore(long scId, long streamId, long rangeId, MVCCAsyncStore<byte[], byte[]> store) {
        RangeId rid;
        MVCCAsyncStore oldStore;
        HashMap scStores = this.stores.get(scId);
        if (null == scStores) {
            scStores = Maps.newHashMap();
            this.stores.putIfAbsent(scId, scStores);
        }
        if (null != (oldStore = (MVCCAsyncStore)scStores.get(rid = RangeId.of((long)streamId, (long)rangeId)))) {
            store.closeAsync();
        } else {
            log.info("Add store (scId = {}, streamId = {}, rangeId = {}) at storage container ({})", new Object[]{scId, streamId, rangeId, scId});
            scStores.put(rid, store);
        }
    }

    private synchronized MVCCAsyncStore<byte[], byte[]> getStore(long scId, long streamId, long rangeId) {
        Map<RangeId, MVCCAsyncStore<byte[], byte[]>> scStores = this.stores.get(scId);
        if (null == scStores) {
            return null;
        }
        RangeId rid = RangeId.of((long)streamId, (long)rangeId);
        return scStores.get(rid);
    }

    @Override
    public CompletableFuture<MVCCAsyncStore<byte[], byte[]>> openStore(long scId, long streamId, long rangeId) {
        MVCCAsyncStore<byte[], byte[]> store = this.getStore(scId, streamId, rangeId);
        if (null == store) {
            return this.newStore(scId, streamId, rangeId);
        }
        return FutureUtils.value(store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<MVCCAsyncStore<byte[], byte[]>> newStore(long scId, long streamId, long rangeId) {
        MVCCStoreFactoryImpl mVCCStoreFactoryImpl = this;
        synchronized (mVCCStoreFactoryImpl) {
            if (this.closed) {
                return FutureUtils.exception((Throwable)new ObjectClosedException("MVCCStoreFactory"));
            }
        }
        log.info("Initializing stream({})/range({}) at storage container ({})", new Object[]{streamId, rangeId, scId});
        MVCCAsyncStore<byte[], byte[]> store = this.storeSupplier.get();
        File targetDir = this.chooseLocalStoreDir(streamId);
        Path rangeStorePath = Paths.get(targetDir.getAbsolutePath(), "ranges", MVCCStoreFactoryImpl.normalizedName(scId), MVCCStoreFactoryImpl.normalizedName(streamId), MVCCStoreFactoryImpl.normalizedName(rangeId));
        String storeName = String.format("%s/%s/%s", MVCCStoreFactoryImpl.normalizedName(scId), MVCCStoreFactoryImpl.normalizedName(streamId), MVCCStoreFactoryImpl.normalizedName(rangeId));
        if (null == this.checkpointStore) {
            this.checkpointStore = this.checkpointStoreSupplier.get();
        }
        StateStoreSpec spec = StateStoreSpec.builder().name(storeName).keyCoder((Coder)ByteArrayCoder.of()).valCoder((Coder)ByteArrayCoder.of()).localStateStoreDir(rangeStorePath.toFile()).stream(MVCCStoreFactoryImpl.streamName(scId, streamId, rangeId)).writeIOScheduler(this.chooseWriteIOExecutor(streamId)).readIOScheduler(this.chooseReadIOExecutor(streamId)).checkpointStore(this.checkpointStore).checkpointDuration(Duration.ofMinutes(15L)).checkpointIOScheduler(this.chooseCheckpointIOExecutor(streamId)).isReadonly(this.serveReadOnlyTable).checkpointChecksumEnable(this.storageConf.getCheckpointChecksumEnable()).checkpointChecksumCompatible(this.storageConf.getCheckpointChecksumCompatible()).build();
        return ((CompletableFuture)store.init(spec).whenComplete((ignored, throwable) -> {
            if (null != throwable) {
                log.info("Clearing resources hold by stream({})/range({}) at storage container ({}) ", new Object[]{streamId, rangeId, scId});
                store.closeAsync().whenComplete((i, t) -> {
                    if (null != t) {
                        log.error("Clear resources hold by {} fail", (Object)store.name());
                    }
                });
            }
        })).thenApply(ignored -> {
            log.info("Successfully initialize stream({})/range({}) at storage container ({})", new Object[]{streamId, rangeId, scId});
            this.addStore(scId, streamId, rangeId, store);
            return store;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> closeStores(long scId) {
        Map<RangeId, MVCCAsyncStore<byte[], byte[]>> scStores;
        MVCCStoreFactoryImpl mVCCStoreFactoryImpl = this;
        synchronized (mVCCStoreFactoryImpl) {
            scStores = this.stores.remove(scId);
        }
        if (null == scStores) {
            log.info("scStores for {} on store factory is null, return directly", (Object)scId);
            return FutureUtils.Void();
        }
        ArrayList closeFutures = Lists.newArrayList();
        for (MVCCAsyncStore<byte[], byte[]> store : scStores.values()) {
            log.info("Closing {} of sc {}", (Object)store.name(), (Object)scId);
            closeFutures.add(store.closeAsync());
        }
        return FutureUtils.collect((List)closeFutures).thenApply(ignored -> null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        HashMap storesToClose;
        MVCCStoreFactoryImpl mVCCStoreFactoryImpl = this;
        synchronized (mVCCStoreFactoryImpl) {
            if (this.closed) {
                return;
            }
            storesToClose = Maps.newHashMap(this.stores);
            this.closed = true;
        }
        ArrayList closeFutures = Lists.newArrayList();
        for (Map scStores : storesToClose.values()) {
            for (MVCCAsyncStore store : scStores.values()) {
                closeFutures.add(store.closeAsync());
            }
        }
        try {
            FutureUtils.result((CompletableFuture)FutureUtils.collect((List)closeFutures));
            log.info("Successfully closed all the range stores opened by this range factory");
        }
        catch (Exception e) {
            log.info("Encountered issue on closing all the range stores opened by this range factory");
        }
        if (null != this.checkpointStore) {
            this.checkpointStore.close();
            this.checkpointStore = null;
        }
        SharedResourceManager.shared().release(this.storageResources.ioWriteScheduler(), (Object)this.writeIOScheduler);
        SharedResourceManager.shared().release(this.storageResources.ioReadScheduler(), (Object)this.readIOScheduler);
        SharedResourceManager.shared().release(this.storageResources.checkpointScheduler(), (Object)this.checkpointScheduler);
    }

    OrderedScheduler writeIOScheduler() {
        return this.writeIOScheduler;
    }

    OrderedScheduler readIOScheduler() {
        return this.readIOScheduler;
    }

    OrderedScheduler checkpointScheduler() {
        return this.checkpointScheduler;
    }
}

