/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.source;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;
import org.inferred.freebuilder.processor.source.Shading;
import org.inferred.freebuilder.processor.source.Type;
import org.inferred.freebuilder.processor.source.TypeClass;
import org.inferred.freebuilder.processor.source.ValueType;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.collect.ComparisonChain;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableList;
import org.inferred.freebuilder.shaded.com.google.common.collect.Iterables;
import org.inferred.freebuilder.shaded.com.google.common.collect.Lists;
import org.inferred.freebuilder.shaded.com.google.common.collect.Ordering;

public class QualifiedName
extends ValueType
implements Comparable<QualifiedName> {
    private final String packageName;
    private final ImmutableList<String> simpleNames;

    public static QualifiedName of(String packageName, String topLevelType, String ... nestedTypes) {
        Objects.requireNonNull(!packageName.isEmpty());
        Preconditions.checkArgument(!topLevelType.isEmpty());
        return new QualifiedName(Shading.unshadedName(packageName), (ImmutableList<String>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(topLevelType)).add(nestedTypes)).build());
    }

    public static QualifiedName of(Class<?> cls) {
        if (cls.getEnclosingClass() != null) {
            return QualifiedName.of(cls.getEnclosingClass()).nestedType(cls.getSimpleName());
        }
        if (cls.getPackage() != null) {
            return QualifiedName.of(cls.getPackage().getName(), cls.getSimpleName(), new String[0]);
        }
        return QualifiedName.of("", cls.getSimpleName(), new String[0]);
    }

    public static QualifiedName of(TypeElement type) {
        switch (type.getNestingKind()) {
            case TOP_LEVEL: {
                PackageElement pkg = (PackageElement)type.getEnclosingElement();
                return QualifiedName.of(pkg.getQualifiedName().toString(), type.getSimpleName().toString(), new String[0]);
            }
            case MEMBER: {
                ArrayList<String> reversedNames = new ArrayList<String>();
                reversedNames.add(type.getSimpleName().toString());
                Element parent = type.getEnclosingElement();
                while (parent.getKind() != ElementKind.PACKAGE) {
                    reversedNames.add(parent.getSimpleName().toString());
                    parent = parent.getEnclosingElement();
                }
                return new QualifiedName(((PackageElement)parent).getQualifiedName().toString(), ImmutableList.copyOf(Lists.reverse(reversedNames)));
            }
        }
        throw new IllegalArgumentException("Cannot determine qualified name of " + type);
    }

    private QualifiedName(String packageName, ImmutableList<String> simpleNames) {
        this.packageName = packageName;
        this.simpleNames = simpleNames;
    }

    @Override
    public String toString() {
        return this.packageName + "." + this.simpleNames.stream().collect(Collectors.joining("."));
    }

    public String getPackage() {
        return this.packageName;
    }

    public QualifiedName enclosingType() {
        Preconditions.checkState(!this.isTopLevel(), "Cannot return enclosing type of top-level type");
        return new QualifiedName(this.packageName, (ImmutableList<String>)this.simpleNames.subList(0, this.simpleNames.size() - 1));
    }

    public ImmutableList<String> getSimpleNames() {
        return this.simpleNames;
    }

    public String getSimpleName() {
        return Iterables.getLast(this.simpleNames);
    }

    public boolean isTopLevel() {
        return this.simpleNames.size() == 1;
    }

    public boolean isNestedIn(QualifiedName other) {
        return this.packageName.equals(other.packageName) && this.simpleNames.size() > other.simpleNames.size() && ((ImmutableList)this.simpleNames.subList(0, other.simpleNames.size())).equals(other.simpleNames);
    }

    public QualifiedName nestedType(String simpleName) {
        return new QualifiedName(this.packageName, (ImmutableList<String>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.simpleNames)).add(simpleName)).build());
    }

    public TypeClass withParameters(TypeParameterElement ... parameters) {
        return new TypeClass(this, ImmutableList.copyOf(parameters));
    }

    public Type withParameters(TypeMirror first, TypeMirror ... rest) {
        return new Type.TypeImpl(this, (List<?>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(first)).add(rest)).build()));
    }

    public TypeClass withParameters(Iterable<? extends TypeParameterElement> typeParameters) {
        return new TypeClass(this, ImmutableList.copyOf(typeParameters));
    }

    @Override
    public int compareTo(QualifiedName o) {
        return ComparisonChain.start().compare((Comparable<?>)((Object)this.packageName), (Comparable<?>)((Object)o.packageName)).compare(this.simpleNames, o.simpleNames, Ordering.natural().lexicographical()).result();
    }

    @Override
    protected void addFields(ValueType.FieldReceiver fields) {
        fields.add("packageName", this.packageName);
        fields.add("simpleNames", this.simpleNames);
    }
}

