/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.util.concurrent.CountDownLatch;
import java.util.stream.Stream;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class EagerACLFilterTest
extends QuorumBase {
    protected final CountDownLatch callComplete = new CountDownLatch(1);
    protected boolean complete = false;
    protected static final String PARENT_PATH = "/foo";
    protected static final String CHILD_PATH = "/foo/bar";
    protected static final String AUTH_PROVIDER = "digest";
    protected static final byte[] AUTH = "hello".getBytes();
    protected static final byte[] AUTHB = "goodbye".getBytes();
    protected static final byte[] DATA = "Hint Water".getBytes();
    protected TestableZooKeeper zkClient;
    protected TestableZooKeeper zkClientB;
    protected QuorumPeer zkLeader;
    protected ZooKeeperServer connectedServer;

    public static Stream<Arguments> data() {
        return Stream.of(Arguments.of((Object[])new Object[]{QuorumPeer.ServerState.LEADING, true}), Arguments.of((Object[])new Object[]{QuorumPeer.ServerState.LEADING, false}), Arguments.of((Object[])new Object[]{QuorumPeer.ServerState.FOLLOWING, true}), Arguments.of((Object[])new Object[]{QuorumPeer.ServerState.FOLLOWING, false}), Arguments.of((Object[])new Object[]{QuorumPeer.ServerState.OBSERVING, true}), Arguments.of((Object[])new Object[]{QuorumPeer.ServerState.OBSERVING, false}));
    }

    @Override
    @BeforeEach
    public void setUp() {
    }

    public void setUp(QuorumPeer.ServerState serverState, boolean checkEnabled) throws Exception {
        this.ensureCheck(checkEnabled);
        ClientBase.CountdownWatcher clientWatch = new ClientBase.CountdownWatcher();
        ClientBase.CountdownWatcher clientWatchB = new ClientBase.CountdownWatcher();
        super.setUp(true, true);
        String hostPort = this.getPeersMatching(serverState).split(",")[0];
        int clientPort = Integer.parseInt(hostPort.split(":")[1]);
        this.zkLeader = this.getPeerList().get(this.getLeaderIndex());
        this.connectedServer = this.getPeerByClientPort(clientPort).getActiveServer();
        this.zkClient = this.createClient(clientWatch, hostPort);
        this.zkClientB = this.createClient(clientWatchB, hostPort);
        this.zkClient.addAuthInfo(AUTH_PROVIDER, AUTH);
        this.zkClientB.addAuthInfo(AUTH_PROVIDER, AUTHB);
        clientWatch.waitForConnected(CONNECTION_TIMEOUT);
        clientWatchB.waitForConnected(CONNECTION_TIMEOUT);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        if (this.zkClient != null) {
            this.zkClient.close();
        }
        if (this.zkClientB != null) {
            this.zkClientB.close();
        }
        super.tearDown();
    }

    private void ensureCheck(boolean enabled) {
        if (enabled) {
            System.setProperty("zookeeper.enableEagerACLCheck", "true");
        } else {
            System.clearProperty("zookeeper.enableEagerACLCheck");
        }
    }

    private void assertTransactionState(String condition, long lastxid, QuorumPeer.ServerState serverState, boolean checkEnabled) {
        String assertion = String.format("Server State: %s Check Enabled: %s %s", serverState, checkEnabled, condition);
        if (checkEnabled) {
            Assertions.assertEquals((long)lastxid, (long)this.zkLeader.getLastLoggedZxid(), (String)assertion);
        } else {
            Assertions.assertNotSame((Object)lastxid, (Object)this.zkLeader.getLastLoggedZxid(), (String)assertion);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testCreateOK(QuorumPeer.ServerState serverState, boolean checkEnabled) throws Exception {
        this.setUp(serverState, checkEnabled);
        this.ensureCheck(true);
        this.zkClient.create(PARENT_PATH, DATA, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zkClientB.create(CHILD_PATH, DATA, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assertions.assertEquals((int)0, (int)this.connectedServer.getInProcess(), (String)"OutstandingRequests not decremented");
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testCreate2OK(QuorumPeer.ServerState serverState, boolean checkEnabled) throws Exception {
        this.setUp(serverState, checkEnabled);
        this.zkClient.create(PARENT_PATH, DATA, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, null);
        this.zkClientB.create(CHILD_PATH, DATA, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, null);
        Assertions.assertEquals((int)0, (int)this.connectedServer.getInProcess(), (String)"OutstandingRequests not decremented");
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testCreateFail(QuorumPeer.ServerState serverState, boolean checkEnabled) throws Exception {
        this.setUp(serverState, checkEnabled);
        this.zkClient.create(PARENT_PATH, DATA, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
        long lastxid = this.zkLeader.getLastLoggedZxid();
        try {
            this.zkClientB.create(CHILD_PATH, DATA, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NoAuthException noAuthException) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)this.connectedServer.getInProcess(), (String)"OutstandingRequests not decremented");
        this.assertTransactionState("Transaction state on Leader after failed create", lastxid, serverState, checkEnabled);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testCreate2Fail(QuorumPeer.ServerState serverState, boolean checkEnabled) throws Exception {
        this.setUp(serverState, checkEnabled);
        this.zkClient.create(PARENT_PATH, DATA, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT, null);
        long lastxid = this.zkLeader.getLastLoggedZxid();
        try {
            this.zkClientB.create(CHILD_PATH, DATA, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, null);
        }
        catch (KeeperException.NoAuthException noAuthException) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)this.connectedServer.getInProcess(), (String)"OutstandingRequests not decremented");
        this.assertTransactionState("Transaction state on Leader after failed create2", lastxid, serverState, checkEnabled);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testDeleteOK(QuorumPeer.ServerState serverState, boolean checkEnabled) throws Exception {
        this.setUp(serverState, checkEnabled);
        this.zkClient.create(PARENT_PATH, DATA, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zkClientB.delete(PARENT_PATH, -1);
        Assertions.assertEquals((int)0, (int)this.connectedServer.getInProcess(), (String)"OutstandingRequests not decremented");
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testDeleteFail(QuorumPeer.ServerState serverState, boolean checkEnabled) throws Exception {
        this.setUp(serverState, checkEnabled);
        this.zkClient.create(PARENT_PATH, DATA, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT, null);
        this.zkClient.create(CHILD_PATH, DATA, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT, null);
        long lastxid = this.zkLeader.getLastLoggedZxid();
        try {
            this.zkClientB.delete(CHILD_PATH, -1);
        }
        catch (KeeperException.NoAuthException noAuthException) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)this.connectedServer.getInProcess(), (String)"OutstandingRequests not decremented");
        this.assertTransactionState("Transaction state on Leader after failed delete", lastxid, serverState, checkEnabled);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testSetDataOK(QuorumPeer.ServerState serverState, boolean checkEnabled) throws Exception {
        this.setUp(serverState, checkEnabled);
        this.zkClient.create(PARENT_PATH, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, null);
        this.zkClientB.setData(PARENT_PATH, DATA, -1);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testSetDataFail(QuorumPeer.ServerState serverState, boolean checkEnabled) throws Exception {
        this.setUp(serverState, checkEnabled);
        this.zkClient.create(PARENT_PATH, null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT, null);
        long lastxid = this.zkLeader.getLastLoggedZxid();
        try {
            this.zkClientB.setData(PARENT_PATH, DATA, -1);
        }
        catch (KeeperException.NoAuthException noAuthException) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)this.connectedServer.getInProcess(), (String)"OutstandingRequests not decremented");
        this.assertTransactionState("Transaction state on Leader after failed setData", lastxid, serverState, checkEnabled);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testSetACLOK(QuorumPeer.ServerState serverState, boolean checkEnabled) throws Exception {
        this.setUp(serverState, checkEnabled);
        this.zkClient.create(PARENT_PATH, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, null);
        this.zkClientB.setACL(PARENT_PATH, ZooDefs.Ids.READ_ACL_UNSAFE, -1);
        Assertions.assertEquals((int)0, (int)this.connectedServer.getInProcess(), (String)"OutstandingRequests not decremented");
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testSetACLFail(QuorumPeer.ServerState serverState, boolean checkEnabled) throws Exception {
        this.setUp(serverState, checkEnabled);
        this.zkClient.create(PARENT_PATH, null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT, null);
        long lastxid = this.zkLeader.getLastLoggedZxid();
        try {
            this.zkClientB.setACL(PARENT_PATH, ZooDefs.Ids.READ_ACL_UNSAFE, -1);
        }
        catch (KeeperException.NoAuthException noAuthException) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)this.connectedServer.getInProcess(), (String)"OutstandingRequests not decremented");
        this.assertTransactionState("Transaction state on Leader after failed setACL", lastxid, serverState, checkEnabled);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testBadACL(QuorumPeer.ServerState serverState, boolean checkEnabled) throws Exception {
        this.setUp(serverState, checkEnabled);
        ClientBase.CountdownWatcher cw = new ClientBase.CountdownWatcher();
        TestableZooKeeper zk = this.createClient(cw, this.getPeersMatching(serverState));
        cw.waitForConnected(CONNECTION_TIMEOUT);
        long lastxid = this.zkLeader.getLastLoggedZxid();
        try {
            zk.create("/acltest", new byte[0], ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            Assertions.fail((String)"Should have received an invalid acl error");
        }
        catch (KeeperException.InvalidACLException invalidACLException) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)this.connectedServer.getInProcess(), (String)"OutstandingRequests not decremented");
        this.assertTransactionState("zxid after invalid ACL", lastxid, serverState, checkEnabled);
    }
}

