/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.excerpt;

import java.util.Collection;
import java.util.function.BiConsumer;
import org.inferred.freebuilder.processor.source.Excerpt;
import org.inferred.freebuilder.processor.source.LazyName;
import org.inferred.freebuilder.processor.source.SourceBuilder;
import org.inferred.freebuilder.processor.source.ValueType;
import org.inferred.freebuilder.processor.source.feature.Jsr305;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.collect.ForwardingMultiset;
import org.inferred.freebuilder.shaded.com.google.common.collect.Multiset;

public class CheckedMultiset
extends ValueType
implements Excerpt {
    public static final LazyName TYPE = LazyName.of("CheckedMultiset", new CheckedMultiset());

    private CheckedMultiset() {
    }

    @Override
    public void addTo(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * A multiset implementation that delegates to a provided setCount method", new Object[0]).addLine(" * to perform element validation and insertion into a backing multiset.", new Object[0]).addLine(" */", new Object[0]).addLine("private static class %s<E> extends %s<E> {", TYPE, ForwardingMultiset.class).addLine("", new Object[0]).addLine("  private final %s<E> multiset;", Multiset.class).addLine("  private final %s<E, Integer> setCount;", BiConsumer.class).addLine("", new Object[0]).addLine("  %s(%s<E> multiset, %s<E, Integer> setCount) {", TYPE, Multiset.class, BiConsumer.class).addLine("    this.multiset = multiset;", new Object[0]).addLine("    this.setCount = setCount;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override protected %s<E> delegate() {", Multiset.class).addLine("    return multiset;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean add(%s E element) {", Jsr305.nullable()).addLine("    return standardAdd(element);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public int add(%s E element, int occurrences) {", Jsr305.nullable()).addLine("    %s.checkArgument(occurrences >= 0,", Preconditions.class).addLine("        \"occurrences cannot be negative: %%s\", occurrences);", new Object[0]).addLine("    int oldCount = multiset.count(element);", new Object[0]).addLine("    if (occurrences > 0) {", new Object[0]).addLine("      long newCount = (long) oldCount + occurrences;", new Object[0]).addLine("      %s.checkArgument(newCount <= %s.MAX_VALUE,", Preconditions.class, Integer.class).addLine("          \"too many occurrences: %%s\", newCount);", new Object[0]).addLine("      setCount.accept(element, (int) newCount);", new Object[0]).addLine("    }", new Object[0]).addLine("    return oldCount;", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean addAll(%s<? extends E> elementsToAdd) {", Collection.class).addLine("    return standardAddAll(elementsToAdd);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public int setCount(%s E element, int count) {", Jsr305.nullable()).addLine("    return standardSetCount(element, count);", new Object[0]).addLine("  }", new Object[0]).addLine("", new Object[0]).addLine("  @Override public boolean setCount(", new Object[0]).addLine("      %s E element, int oldCount, int newCount) {", Jsr305.nullable()).addLine("    return standardSetCount(element, oldCount, newCount);", new Object[0]).addLine("  }", new Object[0]).addLine("}", new Object[0]);
    }

    @Override
    protected void addFields(ValueType.FieldReceiver fields) {
    }
}

