/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.shaded.org.openjdk.tools.javac.tree;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import javax.lang.model.element.Name;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.AttributeTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.DocTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.EndElementTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.IdentifierTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.ReferenceTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.StartElementTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.TextTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.util.DocTreeFactory;
import org.inferred.freebuilder.shaded.org.openjdk.tools.doclint.HtmlTag;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.api.JavacTrees;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.parser.ParserFactory;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.parser.ReferenceParser;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.parser.Tokens;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.tree.DCTree;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.tree.JCTree;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.util.Context;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.util.DiagnosticSource;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.util.JCDiagnostic;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.util.ListBuffer;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.util.Pair;

public class DocTreeMaker
implements DocTreeFactory {
    protected static final Context.Key<DocTreeMaker> treeMakerKey = new Context.Key();
    final EnumSet<HtmlTag> sentenceBreakTags;
    public int pos = -1;
    private final JCDiagnostic.Factory diags;
    private final JavacTrees trees;
    private final ReferenceParser referenceParser;

    public static DocTreeMaker instance(Context context) {
        DocTreeMaker instance = context.get(treeMakerKey);
        if (instance == null) {
            instance = new DocTreeMaker(context);
        }
        return instance;
    }

    protected DocTreeMaker(Context context) {
        context.put(treeMakerKey, this);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.pos = -1;
        this.trees = JavacTrees.instance(context);
        this.referenceParser = new ReferenceParser(ParserFactory.instance(context));
        this.sentenceBreakTags = EnumSet.of(HtmlTag.H1, new HtmlTag[]{HtmlTag.H2, HtmlTag.H3, HtmlTag.H4, HtmlTag.H5, HtmlTag.H6, HtmlTag.PRE, HtmlTag.P});
    }

    @Override
    public DocTreeMaker at(int pos) {
        this.pos = pos;
        return this;
    }

    public DocTreeMaker at(JCDiagnostic.DiagnosticPosition pos) {
        this.pos = pos == null ? -1 : pos.getStartPosition();
        return this;
    }

    @Override
    public DCTree.DCAttribute newAttributeTree(Name name, AttributeTree.ValueKind vkind, List<? extends DocTree> value) {
        DCTree.DCAttribute tree = new DCTree.DCAttribute(name, vkind, this.cast(value));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCAuthor newAuthorTree(List<? extends DocTree> name) {
        DCTree.DCAuthor tree = new DCTree.DCAuthor(this.cast(name));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCLiteral newCodeTree(TextTree text) {
        DCTree.DCLiteral tree = new DCTree.DCLiteral(DocTree.Kind.CODE, (DCTree.DCText)text);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCComment newCommentTree(String text) {
        DCTree.DCComment tree = new DCTree.DCComment(text);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCDeprecated newDeprecatedTree(List<? extends DocTree> text) {
        DCTree.DCDeprecated tree = new DCTree.DCDeprecated(this.cast(text));
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCDocComment newDocCommentTree(Tokens.Comment comment, List<? extends DocTree> fullBody, List<? extends DocTree> tags) {
        Pair<List<DCTree>, List<DCTree>> pair = this.splitBody(fullBody);
        DCTree.DCDocComment tree = new DCTree.DCDocComment(comment, this.cast(fullBody), (List)pair.fst, (List)pair.snd, this.cast(tags));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCDocComment newDocCommentTree(List<? extends DocTree> firstSentence, List<? extends DocTree> body, List<? extends DocTree> tags) {
        ListBuffer<DCTree> lb = new ListBuffer<DCTree>();
        lb.addAll((Collection<DCTree>)this.cast(firstSentence));
        lb.addAll((Collection<DCTree>)this.cast(body));
        org.inferred.freebuilder.shaded.org.openjdk.tools.javac.util.List<DCTree> fullBody = lb.toList();
        Tokens.Comment c = new Tokens.Comment(){

            @Override
            public String getText() {
                return null;
            }

            @Override
            public int getSourcePos(int index) {
                return -1;
            }

            @Override
            public Tokens.Comment.CommentStyle getStyle() {
                return Tokens.Comment.CommentStyle.JAVADOC;
            }

            @Override
            public boolean isDeprecated() {
                return false;
            }
        };
        DCTree.DCDocComment tree = new DCTree.DCDocComment(c, fullBody, this.cast(firstSentence), this.cast(body), this.cast(tags));
        return tree;
    }

    @Override
    public DCTree.DCDocRoot newDocRootTree() {
        DCTree.DCDocRoot tree = new DCTree.DCDocRoot();
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCEndElement newEndElementTree(Name name) {
        DCTree.DCEndElement tree = new DCTree.DCEndElement(name);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCEntity newEntityTree(Name name) {
        DCTree.DCEntity tree = new DCTree.DCEntity(name);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCErroneous newErroneousTree(String text, Diagnostic<JavaFileObject> diag) {
        DCTree.DCErroneous tree = new DCTree.DCErroneous(text, (JCDiagnostic)diag);
        tree.pos = this.pos;
        return tree;
    }

    public DCTree.DCErroneous newErroneousTree(String text, DiagnosticSource diagSource, String code, Object ... args) {
        DCTree.DCErroneous tree = new DCTree.DCErroneous(text, this.diags, diagSource, code, args);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCThrows newExceptionTree(ReferenceTree name, List<? extends DocTree> description) {
        DCTree.DCThrows tree = new DCTree.DCThrows(DocTree.Kind.EXCEPTION, (DCTree.DCReference)name, this.cast(description));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCIdentifier newIdentifierTree(Name name) {
        DCTree.DCIdentifier tree = new DCTree.DCIdentifier(name);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCIndex newIndexTree(DocTree term, List<? extends DocTree> description) {
        DCTree.DCIndex tree = new DCTree.DCIndex((DCTree)term, this.cast(description));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCInheritDoc newInheritDocTree() {
        DCTree.DCInheritDoc tree = new DCTree.DCInheritDoc();
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCLink newLinkTree(ReferenceTree ref, List<? extends DocTree> label) {
        DCTree.DCLink tree = new DCTree.DCLink(DocTree.Kind.LINK, (DCTree.DCReference)ref, this.cast(label));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCLink newLinkPlainTree(ReferenceTree ref, List<? extends DocTree> label) {
        DCTree.DCLink tree = new DCTree.DCLink(DocTree.Kind.LINK_PLAIN, (DCTree.DCReference)ref, this.cast(label));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCLiteral newLiteralTree(TextTree text) {
        DCTree.DCLiteral tree = new DCTree.DCLiteral(DocTree.Kind.LITERAL, (DCTree.DCText)text);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCParam newParamTree(boolean isTypeParameter, IdentifierTree name, List<? extends DocTree> description) {
        DCTree.DCParam tree = new DCTree.DCParam(isTypeParameter, (DCTree.DCIdentifier)name, this.cast(description));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCReference newReferenceTree(String signature) {
        try {
            ReferenceParser.Reference ref = this.referenceParser.parse(signature);
            DCTree.DCReference tree = new DCTree.DCReference(signature, ref.qualExpr, ref.member, ref.paramTypes);
            tree.pos = this.pos;
            return tree;
        }
        catch (ReferenceParser.ParseException e) {
            throw new IllegalArgumentException("invalid signature", e);
        }
    }

    public DCTree.DCReference newReferenceTree(String signature, JCTree qualExpr, Name member, List<JCTree> paramTypes) {
        DCTree.DCReference tree = new DCTree.DCReference(signature, qualExpr, member, paramTypes);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCReturn newReturnTree(List<? extends DocTree> description) {
        DCTree.DCReturn tree = new DCTree.DCReturn(this.cast(description));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCSee newSeeTree(List<? extends DocTree> reference) {
        DCTree.DCSee tree = new DCTree.DCSee(this.cast(reference));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCSerial newSerialTree(List<? extends DocTree> description) {
        DCTree.DCSerial tree = new DCTree.DCSerial(this.cast(description));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCSerialData newSerialDataTree(List<? extends DocTree> description) {
        DCTree.DCSerialData tree = new DCTree.DCSerialData(this.cast(description));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCSerialField newSerialFieldTree(IdentifierTree name, ReferenceTree type, List<? extends DocTree> description) {
        DCTree.DCSerialField tree = new DCTree.DCSerialField((DCTree.DCIdentifier)name, (DCTree.DCReference)type, this.cast(description));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCSince newSinceTree(List<? extends DocTree> text) {
        DCTree.DCSince tree = new DCTree.DCSince(this.cast(text));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCStartElement newStartElementTree(Name name, List<? extends DocTree> attrs, boolean selfClosing) {
        DCTree.DCStartElement tree = new DCTree.DCStartElement(name, this.cast(attrs), selfClosing);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCText newTextTree(String text) {
        DCTree.DCText tree = new DCTree.DCText(text);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCThrows newThrowsTree(ReferenceTree name, List<? extends DocTree> description) {
        DCTree.DCThrows tree = new DCTree.DCThrows(DocTree.Kind.THROWS, (DCTree.DCReference)name, this.cast(description));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCUnknownBlockTag newUnknownBlockTagTree(Name name, List<? extends DocTree> content) {
        DCTree.DCUnknownBlockTag tree = new DCTree.DCUnknownBlockTag(name, this.cast(content));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCUnknownInlineTag newUnknownInlineTagTree(Name name, List<? extends DocTree> content) {
        DCTree.DCUnknownInlineTag tree = new DCTree.DCUnknownInlineTag(name, this.cast(content));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCValue newValueTree(ReferenceTree ref) {
        DCTree.DCValue tree = new DCTree.DCValue((DCTree.DCReference)ref);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCVersion newVersionTree(List<? extends DocTree> text) {
        DCTree.DCVersion tree = new DCTree.DCVersion(this.cast(text));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public List<DocTree> getFirstSentence(List<? extends DocTree> list) {
        Pair<List<DCTree>, List<DCTree>> pair = this.splitBody(list);
        return new ArrayList<DocTree>((Collection)pair.fst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<List<DCTree>, List<DCTree>> splitBody(Collection<? extends DocTree> list) {
        int savedpos = this.pos;
        try {
            ListBuffer<DCTree> body = new ListBuffer<DCTree>();
            ListBuffer<DCTree> fs = new ListBuffer<DCTree>();
            if (list.isEmpty()) {
                Pair<List<DCTree>, List<DCTree>> pair = new Pair<List<DCTree>, List<DCTree>>(fs.toList(), body.toList());
                return pair;
            }
            boolean foundFirstSentence = false;
            ArrayList<? extends DocTree> alist = new ArrayList<DocTree>(list);
            ListIterator<? extends DocTree> itr = alist.listIterator();
            block7: while (itr.hasNext()) {
                boolean isFirst = !itr.hasPrevious();
                DocTree dt = itr.next();
                int spos = ((DCTree)dt).pos;
                if (foundFirstSentence) {
                    body.add((DCTree)dt);
                    continue;
                }
                switch (dt.getKind()) {
                    case TEXT: {
                        boolean sbrk;
                        DCTree.DCText tt = (DCTree.DCText)dt;
                        String s = tt.getBody();
                        DocTree peekedNext = itr.hasNext() ? alist.get(itr.nextIndex()) : null;
                        int sbreak = this.getSentenceBreak(s, peekedNext);
                        if (sbreak > 0) {
                            s = this.removeTrailingWhitespace(s.substring(0, sbreak));
                            DCTree.DCText text = this.at(spos).newTextTree(s);
                            fs.add(text);
                            foundFirstSentence = true;
                            int nwPos = this.skipWhiteSpace(tt.getBody(), sbreak);
                            if (nwPos <= 0) continue block7;
                            DCTree.DCText text2 = this.at(spos + nwPos).newTextTree(tt.getBody().substring(nwPos));
                            body.add(text2);
                            continue block7;
                        }
                        if (!itr.hasNext() || !(sbrk = this.isSentenceBreak(peekedNext = alist.get(itr.nextIndex()), false))) break;
                        DocTree next = itr.next();
                        s = this.removeTrailingWhitespace(s);
                        DCTree.DCText text = this.at(spos).newTextTree(s);
                        fs.add(text);
                        body.add((DCTree)next);
                        foundFirstSentence = true;
                        continue block7;
                    }
                    default: {
                        if (!this.isSentenceBreak(dt, isFirst)) break;
                        body.add((DCTree)dt);
                        foundFirstSentence = true;
                        continue block7;
                    }
                }
                fs.add((DCTree)dt);
            }
            Pair<List<DCTree>, List<DCTree>> pair = new Pair<List<DCTree>, List<DCTree>>(fs.toList(), body.toList());
            return pair;
        }
        finally {
            this.pos = savedpos;
        }
    }

    private boolean isTextTree(DocTree tree) {
        return tree.getKind() == DocTree.Kind.TEXT;
    }

    private int defaultSentenceBreak(String s) {
        int period = -1;
        block4: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '.': {
                    period = i;
                    continue block4;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (period < 0) continue block4;
                    return i;
                }
                default: {
                    period = -1;
                }
            }
        }
        return -1;
    }

    private int getSentenceBreak(String s, DocTree dt) {
        BreakIterator breakIterator = this.trees.getBreakIterator();
        if (breakIterator == null) {
            return this.defaultSentenceBreak(s);
        }
        breakIterator.setText(s);
        int sbrk = breakIterator.next();
        if (dt == null) {
            return sbrk;
        }
        if (sbrk < s.length() - 1) {
            return sbrk;
        }
        if (this.isTextTree(dt)) {
            TextTree ttnext = (TextTree)dt;
            String combined = s + ttnext.getBody();
            breakIterator.setText(combined);
            int sbrk2 = breakIterator.next();
            if (sbrk < sbrk2) {
                return sbrk;
            }
        }
        if (this.isSentenceBreak(dt, false)) {
            return sbrk;
        }
        String combined = s + "Dummy Sentence.";
        breakIterator.setText(combined);
        int sbrk2 = breakIterator.next();
        if (sbrk2 <= sbrk) {
            return sbrk2;
        }
        return -1;
    }

    private boolean isSentenceBreak(Name tagName) {
        return this.sentenceBreakTags.contains((Object)HtmlTag.get(tagName));
    }

    private boolean isSentenceBreak(DocTree dt, boolean isFirstDocTree) {
        switch (dt.getKind()) {
            case START_ELEMENT: {
                StartElementTree set = (StartElementTree)dt;
                return !isFirstDocTree && ((DCTree)dt).pos > 1 && this.isSentenceBreak(set.getName());
            }
            case END_ELEMENT: {
                EndElementTree eet = (EndElementTree)dt;
                return !isFirstDocTree && ((DCTree)dt).pos > 1 && this.isSentenceBreak(eet.getName());
            }
        }
        return false;
    }

    private int skipWhiteSpace(String s, int start) {
        for (int i = start; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return i;
        }
        return -1;
    }

    private String removeTrailingWhitespace(String s) {
        for (int i = s.length() - 1; i >= 0; --i) {
            char ch = s.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            return s.substring(0, i + 1);
        }
        return s;
    }

    private List<DCTree> cast(List<? extends DocTree> list) {
        return list;
    }
}

