/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.config;

import org.apache.commons.configuration.Configuration;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.bk.QuorumConfig;
import org.apache.distributedlog.common.config.ConcurrentBaseConfiguration;
import org.apache.distributedlog.common.config.ConcurrentConstConfiguration;
import org.apache.distributedlog.config.DynamicDistributedLogConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class TestDynamicDistributedLogConfiguration {
    @Test(timeout=20000L)
    public void testDefaults() throws Exception {
        DistributedLogConfiguration underlyingConfig = new DistributedLogConfiguration();
        underlyingConfig.setRetentionPeriodHours(99);
        underlyingConfig.setProperty("rpsHardWriteLimit", (Object)99);
        ConcurrentConstConfiguration defaultConfig = new ConcurrentConstConfiguration((Configuration)underlyingConfig);
        DynamicDistributedLogConfiguration config = new DynamicDistributedLogConfiguration((ConcurrentBaseConfiguration)defaultConfig);
        Assert.assertEquals((long)99L, (long)config.getRetentionPeriodHours());
        Assert.assertEquals((long)99L, (long)config.getRpsHardWriteLimit());
        config.setProperty("logSegmentRetentionHours", (Object)5);
        Assert.assertEquals((long)5L, (long)config.getRetentionPeriodHours());
        Assert.assertEquals((long)99L, (long)config.getRpsHardWriteLimit());
    }

    @Test(timeout=20000L)
    public void testGetRetentionPeriodHours() {
        ConcurrentBaseConfiguration defaultConfig = new ConcurrentBaseConfiguration();
        DynamicDistributedLogConfiguration dynConf = new DynamicDistributedLogConfiguration(defaultConfig);
        Assert.assertEquals((long)72L, (long)dynConf.getRetentionPeriodHours());
        defaultConfig.setProperty("retention-size", (Object)73);
        Assert.assertEquals((long)73L, (long)dynConf.getRetentionPeriodHours());
        defaultConfig.setProperty("logSegmentRetentionHours", (Object)74);
        Assert.assertEquals((long)74L, (long)dynConf.getRetentionPeriodHours());
        dynConf.setProperty("retention-size", (Object)75);
        Assert.assertEquals((long)75L, (long)dynConf.getRetentionPeriodHours());
        dynConf.setProperty("logSegmentRetentionHours", (Object)76);
        Assert.assertEquals((long)76L, (long)dynConf.getRetentionPeriodHours());
    }

    @Test(timeout=20000L)
    public void testGetOutputBufferSize() {
        ConcurrentBaseConfiguration defaultConfig = new ConcurrentBaseConfiguration();
        DynamicDistributedLogConfiguration dynConf = new DynamicDistributedLogConfiguration(defaultConfig);
        Assert.assertEquals((long)1024L, (long)dynConf.getOutputBufferSize());
        defaultConfig.setProperty("output-buffer-size", (Object)1025);
        Assert.assertEquals((long)1025L, (long)dynConf.getOutputBufferSize());
        defaultConfig.setProperty("writerOutputBufferSize", (Object)1026);
        Assert.assertEquals((long)1026L, (long)dynConf.getOutputBufferSize());
        dynConf.setProperty("output-buffer-size", (Object)1027);
        Assert.assertEquals((long)1027L, (long)dynConf.getOutputBufferSize());
        dynConf.setProperty("writerOutputBufferSize", (Object)1028);
        Assert.assertEquals((long)1028L, (long)dynConf.getOutputBufferSize());
    }

    @Test(timeout=20000L)
    public void testGetReadAheadBatchSize() {
        ConcurrentBaseConfiguration defaultConfig = new ConcurrentBaseConfiguration();
        DynamicDistributedLogConfiguration dynConf = new DynamicDistributedLogConfiguration(defaultConfig);
        Assert.assertEquals((long)2L, (long)dynConf.getReadAheadBatchSize());
        defaultConfig.setProperty("ReadAheadBatchSize", (Object)3);
        Assert.assertEquals((long)3L, (long)dynConf.getReadAheadBatchSize());
        defaultConfig.setProperty("readAheadBatchSize", (Object)4);
        Assert.assertEquals((long)4L, (long)dynConf.getReadAheadBatchSize());
        dynConf.setProperty("ReadAheadBatchSize", (Object)5);
        Assert.assertEquals((long)5L, (long)dynConf.getReadAheadBatchSize());
        dynConf.setProperty("readAheadBatchSize", (Object)6);
        Assert.assertEquals((long)6L, (long)dynConf.getReadAheadBatchSize());
    }

    @Test(timeout=20000L)
    public void testGetReadAheadMaxRecords() {
        ConcurrentBaseConfiguration defaultConfig = new ConcurrentBaseConfiguration();
        DynamicDistributedLogConfiguration dynConf = new DynamicDistributedLogConfiguration(defaultConfig);
        Assert.assertEquals((long)10L, (long)dynConf.getReadAheadMaxRecords());
        defaultConfig.setProperty("ReadAheadMaxEntries", (Object)11);
        Assert.assertEquals((long)11L, (long)dynConf.getReadAheadMaxRecords());
        defaultConfig.setProperty("readAheadMaxRecords", (Object)12);
        Assert.assertEquals((long)12L, (long)dynConf.getReadAheadMaxRecords());
        dynConf.setProperty("ReadAheadMaxEntries", (Object)13);
        Assert.assertEquals((long)13L, (long)dynConf.getReadAheadMaxRecords());
        dynConf.setProperty("readAheadMaxRecords", (Object)14);
        Assert.assertEquals((long)14L, (long)dynConf.getReadAheadMaxRecords());
    }

    void assertQuorumConfig(QuorumConfig config, int expectedEnsembleSize, int expectedWriteQuorumSize, int expectedAckQuorumSize) {
        Assert.assertEquals((long)expectedEnsembleSize, (long)config.getEnsembleSize());
        Assert.assertEquals((long)expectedWriteQuorumSize, (long)config.getWriteQuorumSize());
        Assert.assertEquals((long)expectedAckQuorumSize, (long)config.getAckQuorumSize());
    }

    @Test(timeout=20000L)
    public void testGetQuorumConfig() {
        ConcurrentBaseConfiguration defaultConfig = new ConcurrentBaseConfiguration();
        DynamicDistributedLogConfiguration dynConf = new DynamicDistributedLogConfiguration(defaultConfig);
        this.assertQuorumConfig(dynConf.getQuorumConfig(), 3, 3, 2);
        defaultConfig.setProperty("ensemble-size", (Object)4);
        this.assertQuorumConfig(dynConf.getQuorumConfig(), 4, 3, 2);
        defaultConfig.setProperty("bkcEnsembleSize", (Object)5);
        this.assertQuorumConfig(dynConf.getQuorumConfig(), 5, 3, 2);
        dynConf.setProperty("ensemble-size", (Object)6);
        this.assertQuorumConfig(dynConf.getQuorumConfig(), 6, 3, 2);
        dynConf.setProperty("bkcEnsembleSize", (Object)7);
        this.assertQuorumConfig(dynConf.getQuorumConfig(), 7, 3, 2);
        defaultConfig.setProperty("write-quorum-size", (Object)4);
        this.assertQuorumConfig(dynConf.getQuorumConfig(), 7, 4, 2);
        defaultConfig.setProperty("bkcWriteQuorumSize", (Object)5);
        this.assertQuorumConfig(dynConf.getQuorumConfig(), 7, 5, 2);
        dynConf.setProperty("write-quorum-size", (Object)6);
        this.assertQuorumConfig(dynConf.getQuorumConfig(), 7, 6, 2);
        dynConf.setProperty("bkcWriteQuorumSize", (Object)7);
        this.assertQuorumConfig(dynConf.getQuorumConfig(), 7, 7, 2);
        defaultConfig.setProperty("ack-quorum-size", (Object)3);
        this.assertQuorumConfig(dynConf.getQuorumConfig(), 7, 7, 3);
        defaultConfig.setProperty("bkcAckQuorumSize", (Object)4);
        this.assertQuorumConfig(dynConf.getQuorumConfig(), 7, 7, 4);
        dynConf.setProperty("ack-quorum-size", (Object)5);
        this.assertQuorumConfig(dynConf.getQuorumConfig(), 7, 7, 5);
        dynConf.setProperty("bkcAckQuorumSize", (Object)6);
        this.assertQuorumConfig(dynConf.getQuorumConfig(), 7, 7, 6);
    }

    @Test(timeout=20000L)
    public void testIsDurableWriteEnabled() {
        ConcurrentBaseConfiguration defaultConfig = new ConcurrentBaseConfiguration();
        DynamicDistributedLogConfiguration dynConf = new DynamicDistributedLogConfiguration(defaultConfig);
        Assert.assertTrue((boolean)dynConf.isDurableWriteEnabled());
        defaultConfig.setProperty("isDurableWriteEnabled", (Object)false);
        Assert.assertFalse((boolean)dynConf.isDurableWriteEnabled());
        dynConf.setProperty("isDurableWriteEnabled", (Object)true);
        Assert.assertTrue((boolean)dynConf.isDurableWriteEnabled());
    }
}

