/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.DummyWatcher;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.admin.ZooKeeperAdmin;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.zookeeper.jmx.ZKMBeanInfo;
import org.apache.zookeeper.metrics.MetricsUtils;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.admin.Commands;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.server.util.PortForwarder;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.JMXEnv;
import org.apache.zookeeper.test.ObserverMasterTestBase;
import org.apache.zookeeper.test.ReconfigTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObserverMasterTest
extends ObserverMasterTestBase {
    protected static final Logger LOG = LoggerFactory.getLogger(ObserverMasterTest.class);

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testObserver(boolean testObserverMaster) throws Exception {
        this.latch = new CountDownLatch(2);
        this.setUp(-1, testObserverMaster);
        this.q3.start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server 3 being up");
        this.validateObserverSyncTimeMetrics();
        if (testObserverMaster) {
            int masterPort = this.q3.getQuorumPeer().observer.getSocket().getPort();
            LOG.info("port {} {}", (Object)masterPort, (Object)this.OM_PORT);
            Assertions.assertEquals((int)masterPort, (int)this.OM_PORT, (String)"observer failed to connect to observer master");
        }
        this.zk = new ZooKeeper("127.0.0.1:" + this.CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        this.zk.create("/obstest", "test".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assertions.assertEquals((Object)new String(this.zk.getData("/obstest", null, null)), (Object)"test");
        this.zk.sync("/", null, null);
        this.zk.setData("/obstest", "test2".getBytes(), -1);
        this.zk.getChildren("/", false);
        Assertions.assertEquals((Object)this.zk.getState(), (Object)ZooKeeper.States.CONNECTED);
        LOG.info("Shutting down server 2");
        this.q2.shutdown();
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown("127.0.0.1:" + this.CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT), (String)"Waiting for server 2 to shut down");
        LOG.info("Server 2 down");
        this.latch.await();
        Assertions.assertNotSame((Object)Watcher.Event.KeeperState.SyncConnected, (Object)this.lastEvent.getState(), (String)"Client is still connected to non-quorate cluster");
        LOG.info("Latch returned");
        try {
            Assertions.assertNotEquals((Object)"Shouldn't get a response when cluster not quorate!", (Object)"test", (String)new String(this.zk.getData("/obstest", null, null)));
        }
        catch (KeeperException.ConnectionLossException c) {
            LOG.info("Connection loss exception caught - ensemble not quorate (this is expected)");
        }
        this.latch = new CountDownLatch(1);
        LOG.info("Restarting server 2");
        this.q2.start();
        LOG.info("Waiting for server 2 to come up");
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server 2 being up");
        LOG.info("Server 2 started, waiting for latch");
        this.latch.await();
        Assertions.assertTrue((Watcher.Event.KeeperState.SyncConnected == this.lastEvent.getState() || Watcher.Event.KeeperState.Expired == this.lastEvent.getState() ? 1 : 0) != 0, (String)("Client didn't reconnect to quorate ensemble (state was" + this.lastEvent.getState() + ")"));
        LOG.info("perform a revalidation test");
        int leaderProxyPort = PortAssignment.unique();
        int obsProxyPort = PortAssignment.unique();
        int leaderPort = this.q1.getQuorumPeer().leader == null ? this.CLIENT_PORT_QP2 : this.CLIENT_PORT_QP1;
        PortForwarder leaderPF = new PortForwarder(leaderProxyPort, leaderPort);
        this.latch = new CountDownLatch(1);
        ZooKeeper client = new ZooKeeper(String.format("127.0.0.1:%d,127.0.0.1:%d", leaderProxyPort, obsProxyPort), ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        this.latch.await();
        client.create("/revalidtest", "test".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        Assertions.assertNotNull((Object)client.exists("/revalidtest", null), (String)"Read-after write failed");
        this.latch = new CountDownLatch(2);
        PortForwarder obsPF = new PortForwarder(obsProxyPort, this.CLIENT_PORT_OBS);
        try {
            leaderPF.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.latch.await();
        Assertions.assertEquals((Object)new String(client.getData("/revalidtest", null, null)), (Object)"test");
        client.close();
        obsPF.shutdown();
        this.shutdown();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testRevalidation(boolean testObserverMaster) throws Exception {
        this.setUp(-1, testObserverMaster);
        this.q3.start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server 3 being up");
        int leaderProxyPort = PortAssignment.unique();
        int obsProxyPort = PortAssignment.unique();
        int leaderPort = this.q1.getQuorumPeer().leader == null ? this.CLIENT_PORT_QP2 : this.CLIENT_PORT_QP1;
        PortForwarder leaderPF = new PortForwarder(leaderProxyPort, leaderPort);
        this.latch = new CountDownLatch(1);
        this.zk = new ZooKeeper(String.format("127.0.0.1:%d,127.0.0.1:%d", leaderProxyPort, obsProxyPort), ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        this.latch.await();
        this.zk.create("/revalidtest", "test".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        Assertions.assertNotNull((Object)this.zk.exists("/revalidtest", null), (String)"Read-after write failed");
        this.latch = new CountDownLatch(2);
        PortForwarder obsPF = new PortForwarder(obsProxyPort, this.CLIENT_PORT_OBS);
        try {
            leaderPF.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.latch.await();
        Assertions.assertEquals((Object)new String(this.zk.getData("/revalidtest", null, null)), (Object)"test");
        obsPF.shutdown();
        this.shutdown();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testInOrderCommits(boolean testObserverMaster) throws Exception {
        this.setUp(-1, testObserverMaster);
        this.zk = new ZooKeeper("127.0.0.1:" + this.CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT, null);
        for (int i = 0; i < 10; ++i) {
            this.zk.create("/bulk" + i, "Initial data of some size".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        this.zk.close();
        this.q3.start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for observer to be up");
        this.latch = new CountDownLatch(1);
        this.zk = new ZooKeeper("127.0.0.1:" + this.CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        this.latch.await();
        Assertions.assertEquals((Object)this.zk.getState(), (Object)ZooKeeper.States.CONNECTED);
        this.zk.create("/init", "first".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        final long zxid = this.q1.getQuorumPeer().getLastLoggedZxid();
        this.waitFor("Timeout waiting for observer sync", new ZKTestCase.WaitForCondition(){

            @Override
            public boolean evaluate() {
                return zxid == ObserverMasterTest.this.q3.getQuorumPeer().getLastLoggedZxid();
            }
        }, 30);
        ZooKeeper obsZk = new ZooKeeper("127.0.0.1:" + this.CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        int followerPort = this.q1.getQuorumPeer().leader == null ? this.CLIENT_PORT_QP1 : this.CLIENT_PORT_QP2;
        ZooKeeper fZk = new ZooKeeper("127.0.0.1:" + followerPort, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        int numTransactions = 10001;
        CountDownLatch gate = new CountDownLatch(1);
        CountDownLatch oAsyncLatch = new CountDownLatch(10001);
        Thread oAsyncWriteThread = new Thread(new AsyncWriter(obsZk, 10001, true, oAsyncLatch, "/obs", gate));
        CountDownLatch fAsyncLatch = new CountDownLatch(10001);
        Thread fAsyncWriteThread = new Thread(new AsyncWriter(fZk, 10001, true, fAsyncLatch, "/follower", gate));
        LOG.info("ASYNC WRITES");
        oAsyncWriteThread.start();
        fAsyncWriteThread.start();
        gate.countDown();
        oAsyncLatch.await();
        fAsyncLatch.await();
        oAsyncWriteThread.join(ClientBase.CONNECTION_TIMEOUT);
        if (oAsyncWriteThread.isAlive()) {
            LOG.error("asyncWriteThread is still alive");
        }
        fAsyncWriteThread.join(ClientBase.CONNECTION_TIMEOUT);
        if (fAsyncWriteThread.isAlive()) {
            LOG.error("asyncWriteThread is still alive");
        }
        obsZk.close();
        fZk.close();
        this.shutdown();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testAdminCommands(boolean testObserverMaster) throws IOException, MBeanException, InstanceNotFoundException, ReflectionException, InterruptedException, MalformedObjectNameException, AttributeNotFoundException, InvalidAttributeValueException, KeeperException {
        for (ZKMBeanInfo beanInfo : MBeanRegistry.getInstance().getRegisteredBeans()) {
            MBeanRegistry.getInstance().unregister(beanInfo);
        }
        JMXEnv.setUp();
        this.setUp(-1, testObserverMaster);
        this.q3.start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for observer to be up");
        this.zk = new ZooKeeper("127.0.0.1:" + this.CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        this.zk.create("/obstest", "test".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assertions.assertEquals((Object)new String(this.zk.getData("/obstest", null, null)), (Object)"test");
        Map emptyMap = Collections.emptyMap();
        Map stats = Commands.runCommand((String)"mntr", (ZooKeeperServer)this.q3.getQuorumPeer().getActiveServer(), emptyMap).toMap();
        Assertions.assertTrue((boolean)stats.containsKey("observer_master_id"), (String)"observer not emitting observer_master_id");
        if (testObserverMaster) {
            if (this.q1.getQuorumPeer().leader == null) {
                Assertions.assertEquals((Integer)1, (Integer)this.q1.getQuorumPeer().getSynced_observers_metric());
            } else {
                Assertions.assertEquals((Integer)0, (Integer)this.q1.getQuorumPeer().getSynced_observers_metric());
            }
        } else if (this.q1.getQuorumPeer().leader == null) {
            Assertions.assertNull((Object)this.q1.getQuorumPeer().getSynced_observers_metric());
        } else {
            Assertions.assertEquals((Integer)1, (Integer)this.q1.getQuorumPeer().getSynced_observers_metric());
        }
        if (testObserverMaster) {
            if (this.q2.getQuorumPeer().leader == null) {
                Assertions.assertEquals((Integer)1, (Integer)this.q2.getQuorumPeer().getSynced_observers_metric());
            } else {
                Assertions.assertEquals((Integer)0, (Integer)this.q2.getQuorumPeer().getSynced_observers_metric());
            }
        } else if (this.q2.getQuorumPeer().leader == null) {
            Assertions.assertNull((Object)this.q2.getQuorumPeer().getSynced_observers_metric());
        } else {
            Assertions.assertEquals((Integer)1, (Integer)this.q2.getQuorumPeer().getSynced_observers_metric());
        }
        ObjectName connBean = null;
        for (ObjectName bean : JMXEnv.conn().queryNames(new ObjectName("org.apache.ZooKeeperService:*"), null)) {
            if (!bean.getCanonicalName().contains("Learner_Connections") || !bean.getCanonicalName().contains("id:" + this.q3.getQuorumPeer().getId())) continue;
            connBean = bean;
            break;
        }
        Assertions.assertNotNull(connBean, (String)"could not find connection bean");
        this.latch = new CountDownLatch(1);
        JMXEnv.conn().invoke(connBean, "terminateConnection", new Object[0], null);
        Assertions.assertTrue((boolean)this.latch.await(ClientBase.CONNECTION_TIMEOUT / 2, TimeUnit.MILLISECONDS), (String)"server failed to disconnect on terminate");
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server 3 being up");
        String obsBeanName = String.format("org.apache.ZooKeeperService:name0=ReplicatedServer_id%d,name1=replica.%d,name2=Observer", this.q3.getQuorumPeer().getId(), this.q3.getQuorumPeer().getId());
        Set<ObjectName> names = JMXEnv.conn().queryNames(new ObjectName(obsBeanName), null);
        Assertions.assertEquals((int)1, (int)names.size(), (String)"expecting singular observer bean");
        ObjectName obsBean = names.iterator().next();
        if (testObserverMaster) {
            long observerMasterId = this.q3.getQuorumPeer().observer.getLearnerMasterId();
            this.latch = new CountDownLatch(1);
            JMXEnv.conn().setAttribute(obsBean, new Attribute("LearnerMaster", Long.toString(3L - observerMasterId)));
            Assertions.assertTrue((boolean)this.latch.await(ClientBase.CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS), (String)"server failed to disconnect on terminate");
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server 3 being up");
        } else {
            long leaderId = this.q1.getQuorumPeer().leader == null ? 2L : 1L;
            try {
                JMXEnv.conn().setAttribute(obsBean, new Attribute("LearnerMaster", Long.toString(3L - leaderId)));
                Assertions.fail((String)"should have seen an exception on previous command");
            }
            catch (RuntimeMBeanException e) {
                Assertions.assertEquals(IllegalArgumentException.class, e.getCause().getClass(), (String)"mbean failed for the wrong reason");
            }
        }
        this.shutdown();
        JMXEnv.tearDown();
    }

    private String createServerString(String type, long serverId, int clientPort) {
        return "server." + serverId + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":" + type + ";" + clientPort;
    }

    private void waitServerUp(int clientPort) {
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPort, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server being up");
    }

    private ZooKeeperAdmin createAdmin(int clientPort) throws IOException {
        System.setProperty("zookeeper.DigestAuthenticationProvider.superDigest", "super:D/InIHSb7yEEbrWz8b9l71RjZJU=");
        QuorumPeerConfig.setReconfigEnabled((boolean)true);
        ZooKeeperAdmin admin = new ZooKeeperAdmin("127.0.0.1:" + clientPort, ClientBase.CONNECTION_TIMEOUT, (Watcher)DummyWatcher.INSTANCE);
        admin.addAuthInfo("digest", "super:test".getBytes());
        return admin;
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Disabled
    public void testDynamicReconfig(boolean testObserverMaster) throws InterruptedException, IOException, KeeperException {
        if (!testObserverMaster) {
            return;
        }
        ClientBase.setupTestEnv();
        int clientPort1 = PortAssignment.unique();
        int clientPort2 = PortAssignment.unique();
        int omPort1 = PortAssignment.unique();
        int omPort2 = PortAssignment.unique();
        String quorumCfgSection = this.createServerString("participant", 1L, clientPort1) + "\n" + this.createServerString("participant", 2L, clientPort2);
        QuorumPeerTestBase.MainThread s1 = new QuorumPeerTestBase.MainThread(1, clientPort1, quorumCfgSection, String.format("observerMasterPort=%d%n", omPort1));
        QuorumPeerTestBase.MainThread s2 = new QuorumPeerTestBase.MainThread(2, clientPort2, quorumCfgSection, String.format("observerMasterPort=%d%n", omPort2));
        s1.start();
        s2.start();
        this.waitServerUp(clientPort1);
        this.waitServerUp(clientPort2);
        long nonLeaderOMPort = s1.getQuorumPeer().leader == null ? (long)omPort1 : (long)omPort2;
        int observerClientPort = PortAssignment.unique();
        int observerId = 10;
        QuorumPeerTestBase.MainThread observer = new QuorumPeerTestBase.MainThread(observerId, observerClientPort, quorumCfgSection + "\n" + this.createServerString("observer", observerId, observerClientPort), String.format("observerMasterPort=%d%n", nonLeaderOMPort));
        LOG.info("starting observer");
        observer.start();
        this.waitServerUp(observerClientPort);
        LinkedBlockingQueue states = new LinkedBlockingQueue();
        ZooKeeper observerClient = new ZooKeeper("127.0.0.1:" + observerClientPort, ClientBase.CONNECTION_TIMEOUT, event -> {
            try {
                states.put(event.getState());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        Watcher.Event.KeeperState state = (Watcher.Event.KeeperState)states.poll(1000L, TimeUnit.MILLISECONDS);
        Assertions.assertEquals((Object)Watcher.Event.KeeperState.SyncConnected, (Object)state);
        ArrayList<String> newServers = new ArrayList<String>();
        String server = "server.3=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;localhost:" + PortAssignment.unique();
        newServers.add(server);
        ZooKeeperAdmin admin = this.createAdmin(clientPort1);
        ReconfigTest.reconfig(admin, newServers, null, null, -1L);
        ReconfigTest.testServerHasConfig(observerClient, newServers, null);
        state = (Watcher.Event.KeeperState)states.poll(1000L, TimeUnit.MILLISECONDS);
        Assertions.assertNull((Object)state);
        admin.close();
        observerClient.close();
        observer.shutdown();
        s2.shutdown();
        s1.shutdown();
    }

    private void validateObserverSyncTimeMetrics() {
        String name = "observer_sync_time";
        Map<String, Object> metrics = MetricsUtils.currentServerMetrics();
        Assertions.assertEquals((long)5L, (long)metrics.keySet().stream().filter(key -> key.contains("observer_sync_time")).count());
        Assertions.assertNotNull((Object)metrics.get(String.format("avg_%s", "observer_sync_time")));
        Assertions.assertNotNull((Object)metrics.get(String.format("min_%s", "observer_sync_time")));
        Assertions.assertNotNull((Object)metrics.get(String.format("max_%s", "observer_sync_time")));
        Assertions.assertNotNull((Object)metrics.get(String.format("cnt_%s", "observer_sync_time")));
        Assertions.assertNotNull((Object)metrics.get(String.format("sum_%s", "observer_sync_time")));
    }

    class AsyncWriter
    implements Runnable {
        private final ZooKeeper client;
        private final int numTransactions;
        private final boolean issueSync;
        private final CountDownLatch writerLatch;
        private final String root;
        private final CountDownLatch gate;

        AsyncWriter(ZooKeeper client, int numTransactions, boolean issueSync, CountDownLatch writerLatch, String root, CountDownLatch gate) {
            this.client = client;
            this.numTransactions = numTransactions;
            this.issueSync = issueSync;
            this.writerLatch = writerLatch;
            this.root = root;
            this.gate = gate;
        }

        @Override
        public void run() {
            if (this.gate != null) {
                try {
                    this.gate.await();
                }
                catch (InterruptedException e) {
                    LOG.error("Gate interrupted");
                    return;
                }
            }
            for (int i = 0; i < this.numTransactions; ++i) {
                boolean pleaseLog = i % 100 == 0;
                this.client.create(this.root + i, "inner thread".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, (rc, path, ctx, name) -> {
                    this.writerLatch.countDown();
                    if (pleaseLog) {
                        LOG.info("wrote {}", (Object)path);
                    }
                }, null);
                if (!pleaseLog) continue;
                LOG.info("async wrote {}{}", (Object)this.root, (Object)i);
                if (!this.issueSync) continue;
                this.client.sync(this.root + "0", null, null);
            }
        }
    }
}

