/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.bouncycastle.LICENSE;
import org.bouncycastle.crypto.fips.FipsAES;
import org.bouncycastle.crypto.fips.FipsDH;
import org.bouncycastle.crypto.fips.FipsDRBG;
import org.bouncycastle.crypto.fips.FipsDSA;
import org.bouncycastle.crypto.fips.FipsEC;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.crypto.fips.FipsOperationError;
import org.bouncycastle.crypto.fips.FipsPBKD;
import org.bouncycastle.crypto.fips.FipsRSA;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsTripleDES;
import org.bouncycastle.crypto.fips.SHA256Digest;
import org.bouncycastle.crypto.internal.macs.HMac;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public final class FipsStatus {
    public static final String READY = "READY";
    private static final Object statusLock = new Object();
    private static final String[] classes = new String[]{FipsAES.class.getName(), FipsTripleDES.class.getName(), FipsDH.class.getName(), FipsDRBG.class.getName(), FipsDSA.class.getName(), FipsEC.class.getName(), FipsKDF.class.getName(), FipsPBKD.class.getName(), FipsRSA.class.getName(), FipsSHS.class.getName()};
    private static final AtomicBoolean readyStatus = new AtomicBoolean(false);
    private static volatile Loader loader;
    private static volatile Throwable statusException;

    private FipsStatus() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReady() {
        Object object = statusLock;
        synchronized (object) {
            if (loader == null && statusException == null) {
                try {
                    loader = new Loader();
                    loader.run();
                }
                catch (Exception exception) {
                    statusException = exception;
                    FipsStatus.moveToErrorStatus(new FipsOperationError("Module startup failed: " + exception.getMessage(), exception));
                }
                FipsStatus.checksumValidate();
                readyStatus.set(true);
            } else if (statusException != null) {
                throw new FipsOperationError("Module in error status: " + statusException.getMessage(), statusException);
            }
        }
        return readyStatus.get();
    }

    static boolean isBooting() {
        return !readyStatus.get();
    }

    private static void checksumValidate() {
        final String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return FipsStatus.getResourceName();
            }
        });
        if (string == null) {
            FipsStatus.moveToErrorStatus(new FipsOperationError("Module checksum failed: unable to find"));
        }
        if (string.startsWith("jrt:/")) {
            FipsStatus.moveToErrorStatus(new FipsOperationError("Module checksum failed: unable to calculate"));
        } else {
            JarFile jarFile = AccessController.doPrivileged(new PrivilegedAction<JarFile>(){

                @Override
                public JarFile run() {
                    try {
                        return new JarFile(string);
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }
            });
            if (jarFile != null) {
                try {
                    int n;
                    byte[] byArray = FipsStatus.calculateModuleHMAC(jarFile);
                    InputStream inputStream = jarFile.getInputStream(jarFile.getEntry("META-INF/HMAC.SHA256"));
                    StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
                    while ((n = inputStream.read()) >= 0 && n != 13 && n != 10) {
                        stringBuilder.append((char)n);
                    }
                    byte[] byArray2 = Hex.decode(stringBuilder.toString().trim());
                    if (!Arrays.areEqual(byArray, byArray2)) {
                        FipsStatus.moveToErrorStatus((Object)((Object)new FipsOperationError("Module checksum failed: expected [" + stringBuilder.toString().trim() + "] got [" + Strings.fromByteArray(Hex.encode(byArray)))) + "]");
                    }
                }
                catch (Exception exception) {
                    statusException = exception;
                    FipsStatus.moveToErrorStatus(new FipsOperationError("Module checksum failed: " + exception.getMessage(), exception));
                }
            }
        }
    }

    public static String getStatusMessage() {
        try {
            FipsStatus.isReady();
        }
        catch (FipsOperationError fipsOperationError) {
            // empty catch block
        }
        if (statusException != null) {
            return statusException.getMessage();
        }
        return READY;
    }

    private static void loadClass(String string) {
        try {
            Class.forName(string);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            statusException = exceptionInInitializerError.getCause() != null ? exceptionInInitializerError.getCause() : exceptionInInitializerError;
            throw exceptionInInitializerError;
        }
        catch (ClassNotFoundException classNotFoundException) {
            statusException = classNotFoundException;
            throw new IllegalStateException("Unable to initialize module: " + classNotFoundException.getMessage(), classNotFoundException);
        }
    }

    public static byte[] getModuleHMAC() {
        try {
            String string = FipsStatus.getResourceName();
            return FipsStatus.calculateModuleHMAC(new JarFile(string));
        }
        catch (Exception exception) {
            return new byte[32];
        }
    }

    private static byte[] calculateModuleHMAC(JarFile jarFile) {
        try {
            Object object2;
            HMac hMac = new HMac(new SHA256Digest());
            hMac.init(new KeyParameterImpl(Strings.toByteArray("Legion of the Bouncy Castle Inc.")));
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            Object object3 = jarFile.entries();
            while (object3.hasMoreElements()) {
                Object object4;
                object2 = object3.nextElement();
                if (((ZipEntry)object2).isDirectory() || ((ZipEntry)object2).getName().startsWith("META-INF/") || ((ZipEntry)object2).getName().equals("module-info.class") || (object4 = treeMap.put(((ZipEntry)object2).getName(), object2)) == null) continue;
                IllegalStateException illegalStateException = new IllegalStateException("Unable to initialize module: duplicate entry found in jar file");
                statusException = illegalStateException;
                throw illegalStateException;
            }
            object3 = new byte[8192];
            for (Map.Entry entry : treeMap.entrySet()) {
                int n;
                JarEntry jarEntry = (JarEntry)entry.getValue();
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                byte[] byArray = Strings.toUTF8ByteArray(jarEntry.getName());
                hMac.update((byte)91);
                hMac.update(byArray, 0, byArray.length);
                hMac.update(Pack.longToBigEndian(jarEntry.getSize()), 0, 8);
                hMac.update((byte)93);
                while ((n = inputStream.read((byte[])object3, 0, ((Object)object3).length)) != -1) {
                    hMac.update((byte[])object3, 0, n);
                }
                inputStream.close();
            }
            hMac.update((byte)91);
            object2 = Strings.toUTF8ByteArray("END");
            hMac.update((byte[])object2, 0, ((Object)object2).length);
            hMac.update((byte)93);
            byte[] byArray = new byte[hMac.getMacSize()];
            hMac.doFinal(byArray, 0);
            return byArray;
        }
        catch (Exception exception) {
            return new byte[32];
        }
    }

    private static String getResourceName() {
        String string = null;
        String string2 = LICENSE.class.getCanonicalName().replace(".", "/").replace("LICENSE", "MARKER");
        String string3 = FipsStatus.getMarker(LICENSE.class, string2);
        if (string3 != null) {
            if (string3.startsWith("jar:file:") && string3.contains("!/")) {
                try {
                    String string4;
                    string = string4 = URLDecoder.decode(string3.substring("jar:file:".length(), string3.lastIndexOf("!/")), "UTF-8");
                }
                catch (IOException iOException) {
                    string = null;
                }
            } else if (string3.startsWith("file:") && string3.endsWith(".jar")) {
                try {
                    String string5;
                    string = string5 = URLDecoder.decode(string3.substring("file:".length()), "UTF-8");
                }
                catch (IOException iOException) {
                    string = null;
                }
            } else {
                if (string3.startsWith("jrt:")) {
                    return string3;
                }
                if (string3.startsWith("file:")) {
                    return string3;
                }
            }
        }
        return string;
    }

    static void moveToErrorStatus(String string) {
        FipsStatus.moveToErrorStatus(new FipsOperationError(string));
    }

    static void moveToErrorStatus(FipsOperationError fipsOperationError) {
        statusException = fipsOperationError;
        throw (FipsOperationError)((Object)statusException);
    }

    public static boolean isErrorStatus() {
        return statusException != null;
    }

    static String getMarker(final Class clazz, final String string) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader != null) {
            Object t = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
                        return codeSource.getLocation();
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            });
            if (t != null) {
                return t.toString();
            }
            return classLoader.getResource(string).toString();
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return ClassLoader.getSystemResource(string).toString();
            }
        });
    }

    static class Loader {
        Loader() {
        }

        void run() throws Exception {
            for (String string : classes) {
                if (FipsStatus.isErrorStatus()) continue;
                FipsStatus.loadClass(string);
            }
        }
    }
}

