/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.stats;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.twitter.common.application.ShutdownRegistry;
import com.twitter.common.base.Closure;
import com.twitter.common.base.Command;
import com.twitter.common.base.ExceptionalCommand;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.quantity.Unit;
import com.twitter.common.stats.RecordingStat;
import com.twitter.common.stats.Stat;
import com.twitter.common.stats.Stats;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class NumericStatExporter {
    private static final Logger LOG = Logger.getLogger(NumericStatExporter.class.getName());
    private final ScheduledExecutorService executor;
    private final Amount<Long, Time> exportInterval;
    private final Closure<Map<String, ? extends Number>> exportSink;
    private final Runnable exporter;
    public static final Function<Stat<?>, String> GET_NAME = new Function<Stat<?>, String>(){

        public String apply(Stat<?> stat) {
            return stat.getName();
        }
    };
    public static final Function<Stat<? extends Number>, Number> READ_STAT = new Function<Stat<? extends Number>, Number>(){

        public Number apply(Stat<? extends Number> stat) {
            return (Number)stat.read();
        }
    };
    private static final Function<RecordingStat<? extends Number>, Number> SAMPLE_AND_READ_STAT = new Function<RecordingStat<? extends Number>, Number>(){

        public Number apply(RecordingStat<? extends Number> stat) {
            return stat.sample();
        }
    };

    public NumericStatExporter(final Closure<Map<String, ? extends Number>> exportSink, ScheduledExecutorService executor, Amount<Long, Time> exportInterval) {
        Preconditions.checkNotNull(exportSink);
        this.executor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executor);
        this.exportInterval = (Amount)Preconditions.checkNotNull(exportInterval);
        this.exportSink = exportSink;
        this.exporter = new Runnable(){

            @Override
            public void run() {
                exportSink.execute((Object)Maps.transformValues((Map)Maps.uniqueIndex(Stats.getNumericVariables(), GET_NAME), READ_STAT));
            }
        };
    }

    public void start(ShutdownRegistry shutdownRegistry) {
        long intervalSecs = (Long)this.exportInterval.as((Unit)Time.SECONDS);
        this.executor.scheduleAtFixedRate(this.exporter, intervalSecs, intervalSecs, TimeUnit.SECONDS);
        shutdownRegistry.addAction((ExceptionalCommand)new Command(){

            public void execute() {
                NumericStatExporter.this.stop();
                NumericStatExporter.this.exportSink.execute((Object)Maps.transformValues((Map)Maps.uniqueIndex(Stats.getNumericVariables(), GET_NAME), (Function)SAMPLE_AND_READ_STAT));
            }
        });
    }

    public void stop() {
        try {
            if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
                if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    LOG.severe("Failed to stop stat exporter.");
                }
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

