/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import bk-shade.com.google.common.annotations.VisibleForTesting;
import bk-shade.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SyncThread {
    private static final Logger LOG = LoggerFactory.getLogger(SyncThread.class);
    final ScheduledExecutorService executor;
    final int flushInterval;
    final LedgerStorage ledgerStorage;
    final LedgerDirsManager.LedgerDirsListener dirsListener;
    final CheckpointSource checkpointSource;
    private Object suspensionLock = new Object();
    private boolean suspended = false;

    public SyncThread(ServerConfiguration conf, LedgerDirsManager.LedgerDirsListener dirsListener, LedgerStorage ledgerStorage, CheckpointSource checkpointSource) {
        this.dirsListener = dirsListener;
        this.ledgerStorage = ledgerStorage;
        this.checkpointSource = checkpointSource;
        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder().setNameFormat("SyncThread-" + conf.getBookiePort() + "-%d");
        this.executor = Executors.newSingleThreadScheduledExecutor(tfb.build());
        this.flushInterval = conf.getFlushInterval();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Flush Interval : {}", (Object)this.flushInterval);
        }
    }

    void start() {
        this.executor.scheduleAtFixedRate(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = SyncThread.this.suspensionLock;
                    synchronized (object) {
                        while (SyncThread.this.suspended) {
                            try {
                                SyncThread.this.suspensionLock.wait();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                    SyncThread.this.checkpoint(SyncThread.this.checkpointSource.newCheckpoint());
                }
                catch (Throwable t) {
                    LOG.error("Exception in SyncThread", t);
                    SyncThread.this.dirsListener.fatalError();
                }
            }
        }, this.flushInterval, this.flushInterval, TimeUnit.MILLISECONDS);
    }

    private void flush() {
        CheckpointSource.Checkpoint checkpoint = this.checkpointSource.newCheckpoint();
        try {
            this.ledgerStorage.flush();
        }
        catch (LedgerDirsManager.NoWritableLedgerDirException e) {
            LOG.error("No writeable ledger directories", (Throwable)e);
            this.dirsListener.allDisksFull();
            return;
        }
        catch (IOException e) {
            LOG.error("Exception flushing ledgers", (Throwable)e);
            return;
        }
        try {
            this.checkpointSource.checkpointComplete(checkpoint, false);
        }
        catch (IOException e) {
            LOG.error("Exception marking checkpoint as complete", (Throwable)e);
            this.dirsListener.allDisksFull();
        }
    }

    @VisibleForTesting
    public void checkpoint(CheckpointSource.Checkpoint checkpoint) {
        try {
            checkpoint = this.ledgerStorage.checkpoint(checkpoint);
        }
        catch (LedgerDirsManager.NoWritableLedgerDirException e) {
            LOG.error("No writeable ledger directories", (Throwable)e);
            this.dirsListener.allDisksFull();
            return;
        }
        catch (IOException e) {
            LOG.error("Exception flushing ledgers", (Throwable)e);
            return;
        }
        try {
            this.checkpointSource.checkpointComplete(checkpoint, true);
        }
        catch (IOException e) {
            LOG.error("Exception marking checkpoint as complete", (Throwable)e);
            this.dirsListener.allDisksFull();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void suspendSync() {
        Object object = this.suspensionLock;
        synchronized (object) {
            this.suspended = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void resumeSync() {
        Object object = this.suspensionLock;
        synchronized (object) {
            this.suspended = false;
            this.suspensionLock.notify();
        }
    }

    void shutdown() throws InterruptedException {
        LOG.info("Shutting down SyncThread");
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    SyncThread.this.flush();
                }
                catch (Throwable t) {
                    LOG.error("Exception flushing ledgers at shutdown", t);
                }
            }
        });
        this.executor.shutdown();
        long start = MathUtils.now();
        while (!this.executor.awaitTermination(5L, TimeUnit.MINUTES)) {
            long now = MathUtils.now();
            LOG.info("SyncThread taking a long time to shutdown. Has taken {} seconds so far", (Object)(now - start));
        }
    }
}

