/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerInputStream
extends InputStream {
    private static final Logger LOG = LoggerFactory.getLogger(LedgerInputStream.class);
    private final LedgerHandle lh;
    private ByteBuffer bytebuff;
    byte[] bbytes;
    long lastEntry = 0L;
    int increment = 50;
    int defaultSize = 0x100000;
    Enumeration<LedgerEntry> ledgerSeq = null;

    public LedgerInputStream(LedgerHandle lh) throws BKException, InterruptedException {
        this.lh = lh;
        this.bbytes = new byte[this.defaultSize];
        this.bytebuff = ByteBuffer.wrap(this.bbytes);
        this.bytebuff.position(this.bytebuff.limit());
        this.lastEntry = Math.min(lh.getLastAddConfirmed(), (long)this.increment);
        this.ledgerSeq = lh.readEntries(0L, this.lastEntry);
    }

    public LedgerInputStream(LedgerHandle lh, int size) throws BKException, InterruptedException {
        this.lh = lh;
        this.bbytes = new byte[size];
        this.bytebuff = ByteBuffer.wrap(this.bbytes);
        this.bytebuff.position(this.bytebuff.limit());
        this.lastEntry = Math.min(lh.getLastAddConfirmed(), (long)this.increment);
        this.ledgerSeq = lh.readEntries(0L, this.lastEntry);
    }

    @Override
    public void close() {
    }

    private synchronized boolean refill() throws IOException {
        this.bytebuff.clear();
        if (!this.ledgerSeq.hasMoreElements() && this.lastEntry >= this.lh.getLastAddConfirmed()) {
            return false;
        }
        if (!this.ledgerSeq.hasMoreElements()) {
            long last = Math.min(this.lastEntry + (long)this.increment, this.lh.getLastAddConfirmed());
            try {
                this.ledgerSeq = this.lh.readEntries(this.lastEntry + 1L, last);
            }
            catch (BKException bk) {
                IOException ie = new IOException(bk.getMessage());
                ie.initCause(bk);
                throw ie;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            this.lastEntry = last;
        }
        LedgerEntry le = this.ledgerSeq.nextElement();
        this.bbytes = le.getEntry();
        this.bytebuff = ByteBuffer.wrap(this.bbytes);
        return true;
    }

    @Override
    public synchronized int read() throws IOException {
        boolean toread = true;
        if (this.bytebuff.remaining() == 0) {
            toread = this.refill();
        }
        if (toread) {
            int ret = 0xFF & this.bytebuff.get();
            return ret;
        }
        return -1;
    }

    @Override
    public synchronized int read(byte[] b) throws IOException {
        boolean toread = true;
        if (this.bytebuff.remaining() == 0) {
            toread = this.refill();
        }
        if (toread) {
            int bcopied = this.bytebuff.remaining();
            int tocopy = Math.min(bcopied, b.length);
            System.arraycopy(this.bbytes, this.bytebuff.position(), b, 0, tocopy);
            this.bytebuff.position(this.bytebuff.position() + tocopy);
            return tocopy;
        }
        return -1;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        boolean toread = true;
        if (this.bytebuff.remaining() == 0) {
            toread = this.refill();
        }
        if (toread) {
            int bcopied = this.bytebuff.remaining();
            int tocopy = Math.min(bcopied, len);
            System.arraycopy(this.bbytes, this.bytebuff.position(), b, off, tocopy);
            this.bytebuff.position(this.bytebuff.position() + tocopy);
            return tocopy;
        }
        return -1;
    }
}

