/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.application;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.twitter.common.base.Command;
import com.twitter.common.base.ExceptionalCommand;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface ShutdownRegistry {
    public <E extends Exception, T extends ExceptionalCommand<E>> void addAction(T var1);

    public static class ShutdownRegistryImpl
    implements ShutdownRegistry,
    Command {
        private static final Logger LOG = Logger.getLogger(ShutdownRegistry.class.getName());
        private final List<ExceptionalCommand<? extends Exception>> actions = Lists.newLinkedList();
        private boolean completed = false;

        @Override
        public synchronized <E extends Exception, T extends ExceptionalCommand<E>> void addAction(T action) {
            Preconditions.checkState((!this.completed ? 1 : 0) != 0);
            this.actions.add(action);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void execute() {
            if (!this.completed) {
                LOG.info(String.format("Executing %d shutdown commands.", this.actions.size()));
                this.completed = true;
                try {
                    for (ExceptionalCommand action : Lists.reverse(this.actions)) {
                        try {
                            action.execute();
                        }
                        catch (Exception e) {
                            LOG.log(Level.WARNING, "Shutdown action failed.", e);
                        }
                    }
                }
                finally {
                    this.actions.clear();
                }
            } else {
                LOG.info("Action controller has already completed, subsequent calls ignored.");
            }
        }
    }
}

