/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.client.proxy;

import com.twitter.finagle.Service;
import com.twitter.finagle.ThriftMux;
import com.twitter.finagle.builder.ClientBuilder;
import com.twitter.finagle.client.StackBasedClient;
import com.twitter.finagle.thrift.ClientId;
import com.twitter.finagle.thrift.ThriftClientFramedCodec;
import com.twitter.finagle.thrift.ThriftClientRequest;
import com.twitter.util.Duration;
import com.twitter.util.Future;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.distributedlog.client.ClientConfig;
import org.apache.distributedlog.client.stats.ClientStats;
import org.apache.distributedlog.thrift.service.DistributedLogService;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import scala.Function1;
import scala.Option;
import scala.runtime.BoxedUnit;

public class ProxyClient {
    private final SocketAddress address;
    private final Service<ThriftClientRequest, byte[]> client;
    private final DistributedLogService.ServiceIface service;

    public static Builder newBuilder(String clientName, ClientId clientId, ClientBuilder clientBuilder, ClientConfig clientConfig, ClientStats clientStats) {
        return new DefaultBuilder(clientName, clientId, clientBuilder, clientConfig, clientStats);
    }

    protected ProxyClient(SocketAddress address, Service<ThriftClientRequest, byte[]> client, DistributedLogService.ServiceIface service) {
        this.address = address;
        this.client = client;
        this.service = service;
    }

    public SocketAddress getAddress() {
        return this.address;
    }

    public Service<ThriftClientRequest, byte[]> getClient() {
        return this.client;
    }

    public DistributedLogService.ServiceIface getService() {
        return this.service;
    }

    public Future<BoxedUnit> close() {
        return this.client.close();
    }

    public static class DefaultBuilder
    implements Builder {
        private final String clientName;
        private final ClientId clientId;
        private final ClientBuilder clientBuilder;
        private final ClientStats clientStats;

        private DefaultBuilder(String clientName, ClientId clientId, ClientBuilder clientBuilder, ClientConfig clientConfig, ClientStats clientStats) {
            this.clientName = clientName;
            this.clientId = clientId;
            this.clientStats = clientStats;
            ClientBuilder builder = this.setDefaultSettings(null == clientBuilder ? this.getDefaultClientBuilder(clientConfig) : clientBuilder);
            this.clientBuilder = this.configureThriftMux(builder, clientId, clientConfig);
        }

        private ClientBuilder configureThriftMux(ClientBuilder builder, ClientId clientId, ClientConfig clientConfig) {
            if (clientConfig.getThriftMux()) {
                return builder.stack((StackBasedClient)ThriftMux.client().withClientId(clientId));
            }
            return builder.codec((Function1)ThriftClientFramedCodec.apply((Option)Option.apply((Object)clientId)));
        }

        private ClientBuilder getDefaultClientBuilder(ClientConfig clientConfig) {
            ClientBuilder builder = ClientBuilder.get().tcpConnectTimeout(Duration.fromMilliseconds((long)200L)).connectTimeout(Duration.fromMilliseconds((long)200L)).requestTimeout(Duration.fromSeconds((int)1));
            if (!clientConfig.getThriftMux()) {
                builder = builder.hostConnectionLimit(1);
            }
            return builder;
        }

        private ClientBuilder setDefaultSettings(ClientBuilder builder) {
            return builder.name(this.clientName).failFast(false).noFailureAccrual().retries(1).keepAlive(true);
        }

        @Override
        public ProxyClient build(SocketAddress address) {
            Service client = ClientBuilder.safeBuildFactory((ClientBuilder)this.clientBuilder.hosts((InetSocketAddress)address).reportTo(this.clientStats.getFinagleStatsReceiver(address))).toService();
            DistributedLogService.ServiceToClient service = new DistributedLogService.ServiceToClient(client, (TProtocolFactory)new TBinaryProtocol.Factory());
            return new ProxyClient(address, (Service<ThriftClientRequest, byte[]>)client, (DistributedLogService.ServiceIface)service);
        }
    }

    public static interface Builder {
        public ProxyClient build(SocketAddress var1);
    }
}

