/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.client.resolver;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.distributedlog.client.resolver.RegionResolver;

public class DefaultRegionResolver
implements RegionResolver {
    private static final String DEFAULT_REGION = "default-region";
    private final Map<SocketAddress, String> regionOverrides = new HashMap<SocketAddress, String>();
    private final ConcurrentMap<SocketAddress, String> regionMap = new ConcurrentHashMap<SocketAddress, String>();

    public DefaultRegionResolver() {
    }

    public DefaultRegionResolver(Map<SocketAddress, String> regionOverrides) {
        this.regionOverrides.putAll(regionOverrides);
    }

    @Override
    public String resolveRegion(SocketAddress address) {
        String region = (String)this.regionMap.get(address);
        if (null == region) {
            region = this.doResolveRegion(address);
            this.regionMap.put(address, region);
        }
        return region;
    }

    private String doResolveRegion(SocketAddress address) {
        String domainName;
        String region = this.regionOverrides.get(address);
        if (null != region) {
            return region;
        }
        if (address instanceof InetSocketAddress) {
            InetSocketAddress iAddr = (InetSocketAddress)address;
            domainName = iAddr.getHostName();
        } else {
            domainName = address.toString();
        }
        String[] parts = domainName.split("\\.");
        if (parts.length <= 0) {
            return DEFAULT_REGION;
        }
        String hostName = parts[0];
        String[] labels = hostName.split("-");
        if (labels.length != 4) {
            return DEFAULT_REGION;
        }
        return labels[0];
    }

    @Override
    public void removeCachedHost(SocketAddress address) {
        this.regionMap.remove(address);
    }
}

