/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.formats.html;

import java.util.List;
import java.util.SortedSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.openjdk.source.doctree.DocTree;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.FieldWriterImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.LinkInfoImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.SubWriterHolderWriter;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.ContentBuilder;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlConstants;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.RawHtml;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.StringContent;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.SerializedFormWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.TagletWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.CommentHelper;

public class HtmlSerialFieldWriter
extends FieldWriterImpl
implements SerializedFormWriter.SerialFieldWriter {
    public HtmlSerialFieldWriter(SubWriterHolderWriter writer, TypeElement typeElement) {
        super(writer, typeElement);
    }

    public SortedSet<VariableElement> members(TypeElement te) {
        return this.utils.serializableFields(te);
    }

    @Override
    public Content getSerializableFieldsHeader() {
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.addStyle(HtmlStyle.blockList);
        return ul;
    }

    @Override
    public Content getFieldsContentHeader(boolean isLastContent) {
        HtmlTree li = new HtmlTree(HtmlTag.LI);
        if (isLastContent) {
            li.addStyle(HtmlStyle.blockListLast);
        } else {
            li.addStyle(HtmlStyle.blockList);
        }
        return li;
    }

    @Override
    public Content getSerializableFields(String heading, Content serializableFieldsTree) {
        HtmlTree li = new HtmlTree(HtmlTag.LI);
        li.addStyle(HtmlStyle.blockList);
        if (serializableFieldsTree.isValid()) {
            StringContent headingContent = new StringContent(heading);
            HtmlTree serialHeading = HtmlTree.HEADING(HtmlConstants.SERIALIZED_MEMBER_HEADING, headingContent);
            li.addContent(serialHeading);
            li.addContent(serializableFieldsTree);
        }
        return li;
    }

    @Override
    public void addMemberHeader(TypeElement fieldType, String fieldTypeStr, String fieldDimensions, String fieldName, Content contentTree) {
        RawHtml nameContent = new RawHtml(fieldName);
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.MEMBER_HEADING, nameContent);
        contentTree.addContent(heading);
        HtmlTree pre = new HtmlTree(HtmlTag.PRE);
        if (fieldType == null) {
            ((Content)pre).addContent(fieldTypeStr);
        } else {
            Content fieldContent = this.writer.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.SERIAL_MEMBER, fieldType));
            ((Content)pre).addContent(fieldContent);
        }
        ((Content)pre).addContent(fieldDimensions + " ");
        ((Content)pre).addContent(fieldName);
        contentTree.addContent(pre);
    }

    @Override
    public void addMemberDeprecatedInfo(VariableElement field, Content contentTree) {
        this.addDeprecatedInfo(field, contentTree);
    }

    @Override
    public void addMemberDescription(VariableElement field, Content contentTree) {
        List<? extends DocTree> tags;
        if (!this.utils.getBody(field).isEmpty()) {
            this.writer.addInlineComment(field, contentTree);
        }
        if (!(tags = this.utils.getBlockTags((Element)field, DocTree.Kind.SERIAL)).isEmpty()) {
            this.writer.addInlineComment(field, tags.get(0), contentTree);
        }
    }

    @Override
    public void addMemberDescription(VariableElement field, DocTree serialFieldTag, Content contentTree) {
        CommentHelper ch = this.utils.getCommentHelper(field);
        List<? extends DocTree> description = ch.getDescription(this.configuration, serialFieldTag);
        if (!description.isEmpty()) {
            RawHtml serialFieldContent = new RawHtml(ch.getText(description));
            HtmlTree div = HtmlTree.DIV(HtmlStyle.block, serialFieldContent);
            contentTree.addContent(div);
        }
    }

    @Override
    public void addMemberTags(VariableElement field, Content contentTree) {
        ContentBuilder tagContent = new ContentBuilder();
        TagletWriter.genTagOutput(this.configuration.tagletManager, field, this.configuration.tagletManager.getCustomTaglets(field), this.writer.getTagletWriterInstance(false), tagContent);
        HtmlTree dlTags = new HtmlTree(HtmlTag.DL);
        ((Content)dlTags).addContent(tagContent);
        contentTree.addContent(dlTags);
    }

    @Override
    public boolean shouldPrintOverview(VariableElement field) {
        if (!(this.configuration.nocomment || this.utils.getBody(field).isEmpty() && !this.writer.hasSerializationOverviewTags(field))) {
            return true;
        }
        return this.utils.isDeprecated(field);
    }
}

