/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.toolkit.builders;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.openjdk.source.doctree.DocTree;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.AnnotationTypeWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.ClassWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.CommentUtils;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.MemberSummaryWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.WriterFactory;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.AbstractBuilder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.AbstractMemberBuilder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.XMLNode;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.CommentHelper;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocFinder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.VisibleMemberMap;

public class MemberSummaryBuilder
extends AbstractMemberBuilder {
    public static final String NAME = "MemberSummary";
    private final EnumMap<VisibleMemberMap.Kind, VisibleMemberMap> visibleMemberMaps;
    private final EnumMap<VisibleMemberMap.Kind, MemberSummaryWriter> memberSummaryWriters;
    private final TypeElement typeElement;

    private MemberSummaryBuilder(AbstractBuilder.Context context, TypeElement typeElement) {
        super(context);
        this.typeElement = typeElement;
        this.memberSummaryWriters = new EnumMap(VisibleMemberMap.Kind.class);
        this.visibleMemberMaps = new EnumMap(VisibleMemberMap.Kind.class);
        for (VisibleMemberMap.Kind kind : VisibleMemberMap.Kind.values()) {
            this.visibleMemberMaps.put(kind, new VisibleMemberMap(typeElement, kind, this.configuration));
        }
    }

    public static MemberSummaryBuilder getInstance(ClassWriter classWriter, AbstractBuilder.Context context) throws Exception {
        MemberSummaryBuilder builder = new MemberSummaryBuilder(context, classWriter.getTypeElement());
        WriterFactory wf = context.configuration.getWriterFactory();
        for (VisibleMemberMap.Kind kind : VisibleMemberMap.Kind.values()) {
            MemberSummaryWriter msw = builder.visibleMemberMaps.get((Object)kind).noVisibleMembers() ? null : wf.getMemberSummaryWriter(classWriter, kind);
            builder.memberSummaryWriters.put(kind, msw);
        }
        return builder;
    }

    public static MemberSummaryBuilder getInstance(AnnotationTypeWriter annotationTypeWriter, AbstractBuilder.Context context) throws Exception {
        MemberSummaryBuilder builder = new MemberSummaryBuilder(context, annotationTypeWriter.getAnnotationTypeElement());
        WriterFactory wf = context.configuration.getWriterFactory();
        for (VisibleMemberMap.Kind kind : VisibleMemberMap.Kind.values()) {
            MemberSummaryWriter msw = builder.visibleMemberMaps.get((Object)kind).noVisibleMembers() ? null : wf.getMemberSummaryWriter(annotationTypeWriter, kind);
            builder.memberSummaryWriters.put(kind, msw);
        }
        return builder;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public VisibleMemberMap getVisibleMemberMap(VisibleMemberMap.Kind type) {
        return this.visibleMemberMaps.get((Object)type);
    }

    public MemberSummaryWriter getMemberSummaryWriter(VisibleMemberMap.Kind type) {
        return this.memberSummaryWriters.get((Object)type);
    }

    public SortedSet<Element> members(VisibleMemberMap.Kind type) {
        return this.visibleMemberMaps.get((Object)type).getLeafClassMembers();
    }

    @Override
    public boolean hasMembersToDocument() {
        if (this.utils.isAnnotationType(this.typeElement)) {
            return !this.utils.getAnnotationMethods(this.typeElement).isEmpty();
        }
        for (VisibleMemberMap.Kind kind : VisibleMemberMap.Kind.values()) {
            VisibleMemberMap members = this.visibleMemberMaps.get((Object)kind);
            if (members.noVisibleMembers()) continue;
            return true;
        }
        return false;
    }

    public void buildEnumConstantsSummary(XMLNode node, Content memberSummaryTree) {
        MemberSummaryWriter writer = this.memberSummaryWriters.get((Object)VisibleMemberMap.Kind.ENUM_CONSTANTS);
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps.get((Object)VisibleMemberMap.Kind.ENUM_CONSTANTS);
        this.addSummary(writer, visibleMemberMap, false, memberSummaryTree);
    }

    public void buildAnnotationTypeFieldsSummary(XMLNode node, Content memberSummaryTree) {
        MemberSummaryWriter writer = this.memberSummaryWriters.get((Object)VisibleMemberMap.Kind.ANNOTATION_TYPE_FIELDS);
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps.get((Object)VisibleMemberMap.Kind.ANNOTATION_TYPE_FIELDS);
        this.addSummary(writer, visibleMemberMap, false, memberSummaryTree);
    }

    public void buildAnnotationTypeOptionalMemberSummary(XMLNode node, Content memberSummaryTree) {
        MemberSummaryWriter writer = this.memberSummaryWriters.get((Object)VisibleMemberMap.Kind.ANNOTATION_TYPE_MEMBER_OPTIONAL);
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps.get((Object)VisibleMemberMap.Kind.ANNOTATION_TYPE_MEMBER_OPTIONAL);
        this.addSummary(writer, visibleMemberMap, false, memberSummaryTree);
    }

    public void buildAnnotationTypeRequiredMemberSummary(XMLNode node, Content memberSummaryTree) {
        MemberSummaryWriter writer = this.memberSummaryWriters.get((Object)VisibleMemberMap.Kind.ANNOTATION_TYPE_MEMBER_REQUIRED);
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps.get((Object)VisibleMemberMap.Kind.ANNOTATION_TYPE_MEMBER_REQUIRED);
        this.addSummary(writer, visibleMemberMap, false, memberSummaryTree);
    }

    public void buildFieldsSummary(XMLNode node, Content memberSummaryTree) {
        MemberSummaryWriter writer = this.memberSummaryWriters.get((Object)VisibleMemberMap.Kind.FIELDS);
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps.get((Object)VisibleMemberMap.Kind.FIELDS);
        this.addSummary(writer, visibleMemberMap, true, memberSummaryTree);
    }

    public void buildPropertiesSummary(XMLNode node, Content memberSummaryTree) {
        MemberSummaryWriter writer = this.memberSummaryWriters.get((Object)VisibleMemberMap.Kind.PROPERTIES);
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps.get((Object)VisibleMemberMap.Kind.PROPERTIES);
        this.addSummary(writer, visibleMemberMap, true, memberSummaryTree);
    }

    public void buildNestedClassesSummary(XMLNode node, Content memberSummaryTree) {
        MemberSummaryWriter writer = this.memberSummaryWriters.get((Object)VisibleMemberMap.Kind.INNER_CLASSES);
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps.get((Object)VisibleMemberMap.Kind.INNER_CLASSES);
        this.addSummary(writer, visibleMemberMap, true, memberSummaryTree);
    }

    public void buildMethodsSummary(XMLNode node, Content memberSummaryTree) {
        MemberSummaryWriter writer = this.memberSummaryWriters.get((Object)VisibleMemberMap.Kind.METHODS);
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps.get((Object)VisibleMemberMap.Kind.METHODS);
        this.addSummary(writer, visibleMemberMap, true, memberSummaryTree);
    }

    public void buildConstructorsSummary(XMLNode node, Content memberSummaryTree) {
        MemberSummaryWriter writer = this.memberSummaryWriters.get((Object)VisibleMemberMap.Kind.CONSTRUCTORS);
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps.get((Object)VisibleMemberMap.Kind.CONSTRUCTORS);
        this.addSummary(writer, visibleMemberMap, false, memberSummaryTree);
    }

    private void buildSummary(MemberSummaryWriter writer, VisibleMemberMap visibleMemberMap, LinkedList<Content> summaryTreeList) {
        SortedSet<Element> members = visibleMemberMap.getLeafClassMembers();
        if (!members.isEmpty()) {
            LinkedList<Content> tableContents = new LinkedList<Content>();
            int counter = 0;
            for (Element member : members) {
                Element property = visibleMemberMap.getPropertyMemberDoc(member);
                if (property != null) {
                    this.processProperty(visibleMemberMap, member, property);
                }
                List<? extends DocTree> firstSentenceTags = this.utils.getFirstSentenceTrees(member);
                if (this.utils.isExecutableElement(member) && firstSentenceTags.isEmpty()) {
                    DocFinder.Output inheritedDoc = DocFinder.search(this.configuration, new DocFinder.Input(this.utils, (ExecutableElement)member));
                    if (inheritedDoc.holder != null && !this.utils.getFirstSentenceTrees(inheritedDoc.holder).isEmpty()) {
                        CommentHelper ch = this.utils.getCommentHelper(member);
                        ch.setOverrideElement(inheritedDoc.holder);
                        firstSentenceTags = this.utils.getFirstSentenceTrees(inheritedDoc.holder);
                    }
                }
                writer.addMemberSummary(this.typeElement, member, firstSentenceTags, tableContents, counter);
                ++counter;
            }
            summaryTreeList.add(writer.getSummaryTableTree(this.typeElement, tableContents));
        }
    }

    private void processProperty(VisibleMemberMap visibleMemberMap, Element member, Element property) {
        CommentUtils cmtutils = this.configuration.cmtUtils;
        boolean isSetter = this.isSetter(member);
        boolean isGetter = this.isGetter(member);
        ArrayList<DocTree> firstSentence = new ArrayList<DocTree>();
        ArrayList<DocTree> bodyTags = new ArrayList<DocTree>();
        ArrayList<DocTree> blockTags = new ArrayList<DocTree>();
        if (isGetter || isSetter) {
            List<? extends DocTree> propertyTags;
            String text;
            if (isSetter) {
                text = MessageFormat.format(this.configuration.getText("doclet.PropertySetterWithName"), this.utils.propertyName((ExecutableElement)member));
                firstSentence.addAll(cmtutils.makeFirstSentenceTree(text));
            }
            if (isGetter) {
                text = MessageFormat.format(this.configuration.getText("doclet.PropertyGetterWithName"), this.utils.propertyName((ExecutableElement)member));
                firstSentence.addAll(cmtutils.makeFirstSentenceTree(text));
            }
            if ((propertyTags = this.utils.getBlockTags(property, "propertyDescription")).isEmpty()) {
                List<? extends DocTree> comment = this.utils.getBody(property);
                blockTags.addAll(cmtutils.makePropertyDescriptionTree(comment));
            }
        } else {
            firstSentence.addAll(this.utils.getBody(property));
        }
        List<? extends DocTree> tags = this.utils.getBlockTags(property, DocTree.Kind.SINCE);
        blockTags.addAll(tags);
        List<? extends DocTree> bTags = this.utils.getBlockTags(property, DocTree.Kind.UNKNOWN_BLOCK_TAG);
        CommentHelper ch = this.utils.getCommentHelper(property);
        for (DocTree docTree : bTags) {
            String tagName = ch.getTagName(docTree);
            if (!"defaultValue".equals(tagName)) continue;
            blockTags.add(docTree);
        }
        if (!isGetter && !isSetter) {
            ExecutableElement getter = (ExecutableElement)visibleMemberMap.getGetterForProperty(member);
            ExecutableElement executableElement = (ExecutableElement)visibleMemberMap.getSetterForProperty(member);
            if (null != getter) {
                StringBuilder sb = new StringBuilder("#");
                sb.append(this.utils.getSimpleName(getter)).append("()");
                blockTags.add(cmtutils.makeSeeTree(sb.toString(), getter));
            }
            if (null != executableElement) {
                VariableElement param = executableElement.getParameters().get(0);
                String typeName = this.utils.getTypeName(param.asType(), false);
                if ((typeName = typeName.split("<")[0]).contains(".")) {
                    typeName = typeName.substring(typeName.lastIndexOf(".") + 1);
                }
                StringBuilder sb = new StringBuilder("#");
                sb.append(this.utils.getSimpleName(executableElement));
                if (!this.utils.isTypeVariable(param.asType())) {
                    sb.append("(").append(typeName).append(")");
                }
                blockTags.add(cmtutils.makeSeeTree(sb.toString(), executableElement));
            }
        }
        cmtutils.setDocCommentTree(member, firstSentence, bodyTags, blockTags, this.utils);
    }

    private boolean isGetter(Element element) {
        String pedName = element.getSimpleName().toString();
        return pedName.startsWith("get") || pedName.startsWith("is");
    }

    private boolean isSetter(Element element) {
        return element.getSimpleName().toString().startsWith("set");
    }

    private void buildInheritedSummary(MemberSummaryWriter writer, VisibleMemberMap visibleMemberMap, LinkedList<Content> summaryTreeList) {
        for (TypeElement inhclass : visibleMemberMap.getVisibleClasses()) {
            SortedSet<Element> inhmembers;
            if (!this.utils.isPublic(inhclass) && !this.utils.isLinkable(inhclass) || inhclass == this.typeElement || (inhmembers = visibleMemberMap.getMembersFor(inhclass)).isEmpty()) continue;
            Content inheritedTree = writer.getInheritedSummaryHeader(inhclass);
            Content linksTree = writer.getInheritedSummaryLinksTree();
            for (Element member : inhmembers) {
                TypeElement t = inhclass;
                if (this.utils.isPackagePrivate(inhclass) && !this.utils.isLinkable(inhclass)) {
                    t = this.typeElement;
                }
                writer.addInheritedMemberSummary(t, member, inhmembers.first() == member, inhmembers.last() == member, linksTree);
            }
            inheritedTree.addContent(linksTree);
            summaryTreeList.add(writer.getMemberTree(inheritedTree));
        }
    }

    private void addSummary(MemberSummaryWriter writer, VisibleMemberMap visibleMemberMap, boolean showInheritedSummary, Content memberSummaryTree) {
        LinkedList<Content> summaryTreeList = new LinkedList<Content>();
        this.buildSummary(writer, visibleMemberMap, summaryTreeList);
        if (showInheritedSummary) {
            this.buildInheritedSummary(writer, visibleMemberMap, summaryTreeList);
        }
        if (!summaryTreeList.isEmpty()) {
            Content memberTree = writer.getMemberSummaryHeader(this.typeElement, memberSummaryTree);
            summaryTreeList.stream().forEach(aSummaryTreeList -> memberTree.addContent((Content)aSummaryTreeList));
            writer.addMemberTree(memberSummaryTree, memberTree);
        }
    }
}

