/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets;

import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.openjdk.source.doctree.DocTree;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Configuration;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.BaseInlineTaglet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.InheritableTaglet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.Taglet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.TagletWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.CommentHelper;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocFinder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.Utils;

public class InheritDocTaglet
extends BaseInlineTaglet {
    public static final String INHERIT_DOC_INLINE_TAG = "{@inheritDoc}";

    public InheritDocTaglet() {
        this.name = DocTree.Kind.INHERIT_DOC.tagName;
    }

    @Override
    public boolean inField() {
        return false;
    }

    @Override
    public boolean inConstructor() {
        return false;
    }

    @Override
    public boolean inOverview() {
        return false;
    }

    @Override
    public boolean inPackage() {
        return false;
    }

    @Override
    public boolean inType() {
        return true;
    }

    private Content retrieveInheritedDocumentation(TagletWriter writer, Element e, DocTree holderTag, boolean isFirstSentence) {
        Taglet inheritableTaglet;
        Content replacement = writer.getOutputInstance();
        Configuration configuration = writer.configuration();
        Utils utils = configuration.utils;
        CommentHelper ch = utils.getCommentHelper(e);
        Taglet taglet = inheritableTaglet = holderTag == null ? null : configuration.tagletManager.getTaglet(ch.getTagName(holderTag));
        if (inheritableTaglet != null && !(inheritableTaglet instanceof InheritableTaglet)) {
            String message = utils.getSimpleName(e) + (utils.isExecutableElement(e) ? utils.flatSignature((ExecutableElement)e) : "");
            configuration.message.warning(e, "doclet.noInheritedDoc", message);
        }
        DocFinder.Input input = new DocFinder.Input(utils, e, (InheritableTaglet)inheritableTaglet, new DocFinder.DocTreeInfo(holderTag, e), isFirstSentence, true);
        DocFinder.Output inheritedDoc = DocFinder.search(configuration, input);
        if (inheritedDoc.isValidInheritDocTag) {
            if (!inheritedDoc.inlineTags.isEmpty()) {
                replacement = writer.commentTagsToOutput(inheritedDoc.holderTag, inheritedDoc.holder, inheritedDoc.inlineTags, isFirstSentence);
                ch.setOverrideElement(inheritedDoc.holder);
            }
        } else {
            String message = utils.getSimpleName(e) + (utils.isExecutableElement(e) ? utils.flatSignature((ExecutableElement)e) : "");
            configuration.message.warning(e, "doclet.noInheritedDoc", message);
        }
        return replacement;
    }

    @Override
    public Content getTagletOutput(Element e, DocTree tag, TagletWriter tagletWriter) {
        DocTree inheritTag = tag.getKind() == DocTree.Kind.INHERIT_DOC ? null : tag;
        return this.retrieveInheritedDocumentation(tagletWriter, e, inheritTag, tagletWriter.isFirstSentence);
    }
}

