/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.toolkit.util;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import org.openjdk.source.util.DocTreePath;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Configuration;

public class MessageRetriever {
    private final Configuration configuration;
    private final String resourcelocation;
    private ResourceBundle messageRB;

    public MessageRetriever(ResourceBundle rb) {
        this.configuration = null;
        this.messageRB = rb;
        this.resourcelocation = null;
    }

    public MessageRetriever(Configuration configuration, String resourcelocation) {
        this.configuration = configuration;
        this.resourcelocation = resourcelocation;
    }

    private void initRB() {
        if (this.messageRB == null) {
            try {
                this.messageRB = ResourceBundle.getBundle(this.resourcelocation, this.configuration.getLocale());
            }
            catch (MissingResourceException e) {
                throw new Error("Fatal: Resource (" + this.resourcelocation + ") for javadoc doclets is missing.");
            }
        }
    }

    public String getText(String key, Object ... args) throws MissingResourceException {
        this.initRB();
        String message = this.messageRB.getString(key);
        return MessageFormat.format(message, args);
    }

    private void printError(DocTreePath path, String msg) {
        this.configuration.reporter.print(Diagnostic.Kind.ERROR, path, msg);
    }

    private void printError(String msg) {
        this.configuration.reporter.print(Diagnostic.Kind.ERROR, msg);
    }

    private void printWarning(DocTreePath path, String msg) {
        this.configuration.reporter.print(Diagnostic.Kind.WARNING, path, msg);
    }

    private void printWarning(Element e, String msg) {
        this.configuration.reporter.print(Diagnostic.Kind.WARNING, e, msg);
    }

    private void printWarning(String msg) {
        this.configuration.reporter.print(Diagnostic.Kind.WARNING, msg);
    }

    public void error(DocTreePath path, String key, Object ... args) {
        this.printError(path, this.getText(key, args));
    }

    public void error(String key, Object ... args) {
        this.printError(this.getText(key, args));
    }

    public void warning(DocTreePath path, String key, Object ... args) {
        if (this.configuration.showMessage(path, key)) {
            this.printWarning(path, this.getText(key, args));
        }
    }

    public void warning(Element e, String key, Object ... args) {
        if (this.configuration.showMessage(e, key)) {
            this.printWarning(e, this.getText(key, args));
        }
    }

    public void warning(String key, Object ... args) {
        this.printWarning(this.getText(key, args));
    }

    private void printNotice(String msg) {
        if (this.configuration.quiet) {
            return;
        }
        this.configuration.reporter.print(Diagnostic.Kind.NOTE, msg);
    }

    public void notice(String key, Object ... args) {
        this.printNotice(this.getText(key, args));
    }
}

