/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.benchmark.stream;

import java.util.Enumeration;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerBatchReader
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(LedgerBatchReader.class);
    private final LedgerHandle lh;
    private final BookkeeperInternalCallbacks.ReadEntryListener readEntryListener;
    private final int batchSize;

    public LedgerBatchReader(LedgerHandle lh, BookkeeperInternalCallbacks.ReadEntryListener readEntryListener, int batchSize) {
        this.lh = lh;
        this.batchSize = batchSize;
        this.readEntryListener = readEntryListener;
    }

    @Override
    public void run() {
        long lac = this.lh.getLastAddConfirmed();
        long entryId = 0L;
        while (entryId <= lac) {
            long startEntryId = entryId;
            long endEntryId = Math.min(startEntryId + (long)this.batchSize - 1L, lac);
            Enumeration entries = null;
            while (null == entries) {
                try {
                    entries = this.lh.readEntries(startEntryId, endEntryId);
                }
                catch (BKException bke) {
                    logger.error("Encountered exceptions on reading [ {} - {} ] ", new Object[]{startEntryId, endEntryId, bke});
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            if (null == entries) break;
            while (entries.hasMoreElements()) {
                LedgerEntry entry = (LedgerEntry)entries.nextElement();
                this.readEntryListener.onEntryComplete(0, this.lh, entry, null);
            }
            entryId = endEntryId + 1L;
        }
    }
}

