/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.benchmark.utils;

import com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ShiftableRateLimiter
implements Runnable {
    private final RateLimiter rateLimiter;
    private final ScheduledExecutorService executor;
    private final double initialRate;
    private final double maxRate;
    private final double changeRate;
    private final long changeInterval;
    private final TimeUnit changeIntervalUnit;
    private double nextRate;

    public ShiftableRateLimiter(double initialRate, double maxRate, double changeRate, long changeInterval, TimeUnit changeIntervalUnit) {
        this.initialRate = initialRate;
        this.maxRate = maxRate;
        this.changeRate = changeRate;
        this.nextRate = initialRate;
        this.changeInterval = changeInterval;
        this.changeIntervalUnit = changeIntervalUnit;
        this.rateLimiter = RateLimiter.create((double)initialRate);
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.scheduleAtFixedRate(this, changeInterval, changeInterval, changeIntervalUnit);
    }

    public ShiftableRateLimiter duplicate() {
        return new ShiftableRateLimiter(this.initialRate, this.maxRate, this.changeRate, this.changeInterval, this.changeIntervalUnit);
    }

    @Override
    public void run() {
        this.nextRate = Math.min(this.nextRate + this.changeRate, this.maxRate);
        this.rateLimiter.setRate(this.nextRate);
    }

    public RateLimiter getLimiter() {
        return this.rateLimiter;
    }
}

