/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.util;

import com.google.common.base.Objects;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.distributedlog.common.concurrent.FutureUtils;
import org.apache.distributedlog.common.util.MathUtil;

public class OrderedScheduler
implements ScheduledExecutorService {
    protected final String name;
    protected final int corePoolSize;
    protected final ScheduledExecutorService[] executors;
    protected final Random random;

    public static Builder newBuilder() {
        return new Builder();
    }

    private OrderedScheduler(String name, int corePoolSize, ThreadFactory threadFactory) {
        this.name = name;
        this.corePoolSize = corePoolSize;
        this.executors = new ScheduledExecutorService[corePoolSize];
        for (int i = 0; i < corePoolSize; ++i) {
            ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat(name + "-scheduler-" + i + "-%d").setThreadFactory(threadFactory).build();
            this.executors[i] = Executors.newSingleThreadScheduledExecutor(tf);
        }
        this.random = new Random(System.currentTimeMillis());
    }

    protected ScheduledExecutorService chooseExecutor() {
        return this.corePoolSize == 1 ? this.executors[0] : this.executors[this.random.nextInt(this.corePoolSize)];
    }

    public ScheduledExecutorService chooseExecutor(Object key) {
        if (null == key) {
            return this.chooseExecutor();
        }
        return this.corePoolSize == 1 ? this.executors[0] : this.executors[MathUtil.signSafeMod(Objects.hashCode((Object[])new Object[]{key}), this.corePoolSize)];
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.chooseExecutor().schedule(command, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.chooseExecutor().schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.chooseExecutor().scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.chooseExecutor().scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Override
    public void shutdown() {
        for (ScheduledExecutorService executor : this.executors) {
            executor.shutdown();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        for (ScheduledExecutorService executor : this.executors) {
            runnables.addAll(executor.shutdownNow());
        }
        return runnables;
    }

    @Override
    public boolean isShutdown() {
        for (ScheduledExecutorService executor : this.executors) {
            if (executor.isShutdown()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isTerminated() {
        for (ScheduledExecutorService executor : this.executors) {
            if (executor.isTerminated()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        for (ScheduledExecutorService executor : this.executors) {
            if (executor.awaitTermination(timeout, unit)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.chooseExecutor().submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.chooseExecutor().submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.chooseExecutor().submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.chooseExecutor().invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.chooseExecutor().invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.chooseExecutor().invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.chooseExecutor().invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.chooseExecutor().execute(command);
    }

    public ScheduledFuture<?> schedule(Object key, Runnable command, long delay, TimeUnit unit) {
        return this.chooseExecutor(key).schedule(command, delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Object key, Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.chooseExecutor(key).scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public Future<?> submit(Object key, Runnable command) {
        return this.chooseExecutor(key).submit(command);
    }

    public <T> CompletableFuture<T> submit(Object key, Callable<T> callable) {
        CompletableFuture future = FutureUtils.createFuture();
        this.chooseExecutor(key).submit(() -> {
            try {
                future.complete(callable.call());
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public static class Builder {
        private String name = "OrderedScheduler";
        private int corePoolSize = -1;
        private ThreadFactory threadFactory = null;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder corePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public OrderedScheduler build() {
            if (this.corePoolSize <= 0) {
                this.corePoolSize = Runtime.getRuntime().availableProcessors();
            }
            if (null == this.threadFactory) {
                this.threadFactory = Executors.defaultThreadFactory();
            }
            return new OrderedScheduler(this.name, this.corePoolSize, this.threadFactory);
        }
    }
}

