/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import java.io.IOException;
import java.util.List;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.meta.HierarchicalLedgerManager;
import org.apache.bookkeeper.meta.LedgerIdGenerator;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.ZkLedgerIdGenerator;
import org.apache.bookkeeper.meta.ZkLedgerUnderreplicationManager;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZKUtil;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;

public class LegacyHierarchicalLedgerManagerFactory
extends LedgerManagerFactory {
    public static final String NAME = "legacyhierarchical";
    public static final int CUR_VERSION = 1;
    AbstractConfiguration conf;
    ZooKeeper zk;

    @Override
    public int getCurrentVersion() {
        return 1;
    }

    @Override
    public LedgerManagerFactory initialize(AbstractConfiguration conf, ZooKeeper zk, int factoryVersion) throws IOException {
        if (1 != factoryVersion) {
            throw new IOException("Incompatible layout version found : " + factoryVersion);
        }
        this.conf = conf;
        this.zk = zk;
        return this;
    }

    @Override
    public void uninitialize() throws IOException {
    }

    @Override
    public LedgerIdGenerator newLedgerIdGenerator() {
        List<ACL> zkAcls = ZkUtils.getACLs(this.conf);
        return new ZkLedgerIdGenerator(this.zk, this.conf.getZkLedgersRootPath(), "idgen", zkAcls);
    }

    @Override
    public LedgerManager newLedgerManager() {
        return new HierarchicalLedgerManager(this.conf, this.zk);
    }

    @Override
    public LedgerUnderreplicationManager newLedgerUnderreplicationManager() throws KeeperException, InterruptedException, ReplicationException.CompatibilityException {
        return new ZkLedgerUnderreplicationManager(this.conf, this.zk);
    }

    @Override
    public void format(AbstractConfiguration conf, ZooKeeper zk) throws InterruptedException, KeeperException, IOException {
        String ledgersRootPath = conf.getZkLedgersRootPath();
        List children = zk.getChildren(ledgersRootPath, false);
        for (String child : children) {
            if (HierarchicalLedgerManager.isSpecialZnode(child)) continue;
            ZKUtil.deleteRecursive((ZooKeeper)zk, (String)(ledgersRootPath + "/" + child));
        }
        super.format(conf, zk);
    }
}

