/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import bk-shade.com.google.proto_2.6.1.ByteString;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.proto.PacketProcessorBaseV3;
import org.apache.bookkeeper.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReadLacProcessorV3
extends PacketProcessorBaseV3
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ReadLacProcessorV3.class);

    public ReadLacProcessorV3(BookkeeperProtocol.Request request, Channel channel, BookieRequestProcessor requestProcessor) {
        super(request, channel, requestProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private BookkeeperProtocol.ReadLacResponse getReadLacResponse() {
        ByteBuf lac;
        ByteBuf lastEntry;
        BookkeeperProtocol.StatusCode status;
        BookkeeperProtocol.ReadLacResponse.Builder readLacResponse;
        long startTimeNanos;
        block10: {
            startTimeNanos = MathUtils.nowInNano();
            BookkeeperProtocol.ReadLacRequest readLacRequest = this.request.getReadLacRequest();
            long ledgerId = readLacRequest.getLedgerId();
            readLacResponse = BookkeeperProtocol.ReadLacResponse.newBuilder().setLedgerId(ledgerId);
            if (!this.isVersionCompatible()) {
                readLacResponse.setStatus(BookkeeperProtocol.StatusCode.EBADVERSION);
                return readLacResponse.build();
            }
            logger.debug("Received ReadLac request: {}", (Object)this.request);
            status = BookkeeperProtocol.StatusCode.EOK;
            lastEntry = null;
            lac = null;
            try {
                lastEntry = this.requestProcessor.bookie.readEntry(ledgerId, -1L);
                lac = this.requestProcessor.bookie.getExplicitLac(ledgerId);
                if (lac != null) {
                    readLacResponse.setLacBody(ByteString.copyFrom(lac.nioBuffer()));
                    readLacResponse.setLastEntryBody(ByteString.copyFrom(lastEntry.nioBuffer()));
                    break block10;
                }
                status = BookkeeperProtocol.StatusCode.ENOENTRY;
            }
            catch (Bookie.NoLedgerException e) {
                status = BookkeeperProtocol.StatusCode.ENOLEDGER;
                logger.error("No ledger found while performing readLac from ledger: {}", (Object)ledgerId);
                ReferenceCountUtil.release((Object)lastEntry);
                ReferenceCountUtil.release((Object)lac);
            }
            catch (IOException e2) {
                status = BookkeeperProtocol.StatusCode.EIO;
                logger.error("IOException while performing readLac from ledger: {}", (Object)ledgerId);
                {
                    catch (Throwable throwable) {
                        ReferenceCountUtil.release(lastEntry);
                        ReferenceCountUtil.release(lac);
                        throw throwable;
                    }
                }
                ReferenceCountUtil.release((Object)lastEntry);
                ReferenceCountUtil.release((Object)lac);
            }
        }
        ReferenceCountUtil.release((Object)lastEntry);
        ReferenceCountUtil.release((Object)lac);
        if (status == BookkeeperProtocol.StatusCode.EOK) {
            this.requestProcessor.readLacStats.registerSuccessfulEvent(MathUtils.elapsedNanos(startTimeNanos), TimeUnit.NANOSECONDS);
        } else {
            this.requestProcessor.readLacStats.registerFailedEvent(MathUtils.elapsedNanos(startTimeNanos), TimeUnit.NANOSECONDS);
        }
        readLacResponse.setStatus(status);
        return readLacResponse.build();
    }

    @Override
    public void safeRun() {
        BookkeeperProtocol.ReadLacResponse readLacResponse = this.getReadLacResponse();
        this.sendResponse(readLacResponse);
    }

    private void sendResponse(BookkeeperProtocol.ReadLacResponse readLacResponse) {
        BookkeeperProtocol.Response.Builder response = BookkeeperProtocol.Response.newBuilder().setHeader(this.getHeader()).setStatus(readLacResponse.getStatus()).setReadLacResponse(readLacResponse);
        this.sendResponse(response.getStatus(), response.build(), this.requestProcessor.readLacRequestStats);
    }
}

