/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import bk-shade.com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashSet;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieCriticalThread;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.replication.Auditor;
import org.apache.bookkeeper.replication.AuditorElector;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.replication.ReplicationWorker;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoRecoveryMain {
    private static final Logger LOG = LoggerFactory.getLogger(AutoRecoveryMain.class);
    private ServerConfiguration conf;
    ZooKeeper zk;
    AuditorElector auditorElector;
    ReplicationWorker replicationWorker;
    private AutoRecoveryDeathWatcher deathWatcher;
    private int exitCode;
    private volatile boolean shuttingDown = false;
    private volatile boolean running = false;
    private static final Options opts = new Options();

    public AutoRecoveryMain(ServerConfiguration conf) throws IOException, InterruptedException, KeeperException, ReplicationException.UnavailableException, ReplicationException.CompatibilityException {
        this(conf, (StatsLogger)NullStatsLogger.INSTANCE);
    }

    public AutoRecoveryMain(ServerConfiguration conf, StatsLogger statsLogger) throws IOException, InterruptedException, KeeperException, ReplicationException.UnavailableException, ReplicationException.CompatibilityException {
        this.conf = conf;
        HashSet<Watcher> watchers = new HashSet<Watcher>();
        watchers.add(new Watcher(){

            public void process(WatchedEvent event) {
                if (event.getState().equals((Object)Watcher.Event.KeeperState.Expired)) {
                    LOG.error("ZK client connection to the ZK server has expired!");
                    AutoRecoveryMain.this.shutdown(3);
                }
            }
        });
        this.zk = ZooKeeperClient.newBuilder().connectString(conf.getZkServers()).sessionTimeoutMs(conf.getZkTimeout()).watchers(watchers).build();
        this.auditorElector = new AuditorElector(Bookie.getBookieAddress(conf).toString(), conf, this.zk, statsLogger.scope("auditor"));
        this.replicationWorker = new ReplicationWorker(this.zk, conf, Bookie.getBookieAddress(conf), statsLogger.scope("replication_worker"));
        this.deathWatcher = new AutoRecoveryDeathWatcher(this);
    }

    public AutoRecoveryMain(ServerConfiguration conf, ZooKeeper zk) throws IOException, InterruptedException, KeeperException, ReplicationException.UnavailableException, ReplicationException.CompatibilityException {
        this.conf = conf;
        this.zk = zk;
        this.auditorElector = new AuditorElector(Bookie.getBookieAddress(conf).toString(), conf, zk);
        this.replicationWorker = new ReplicationWorker(zk, conf, Bookie.getBookieAddress(conf));
        this.deathWatcher = new AutoRecoveryDeathWatcher(this);
    }

    public void start() throws ReplicationException.UnavailableException {
        this.auditorElector.start();
        this.replicationWorker.start();
        this.deathWatcher.start();
        this.running = true;
    }

    public void join() throws InterruptedException {
        this.deathWatcher.join();
    }

    public void shutdown() {
        this.shutdown(0);
    }

    private void shutdown(int exitCode) {
        LOG.info("Shutting down auto recovery: {}", (Object)exitCode);
        if (this.shuttingDown) {
            return;
        }
        LOG.info("Shutting down AutoRecovery");
        this.shuttingDown = true;
        this.running = false;
        this.exitCode = exitCode;
        try {
            this.deathWatcher.interrupt();
            this.deathWatcher.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warn("Interrupted shutting down auto recovery", (Throwable)e);
        }
        try {
            this.auditorElector.shutdown();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warn("Interrupted shutting down auditor elector", (Throwable)e);
        }
        this.replicationWorker.shutdown();
        try {
            this.zk.close();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warn("Interrupted shutting down auto recovery", (Throwable)e);
        }
    }

    private int getExitCode() {
        return this.exitCode;
    }

    @VisibleForTesting
    public Auditor getAuditor() {
        return this.auditorElector.getAuditor();
    }

    public boolean isAutoRecoveryRunning() {
        return this.running;
    }

    private static void printUsage() {
        HelpFormatter hf = new HelpFormatter();
        hf.printHelp("AutoRecoveryMain [options]\n", opts);
    }

    private static void loadConfFile(ServerConfiguration conf, String confFile) throws IllegalArgumentException {
        try {
            conf.loadConf(new File(confFile).toURI().toURL());
        }
        catch (MalformedURLException e) {
            LOG.error("Could not open configuration file: " + confFile, (Throwable)e);
            throw new IllegalArgumentException();
        }
        catch (ConfigurationException e) {
            LOG.error("Malformed configuration file: " + confFile, (Throwable)e);
            throw new IllegalArgumentException();
        }
        LOG.info("Using configuration file " + confFile);
    }

    private static ServerConfiguration parseArgs(String[] args) throws IllegalArgumentException {
        try {
            BasicParser parser = new BasicParser();
            CommandLine cmdLine = parser.parse(opts, args);
            if (cmdLine.hasOption('h')) {
                throw new IllegalArgumentException();
            }
            ServerConfiguration conf = new ServerConfiguration();
            String[] leftArgs = cmdLine.getArgs();
            if (cmdLine.hasOption('c')) {
                if (null != leftArgs && leftArgs.length > 0) {
                    throw new IllegalArgumentException();
                }
                String confFile = cmdLine.getOptionValue("c");
                AutoRecoveryMain.loadConfFile(conf, confFile);
            }
            if (null != leftArgs && leftArgs.length > 0) {
                throw new IllegalArgumentException();
            }
            return conf;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void main(String[] args) {
        ServerConfiguration conf = null;
        try {
            conf = AutoRecoveryMain.parseArgs(args);
        }
        catch (IllegalArgumentException iae) {
            LOG.error("Error parsing command line arguments : ", (Throwable)iae);
            System.err.println(iae.getMessage());
            AutoRecoveryMain.printUsage();
            System.exit(1);
        }
        try {
            final AutoRecoveryMain autoRecoveryMain = new AutoRecoveryMain(conf);
            autoRecoveryMain.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    autoRecoveryMain.shutdown();
                    LOG.info("Shutdown AutoRecoveryMain successfully");
                }
            });
            LOG.info("Register shutdown hook successfully");
            autoRecoveryMain.join();
            System.exit(autoRecoveryMain.getExitCode());
        }
        catch (Exception e) {
            LOG.error("Exception running AutoRecoveryMain : ", (Throwable)e);
            System.exit(2);
        }
    }

    static {
        opts.addOption("c", "conf", true, "Bookie server configuration");
        opts.addOption("h", "help", false, "Print help message");
    }

    private static class AutoRecoveryDeathWatcher
    extends BookieCriticalThread {
        private int watchInterval;
        private AutoRecoveryMain autoRecoveryMain;

        public AutoRecoveryDeathWatcher(AutoRecoveryMain autoRecoveryMain) {
            super("AutoRecoveryDeathWatcher-" + autoRecoveryMain.conf.getBookiePort());
            this.autoRecoveryMain = autoRecoveryMain;
            this.watchInterval = autoRecoveryMain.conf.getDeathWatchInterval();
        }

        @Override
        public void run() {
            block3: {
                do {
                    try {
                        Thread.sleep(this.watchInterval);
                    }
                    catch (InterruptedException ie) {
                        break block3;
                    }
                } while (this.autoRecoveryMain.auditorElector.isRunning() && this.autoRecoveryMain.replicationWorker.isRunning());
                this.autoRecoveryMain.shutdown(2);
            }
        }
    }
}

