/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.io;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.twitter.common.io.Codec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;

public class CompatibilityCodec<T>
implements Codec<T> {
    private final Codec<T> primaryCodec;
    private final Codec<T> secondaryCodec;
    private final int prefixLength;
    private final Predicate<byte[]> discriminator;

    private CompatibilityCodec(Codec<T> primaryCodec, Codec<T> secondaryCodec, int prefixLength, Predicate<byte[]> discriminator) {
        Preconditions.checkNotNull(primaryCodec);
        Preconditions.checkNotNull(secondaryCodec);
        this.primaryCodec = primaryCodec;
        this.secondaryCodec = secondaryCodec;
        this.prefixLength = prefixLength;
        this.discriminator = discriminator;
    }

    public static <T> CompatibilityCodec<T> create(Codec<T> primaryCodec, Codec<T> secondaryCodec, int prefixLength, Predicate<byte[]> discriminator) {
        return new CompatibilityCodec<T>(primaryCodec, secondaryCodec, prefixLength, discriminator);
    }

    @Override
    public T deserialize(InputStream source) throws IOException {
        PushbackInputStream in = new PushbackInputStream(source, this.prefixLength);
        byte[] prefix = this.readAtMostPrefix(in);
        in.unread(prefix);
        return (this.discriminator.apply((Object)prefix) ? this.primaryCodec : this.secondaryCodec).deserialize(in);
    }

    private byte[] readAtMostPrefix(InputStream in) throws IOException {
        int readNow;
        byte[] prefix = new byte[this.prefixLength];
        int read = 0;
        do {
            if ((readNow = in.read(prefix, read, this.prefixLength - read)) != -1) continue;
            byte[] newprefix = new byte[read];
            System.arraycopy(prefix, 0, newprefix, 0, read);
            return newprefix;
        } while ((read += readNow) < this.prefixLength);
        return prefix;
    }

    @Override
    public void serialize(T item, OutputStream sink) throws IOException {
        this.primaryCodec.serialize(item, sink);
    }
}

