/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.mongodb;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.location.access.BrooklynAccessUtils;
import org.apache.brooklyn.entity.nosql.mongodb.AbstractMongoDBServer;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBAuthenticationMixins;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBAuthenticationUtils;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBServer;
import org.apache.brooklyn.entity.nosql.mongodb.ReplicaSetConfig;
import org.apache.brooklyn.util.repeat.Repeater;
import org.apache.brooklyn.util.time.Duration;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBClientSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDBClientSupport.class);
    private ServerAddress address;
    private boolean usesAuthentication;
    private String username;
    private String password;
    private String authenticationDatabase;
    private static final MongoClientOptions connectionOptions = MongoClientOptions.builder().socketKeepAlive(true).build();
    private static final BasicBSONObject EMPTY_RESPONSE = new BasicBSONObject();

    private MongoClient client() {
        return this.baseClient(connectionOptions);
    }

    private MongoClient fastClient() {
        MongoClientOptions fastConnectionOptions = MongoClientOptions.builder().connectTimeout(10000).maxWaitTime(10000).serverSelectionTimeout(10000).build();
        return this.baseClient(fastConnectionOptions);
    }

    private MongoClient baseClient(MongoClientOptions connectionOptions) {
        if (this.usesAuthentication) {
            MongoCredential credential = MongoCredential.createMongoCRCredential((String)this.username, (String)this.authenticationDatabase, (char[])this.password.toCharArray());
            return new MongoClient(this.address, (List)ImmutableList.of((Object)credential), connectionOptions);
        }
        return new MongoClient(this.address, connectionOptions);
    }

    public MongoDBClientSupport(ServerAddress standalone) {
        this.address = standalone;
        this.usesAuthentication = false;
    }

    public MongoDBClientSupport(ServerAddress standalone, String username, String password, String authenticationDatabase) {
        this.address = standalone;
        this.usesAuthentication = true;
        this.username = username;
        this.password = password;
        this.authenticationDatabase = authenticationDatabase;
    }

    public static MongoDBClientSupport forServer(AbstractMongoDBServer standalone) throws UnknownHostException {
        HostAndPort hostAndPort = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)standalone, (int)((Integer)standalone.getAttribute((AttributeSensor)MongoDBServer.PORT)));
        ServerAddress address = new ServerAddress(hostAndPort.getHostText(), hostAndPort.getPort());
        if (MongoDBAuthenticationUtils.usesAuthentication(standalone)) {
            return new MongoDBClientSupport(address, (String)standalone.sensors().get(MongoDBAuthenticationMixins.ROOT_USERNAME), (String)standalone.sensors().get(MongoDBAuthenticationMixins.ROOT_PASSWORD), (String)standalone.sensors().get(MongoDBAuthenticationMixins.AUTHENTICATION_DATABASE));
        }
        return new MongoDBClientSupport(address);
    }

    private ServerAddress getServerAddress() {
        try (MongoClient client = this.client();){
            ServerAddress serverAddress = (ServerAddress)client.getServerAddressList().get(0);
            return serverAddress;
        }
    }

    private HostAndPort getServerHostAndPort() {
        ServerAddress address = this.getServerAddress();
        return HostAndPort.fromParts((String)address.getHost(), (int)address.getPort());
    }

    public Optional<CommandResult> runDBCommand(String database, String command) {
        return this.runDBCommand(database, (DBObject)new BasicDBObject(command, (Object)Boolean.TRUE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<CommandResult> runDBCommand(String database, final DBObject command) {
        try (MongoClient client = this.client();){
            final DB db = client.getDB(database);
            final CommandResult[] status = new CommandResult[1];
            boolean commandResult = Repeater.create().backoff(Duration.ONE_SECOND, 1.5, null).limitIterationsTo(5).until((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    try {
                        status[0] = db.command(command);
                        return true;
                    }
                    catch (Exception e) {
                        LOG.warn("Command " + command + " on " + MongoDBClientSupport.this.address.getHost() + " failed", (Throwable)e);
                        return false;
                    }
                }
            }).run();
            if (!commandResult) {
                Optional optional = Optional.absent();
                return optional;
            }
            if (!status[0].ok()) {
                LOG.debug("Unexpected result of {} on {}: {}", new Object[]{command, this.getServerAddress(), status[0].getErrorMessage()});
            }
            Optional optional = Optional.of((Object)status[0]);
            return optional;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getShardCount() {
        try (MongoClient client = this.client();){
            long l = client.getDB("config").getCollection("shards").getCount();
            return l;
        }
    }

    public BasicBSONObject getServerStatus() {
        Optional<CommandResult> result = this.runDBCommand("admin", "serverStatus");
        if (result.isPresent() && ((CommandResult)result.get()).ok()) {
            return (BasicBSONObject)result.get();
        }
        return EMPTY_RESPONSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ping() {
        MongoClient client = this.fastClient();
        BasicDBObject command = new BasicDBObject("ping", (Object)"1");
        DB db = client.getDB("admin");
        try {
            CommandResult status = db.command((DBObject)command);
            boolean bl = status.ok();
            return bl;
        }
        catch (MongoException e) {
            LOG.warn("Pinging server {} failed with {}", (Object)this.address.getHost(), (Object)e);
        }
        finally {
            client.close();
        }
        return false;
    }

    public boolean initializeReplicaSet(String replicaSetName, Integer id) {
        HostAndPort primary = this.getServerHostAndPort();
        BasicBSONObject config = ReplicaSetConfig.builder(replicaSetName).member(primary, id).build();
        BasicDBObject dbObject = new BasicDBObject("replSetInitiate", (Object)config);
        LOG.debug("Initiating replica set with: " + dbObject);
        Optional<CommandResult> result = this.runDBCommand("admin", (DBObject)dbObject);
        if (result.isPresent() && ((CommandResult)result.get()).ok() && LOG.isDebugEnabled()) {
            LOG.debug("Completed initiating MongoDB replica set {} on entity {}", (Object)replicaSetName, (Object)this);
        }
        return result.isPresent() && ((CommandResult)result.get()).ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BSONObject getReplicaSetConfig() {
        try (MongoClient client = this.client();){
            DBObject dBObject = client.getDB("local").getCollection("system.replset").findOne();
            return dBObject;
        }
    }

    public BasicBSONObject getReplicaSetStatus() {
        Optional<CommandResult> result = this.runDBCommand("admin", "replSetGetStatus");
        if (result.isPresent() && ((CommandResult)result.get()).ok()) {
            return (BasicBSONObject)result.get();
        }
        return EMPTY_RESPONSE;
    }

    public boolean addMemberToReplicaSet(MongoDBServer secondary, Integer id) {
        BSONObject existingConfig = this.getReplicaSetConfig();
        if (existingConfig == null) {
            LOG.warn("Couldn't load existing config for replica set from {}. Server {} not added.", (Object)this.getServerAddress(), (Object)secondary);
            return false;
        }
        BasicBSONObject newConfig = ReplicaSetConfig.fromExistingConfig(existingConfig).primary(this.getServerHostAndPort()).member(secondary, id).build();
        return this.reconfigureReplicaSet(newConfig);
    }

    public boolean removeMemberFromReplicaSet(MongoDBServer server) {
        BSONObject existingConfig = this.getReplicaSetConfig();
        if (existingConfig == null) {
            LOG.warn("Couldn't load existing config for replica set from {}. Server {} not removed.", (Object)this.getServerAddress(), (Object)server);
            return false;
        }
        BasicBSONObject newConfig = ReplicaSetConfig.fromExistingConfig(existingConfig).primary(this.getServerHostAndPort()).remove(server).build();
        return this.reconfigureReplicaSet(newConfig);
    }

    private boolean reconfigureReplicaSet(BasicBSONObject newConfig) {
        BasicDBObject command = new BasicDBObject("replSetReconfig", (Object)newConfig);
        LOG.debug("Reconfiguring replica set to: " + command);
        Optional<CommandResult> result = this.runDBCommand("admin", (DBObject)command);
        return result.isPresent() && ((CommandResult)result.get()).ok();
    }

    public boolean addShardToRouter(String hostAndPort) {
        LOG.debug("Adding shard " + hostAndPort);
        BasicDBObject command = new BasicDBObject("addShard", (Object)hostAndPort);
        Optional<CommandResult> result = this.runDBCommand("admin", (DBObject)command);
        return result.isPresent() && ((CommandResult)result.get()).ok();
    }
}

