/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.server.rest.resource;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.net.URI;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.brooklyn.camp.server.dto.AssemblyTemplateDto;
import org.apache.brooklyn.camp.server.rest.resource.AbstractCampRestResource;
import org.apache.brooklyn.camp.spi.Assembly;
import org.apache.brooklyn.camp.spi.AssemblyTemplate;
import org.apache.brooklyn.camp.spi.instantiate.AssemblyTemplateInstantiator;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/camp/v11/assembly-templates")
@Api(value="Assembly Template resources")
@Produces(value={"application/json"})
public class AssemblyTemplateRestResource
extends AbstractCampRestResource {
    private static final Logger log = LoggerFactory.getLogger(AssemblyTemplateRestResource.class);
    public static final String URI_PATH = "/camp/v11/assembly-templates";

    @Path(value="/{id}")
    @ApiOperation(value="Get a specific assembly template", response=AssemblyTemplateDto.class)
    @GET
    public AssemblyTemplateDto get(@ApiParam(value="ID of item being retrieved", required=true) @PathParam(value="id") String id) {
        return this.dto().adapt((AssemblyTemplate)AssemblyTemplateRestResource.lookup(this.camp().assemblyTemplates(), id));
    }

    @Path(value="/{id}")
    @ApiOperation(value="Instantiate a specific assembly template")
    @POST
    public Response post(@Context UriInfo info, @ApiParam(value="ID of item being retrieved", required=true) @PathParam(value="id") String id) {
        try {
            log.info("CAMP REST instantiating AT " + id);
            AssemblyTemplate at = (AssemblyTemplate)AssemblyTemplateRestResource.lookup(this.camp().assemblyTemplates(), id);
            Assembly assembly = ((AssemblyTemplateInstantiator)at.getInstantiator().newInstance()).instantiate(at, this.camp());
            URI assemblyUri = info.getBaseUriBuilder().path(this.dto().adapt(assembly).getUri()).build(new Object[0]);
            return Response.created((URI)assemblyUri).build();
        }
        catch (Exception e) {
            log.error("Unable to create AT " + id + ": " + e);
            throw Exceptions.propagate((Throwable)e);
        }
    }
}

