/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.catalog.internal;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.rebind.RebindSupport;
import org.apache.brooklyn.api.mgmt.rebind.mementos.CatalogItemMemento;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.catalog.internal.CatalogDo;
import org.apache.brooklyn.core.catalog.internal.CatalogItemDtoAbstract;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.core.relations.EmptyRelationSupport;

public class CatalogItemDo<T, SpecT>
implements CatalogItem<T, SpecT>,
BrooklynObjectInternal {
    protected final CatalogDo catalog;
    protected final CatalogItemDtoAbstract<T, SpecT> itemDto;
    protected volatile Class<T> javaClass;

    public CatalogItemDo(CatalogDo catalog, CatalogItem<T, SpecT> itemDto) {
        this.catalog = (CatalogDo)Preconditions.checkNotNull((Object)catalog, (Object)"catalog");
        this.itemDto = (CatalogItemDtoAbstract)Preconditions.checkNotNull(itemDto, (Object)"itemDto");
    }

    public CatalogItem<T, SpecT> getDto() {
        return this.itemDto;
    }

    @Override
    public ManagementContext getManagementContext() {
        return this.catalog == null ? null : this.catalog.mgmt;
    }

    @Override
    public BrooklynObjectInternal.ConfigurationSupportInternal config() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BrooklynObjectInternal.SubscriptionSupportInternal subscriptions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BrooklynObjectInternal.RelationSupportInternal<CatalogItem<T, SpecT>> relations() {
        return new EmptyRelationSupport<CatalogItem<T, SpecT>>(this);
    }

    public <U> U getConfig(ConfigKey<U> key) {
        return (U)this.config().get(key);
    }

    public CatalogItem.CatalogItemType getCatalogItemType() {
        return this.itemDto.getCatalogItemType();
    }

    public Class<T> getCatalogItemJavaType() {
        return this.itemDto.getCatalogItemJavaType();
    }

    public String getId() {
        return this.itemDto.getId();
    }

    public String getCatalogItemId() {
        return this.itemDto.getCatalogItemId();
    }

    public void setDeprecated(boolean deprecated) {
        this.itemDto.setDeprecated(deprecated);
    }

    public boolean isDeprecated() {
        return this.itemDto.isDeprecated();
    }

    public void setDisabled(boolean diabled) {
        this.itemDto.setDisabled(diabled);
    }

    public boolean isDisabled() {
        return this.itemDto.isDisabled();
    }

    @Override
    public void setCatalogItemId(String id) {
        this.itemDto.setCatalogItemId(id);
    }

    @Override
    public void setCatalogItemIdAndSearchPath(String catalogItemId, List<String> ids) {
        this.itemDto.setCatalogItemIdAndSearchPath(catalogItemId, ids);
    }

    @Override
    public void addSearchPath(List<String> searchPath) {
        this.itemDto.addSearchPath(searchPath);
    }

    public List<String> getCatalogItemIdSearchPath() {
        return this.itemDto.getCatalogItemIdSearchPath();
    }

    @Override
    public void stackCatalogItemId(String id) {
        this.itemDto.stackCatalogItemId(id);
    }

    public String getJavaType() {
        return this.itemDto.getJavaType();
    }

    public String getDisplayName() {
        return this.itemDto.getDisplayName();
    }

    public BrooklynObject.TagSupport tags() {
        return this.itemDto.tags();
    }

    public String getDescription() {
        return this.itemDto.getDescription();
    }

    public String getIconUrl() {
        return this.itemDto.getIconUrl();
    }

    public String getSymbolicName() {
        return this.itemDto.getSymbolicName();
    }

    public String getContainingBundle() {
        return this.itemDto.getContainingBundle();
    }

    public String getVersion() {
        return this.itemDto.getVersion();
    }

    @Nonnull
    public Collection<CatalogItem.CatalogBundle> getLibraries() {
        return this.itemDto.getLibraries();
    }

    public String toString() {
        return this.getClass().getCanonicalName() + "[" + this.itemDto + "]";
    }

    public Class<SpecT> getSpecType() {
        return this.itemDto.getSpecType();
    }

    @Nullable
    public String getPlanYaml() {
        return this.itemDto.getPlanYaml();
    }

    public RebindSupport<CatalogItemMemento> getRebindSupport() {
        return this.itemDto.getRebindSupport();
    }
}

