/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.proxy.nginx;

import com.google.common.collect.LinkedHashMultimap;
import java.util.Collection;
import java.util.Map;
import org.apache.brooklyn.api.entity.drivers.EntityDriver;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.entity.proxy.ProxySslConfig;
import org.apache.brooklyn.entity.proxy.nginx.NginxConfigFileGenerator;
import org.apache.brooklyn.entity.proxy.nginx.NginxController;
import org.apache.brooklyn.entity.proxy.nginx.NginxDriver;
import org.apache.brooklyn.entity.proxy.nginx.UrlMapping;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.text.TemplateProcessor;
import org.apache.brooklyn.util.text.Strings;

public class NginxTemplateConfigGenerator
implements NginxConfigFileGenerator {
    public static final ConfigKey<String> SERVER_CONF_TEMPLATE_URL = ConfigKeys.newStringConfigKey((String)"nginx.config.templateUrl", (String)"The server.conf configuration file URL (FreeMarker template). Only applies if 'nginx.config.generator' specifies a generator which uses a template.", (String)"classpath://org/apache/brooklyn/entity/proxy/nginx/server.conf");

    @Override
    public String generateConfigFile(NginxDriver driver, NginxController nginx) {
        String templateUrl = (String)driver.getEntity().getConfig(NginxController.SERVER_CONF_TEMPLATE_URL);
        ResourceUtils.create((Object)this).checkUrlExists(templateUrl);
        ProxySslConfig ssl = (ProxySslConfig)driver.getEntity().getConfig(NginxController.SSL_CONFIG);
        if (ssl != null && Strings.isEmpty((CharSequence)ssl.getCertificateDestination()) && Strings.isEmpty((CharSequence)ssl.getCertificateSourceUrl())) {
            throw new IllegalStateException("ProxySslConfig can't have a null certificateDestination and null certificateSourceUrl. One or both need to be set");
        }
        Iterable<UrlMapping> mappings = ((NginxController)driver.getEntity()).getUrlMappings();
        LinkedHashMultimap mappingsByDomain = LinkedHashMultimap.create();
        for (UrlMapping mapping : mappings) {
            Collection addrs = (Collection)mapping.getAttribute(UrlMapping.TARGET_ADDRESSES);
            if (addrs == null || addrs.size() <= 0) continue;
            mappingsByDomain.put((Object)mapping.getDomain(), (Object)mapping);
        }
        MutableMap substitutions = MutableMap.builder().putIfNotNull((Object)"ssl", (Object)ssl).put((Object)"urlMappings", mappings).put((Object)"domainMappings", (Object)mappingsByDomain).build();
        String contents = ResourceUtils.create((Object)driver.getEntity()).getResourceAsString(templateUrl);
        return TemplateProcessor.processTemplateContents((String)("nginx config " + templateUrl), (String)contents, (EntityDriver)driver, (Map)substitutions);
    }
}

