/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.core.ClassLoaderReference;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.javalang.Boxing;

public class ObjectWithDefaultStringImplConverter
implements Converter {
    private final ConverterLookup lookup;
    private final ClassLoaderReference loader;
    private final Class<?> defaultImpl = String.class;

    public ObjectWithDefaultStringImplConverter(ConverterLookup lookup, ClassLoaderReference loader) {
        this.lookup = lookup;
        this.loader = loader;
    }

    public boolean canConvert(Class type) {
        return true;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        if (source == null) {
            return;
        }
        Converter converter = this.lookup.lookupConverterForType(source.getClass());
        converter.marshal(source, writer, context);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Class<?> clazz;
        String clazzName = reader.getAttribute("class");
        if (clazzName == null) {
            clazz = this.defaultImpl;
        } else if (clazzName.equals("string")) {
            clazz = String.class;
        } else if (Boxing.getPrimitiveType((String)clazzName).isPresent()) {
            clazz = (Class<?>)Boxing.getPrimitiveType((String)clazzName).get();
        } else {
            try {
                clazz = this.loader.getReference().loadClass(clazzName);
            }
            catch (ClassNotFoundException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }
        Converter converter = this.lookup.lookupConverterForType(clazz);
        return converter.unmarshal(reader, context);
    }
}

