/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.http.parser.loadbalancer;

import com.google.inject.Inject;
import java.util.List;
import org.jclouds.date.DateService;
import org.jclouds.profitbricks.domain.Firewall;
import org.jclouds.profitbricks.domain.LoadBalancer;
import org.jclouds.profitbricks.domain.Server;
import org.jclouds.profitbricks.http.parser.firewall.FirewallListResponseHandler;
import org.jclouds.profitbricks.http.parser.loadbalancer.BaseLoadBalancerResponseHandler;
import org.jclouds.profitbricks.http.parser.server.ServerListResponseHandler;
import org.xml.sax.SAXException;

public class LoadBalancerResponseHandler
extends BaseLoadBalancerResponseHandler<LoadBalancer> {
    private boolean done = false;

    @Inject
    LoadBalancerResponseHandler(DateService dateService, ServerListResponseHandler serverListResponseHandler, FirewallListResponseHandler firewallListResponseHandler) {
        super(dateService, serverListResponseHandler, firewallListResponseHandler);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.done) {
            return;
        }
        if (this.useBalancedServerParser) {
            this.balancedServerResponseHandler.endElement(uri, localName, qName);
        } else if (this.useFirewallParser) {
            this.firewallListResponseHandler.endElement(uri, localName, qName);
        } else {
            this.setPropertyOnEndTag(qName);
            if ("return".equals(qName)) {
                this.done = true;
                this.builder.dataCenter(this.dataCenterBuilder.build()).balancedServers((List<Server>)this.balancedServerResponseHandler.getResult()).firewalls((List<Firewall>)this.firewallListResponseHandler.getResult());
            }
            this.clearTextBuffer();
        }
        if ("balancedServers".equals(qName)) {
            this.useBalancedServerParser = false;
        } else if ("firewall".equals(qName)) {
            this.useFirewallParser = false;
        }
    }

    public LoadBalancer getResult() {
        return this.builder.build();
    }
}

