/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.feed.function;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import groovy.lang.Closure;
import java.util.concurrent.Callable;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.feed.PollConfig;
import org.apache.brooklyn.util.groovy.GroovyJavaMethods;
import org.apache.brooklyn.util.guava.Functionals;
import org.apache.brooklyn.util.javalang.JavaClassNames;

public class FunctionPollConfig<S, T>
extends PollConfig<S, T, FunctionPollConfig<S, T>> {
    private String name;
    private Callable<?> callable;

    public static <T> FunctionPollConfig<?, T> forSensor(AttributeSensor<T> sensor) {
        return new FunctionPollConfig(sensor);
    }

    public static FunctionPollConfig<?, Void> forMultiple() {
        return new FunctionPollConfig(PollConfig.NO_SENSOR);
    }

    public FunctionPollConfig(AttributeSensor<T> sensor) {
        super(sensor);
    }

    public FunctionPollConfig(FunctionPollConfig<S, T> other) {
        super(other);
        this.callable = other.callable;
        this.name = other.name;
    }

    public Callable<? extends Object> getCallable() {
        return this.callable;
    }

    public FunctionPollConfig<S, T> name(String name) {
        this.name = name;
        return this;
    }

    public <newS> FunctionPollConfig<newS, T> callable(Callable<? extends newS> val) {
        this.callable = (Callable)Preconditions.checkNotNull(val, (Object)"callable");
        return this;
    }

    public <newS> FunctionPollConfig<newS, T> supplier(Supplier<? extends newS> val) {
        this.callable = Functionals.callable((Supplier)((Supplier)Preconditions.checkNotNull(val, (Object)"supplier")));
        return this;
    }

    @Deprecated
    private <newS> FunctionPollConfig<newS, T> supplierLegacy(final Supplier<? extends newS> val) {
        Preconditions.checkNotNull(val, (Object)"supplier");
        this.callable = new Callable<newS>(){

            @Override
            public newS call() throws Exception {
                return val.get();
            }
        };
        return this;
    }

    @Deprecated
    public FunctionPollConfig<S, T> closure(Closure<?> val) {
        this.callable = GroovyJavaMethods.callableFromClosure((Closure)((Closure)Preconditions.checkNotNull(val, (Object)"closure")));
        return this;
    }

    @Override
    protected String toStringBaseName() {
        return "fn";
    }

    @Override
    protected String toStringPollSource() {
        if (this.name != null) {
            return this.name;
        }
        if (this.callable == null) {
            return null;
        }
        String cs = this.callable.toString();
        if (!cs.contains("" + Integer.toHexString(this.callable.hashCode()))) {
            return cs;
        }
        return JavaClassNames.simpleClassName(this.callable);
    }
}

