/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.winrm;

import java.util.Map;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.location.winrm.PlainWinRmExecTaskFactory;
import org.apache.brooklyn.location.winrm.WinRmMachineLocation;
import org.apache.brooklyn.location.winrm.WinRmPutTaskFactory;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.ssh.internal.RemoteExecTaskConfigHelper;
import org.apache.brooklyn.util.core.task.system.ProcessTaskFactory;
import org.apache.brooklyn.util.net.Urls;

public class WinRmTasks {
    public static ProcessTaskFactory<Integer> newWinrmExecTaskFactory(WinRmMachineLocation winRmMachineLocation, String ... commands) {
        return new PlainWinRmExecTaskFactory(winRmMachineLocation, commands);
    }

    public static ProcessTaskFactory<Integer> newWinrmExecTaskFactory(RemoteExecTaskConfigHelper.RemoteExecCapability remoteExecCapability, String ... commands) {
        return new PlainWinRmExecTaskFactory(remoteExecCapability, commands);
    }

    public static TaskFactory<?> installFromUrl(final ResourceUtils utils, final Map<String, ?> props, final WinRmMachineLocation location, final String url, final String destPath) {
        return new TaskFactory<TaskAdaptable<?>>(){

            public TaskAdaptable<?> newTask() {
                return Tasks.builder().displayName("installing " + Urls.getBasename((String)url)).description("installing " + url + " to " + destPath).body(new Runnable(){

                    @Override
                    public void run() {
                        int result = location.installTo(utils, props, url, destPath);
                        if (result != 0) {
                            throw new IllegalStateException("Failed to install '" + url + "' to '" + destPath + "' at " + (Object)((Object)location) + ": exit code " + result);
                        }
                    }
                }).build();
            }
        };
    }

    public static WinRmPutTaskFactory newWinrmPutTaskFactory(WinRmMachineLocation winRmMachineLocation, String remoteFile) {
        return WinRmTasks.newWinRmPutTaskFactory(winRmMachineLocation, true, remoteFile);
    }

    public static WinRmPutTaskFactory newWinRmPutTaskFactory(WinRmMachineLocation machine, boolean useMachineConfig, String remoteFile) {
        return new WinRmPutTaskFactory(machine, remoteFile);
    }
}

