/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.filter;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.ha.ManagementNodeState;
import org.apache.brooklyn.rest.filter.HaHotCheckHelperAbstract;
import org.apache.brooklyn.rest.util.OsgiCompat;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.guava.Maybe;

@Deprecated
public class HaMasterCheckFilter
implements Filter {
    private static final Set<String> SAFE_STANDBY_METHODS = Sets.newHashSet((Object[])new String[]{"GET", "HEAD"});
    protected ServletContext servletContext;
    protected ManagementContext mgmt;
    private HaHotCheckHelperAbstract helper = new HaHotCheckHelperAbstract(){

        public ManagementContext mgmt() {
            return HaMasterCheckFilter.this.mgmt;
        }
    };

    public void init(FilterConfig config) throws ServletException {
        this.servletContext = config.getServletContext();
        this.mgmt = OsgiCompat.getManagementContext((ServletContext)this.servletContext);
    }

    private String lookForProblem(ServletRequest request) {
        if (this.helper.isSkipCheckHeaderSet(((HttpServletRequest)request).getHeader("Brooklyn-Allow-Non-Master-Access"))) {
            return null;
        }
        if (!this.isMasterRequiredForRequest(request)) {
            return null;
        }
        Maybe problem = this.helper.getProblemMessageIfServerNotRunning();
        if (problem.isPresent()) {
            return (String)problem.get();
        }
        if (!this.isMaster()) {
            return "server not in required HA master state";
        }
        return null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String problem = this.lookForProblem(request);
        if (problem != null) {
            WebResourceUtils.applyJsonResponse((ManagementContext)this.mgmt, (Response)this.helper.disallowResponse(problem, (Object)request.getParameterMap(), true), (HttpServletResponse)((HttpServletResponse)response));
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private boolean isMaster() {
        return ManagementNodeState.MASTER.equals((Object)this.mgmt.getHighAvailabilityManager().getNodeState());
    }

    private boolean isMasterRequiredForRequest(ServletRequest request) {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            if (SAFE_STANDBY_METHODS.contains(httpRequest.getMethod().toUpperCase())) {
                return false;
            }
            return !HaHotCheckHelperAbstract.isCallAllowedInAnyState((String)httpRequest.getRequestURI());
        }
        return true;
    }
}

