/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.brooklyn.core.BrooklynVersion;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class BrooklynFeatureEnablement {
    private static final Logger LOG = LoggerFactory.getLogger(BrooklynFeatureEnablement.class);
    public static final String FEATURE_PROPERTY_PREFIX = "brooklyn.experimental.feature";
    public static final String FEATURE_POLICY_PERSISTENCE_PROPERTY = "brooklyn.experimental.feature.policyPersistence";
    public static final String FEATURE_ENRICHER_PERSISTENCE_PROPERTY = "brooklyn.experimental.feature.enricherPersistence";
    public static final String FEATURE_FEED_PERSISTENCE_PROPERTY = "brooklyn.experimental.feature.feedPersistence";
    public static final String FEATURE_REFERENCED_OBJECTS_REPERSISTENCE_PROPERTY = "brooklyn.experimental.feature.referencedObjectsRepersistence";
    public static final String FEATURE_FEED_REGISTRATION_PROPERTY = "brooklyn.experimental.feature.feedRegistration";
    public static final String FEATURE_CORS_CXF_PROPERTY = "brooklyn.experimental.feature.corsCxfFeature";
    public static final String FEATURE_BUNDLE_PERSISTENCE_PROPERTY = "brooklyn.experimental.feature.bundlePersistence";
    public static final String FEATURE_CATALOG_PERSISTENCE_PROPERTY = "brooklyn.experimental.feature.catalogPersistence";
    public static final String FEATURE_DEFAULT_STANDBY_IS_HOT_PROPERTY = "brooklyn.experimental.feature.defaultStandbyIsHot";
    public static final String FEATURE_PERSIST_ENTITY_SPEC_AS_SUPPLIER = "brooklyn.experimental.feature.persist.entitySpecAsSupplier";
    public static final String FEATURE_RENAME_THREADS = "brooklyn.executionManager.renameThreads";
    public static final String FEATURE_JITTER_THREADS = "brooklyn.executionManager.jitterThreads";
    public static final String FEATURE_BACKWARDS_COMPATIBILITY_INFER_CATALOG_ITEM_ON_REBIND = "brooklyn.backwardCompatibility.feature.inferCatalogItemOnRebind";
    public static final String FEATURE_AUTO_FIX_CATALOG_REF_ON_REBIND = "brooklyn.quickfix.fixDanglingCatalogItemOnRebind";
    public static final String FEATURE_SSH_ASYNC_EXEC = "brooklyn.experimental.feature.ssh.asyncExec";
    public static final String FEATURE_VALIDATE_LOCATION_SSH_KEYS = "brooklyn.validate.locationSshKeys";
    public static final String FEATURE_DISALLOW_REPARENTING = "brooklyn.disallowReparenting";
    public static final String FEATURE_HOST_GEO_LOOKUP = "brooklyn.hostGeoLookup";
    private static final Map<String, Boolean> FEATURE_ENABLEMENTS = Maps.newLinkedHashMap();
    private static final Map<String, Boolean> FEATURE_ENABLEMENTS_PROPERTIES = Maps.newLinkedHashMap();
    private static final Map<String, Boolean> FEATURE_ENABLEMENT_DEFAULTS = Maps.newLinkedHashMap();
    private static final Object MUTEX = new Object();

    static void setDefaults() {
        BrooklynFeatureEnablement.setDefault(FEATURE_POLICY_PERSISTENCE_PROPERTY, true);
        BrooklynFeatureEnablement.setDefault(FEATURE_ENRICHER_PERSISTENCE_PROPERTY, true);
        BrooklynFeatureEnablement.setDefault(FEATURE_FEED_PERSISTENCE_PROPERTY, true);
        BrooklynFeatureEnablement.setDefault(FEATURE_FEED_REGISTRATION_PROPERTY, false);
        BrooklynFeatureEnablement.setDefault(FEATURE_BUNDLE_PERSISTENCE_PROPERTY, true);
        BrooklynFeatureEnablement.setDefault(FEATURE_CATALOG_PERSISTENCE_PROPERTY, true);
        BrooklynFeatureEnablement.setDefault(FEATURE_REFERENCED_OBJECTS_REPERSISTENCE_PROPERTY, false);
        BrooklynFeatureEnablement.setDefault(FEATURE_DEFAULT_STANDBY_IS_HOT_PROPERTY, true);
        BrooklynFeatureEnablement.setDefault(FEATURE_PERSIST_ENTITY_SPEC_AS_SUPPLIER, true);
        BrooklynFeatureEnablement.setDefault(FEATURE_RENAME_THREADS, false);
        BrooklynFeatureEnablement.setDefault(FEATURE_JITTER_THREADS, false);
        BrooklynFeatureEnablement.setDefault(FEATURE_BACKWARDS_COMPATIBILITY_INFER_CATALOG_ITEM_ON_REBIND, false);
        BrooklynFeatureEnablement.setDefault(FEATURE_AUTO_FIX_CATALOG_REF_ON_REBIND, false);
        BrooklynFeatureEnablement.setDefault(FEATURE_SSH_ASYNC_EXEC, false);
        BrooklynFeatureEnablement.setDefault(FEATURE_VALIDATE_LOCATION_SSH_KEYS, true);
        BrooklynFeatureEnablement.setDefault(FEATURE_HOST_GEO_LOOKUP, BrooklynVersion.isDevelopmentEnvironment());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEnabled(String property) {
        Object object = MUTEX;
        synchronized (object) {
            if (FEATURE_ENABLEMENTS.containsKey(property)) {
                return FEATURE_ENABLEMENTS.get(property);
            }
            if (System.getProperty(property) != null) {
                String rawVal = System.getProperty(property);
                return Boolean.parseBoolean(rawVal);
            }
            if (FEATURE_ENABLEMENTS_PROPERTIES.containsKey(property)) {
                return FEATURE_ENABLEMENTS_PROPERTIES.get(property);
            }
            if (FEATURE_ENABLEMENT_DEFAULTS.containsKey(property)) {
                return FEATURE_ENABLEMENT_DEFAULTS.get(property);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(BrooklynProperties props) {
        boolean found = false;
        Object object = MUTEX;
        synchronized (object) {
            for (Map.Entry<String, Object> entry : props.asMapWithStringKeys().entrySet()) {
                String property = entry.getKey();
                if (!property.startsWith(FEATURE_PROPERTY_PREFIX)) continue;
                found = true;
                Boolean oldVal = BrooklynFeatureEnablement.isEnabled(property);
                boolean val = Boolean.parseBoolean("" + entry.getValue());
                FEATURE_ENABLEMENTS_PROPERTIES.put(property, val);
                Boolean newVal = BrooklynFeatureEnablement.isEnabled(property);
                if (Objects.equal((Object)oldVal, (Object)newVal)) {
                    LOG.debug("Enablement of " + property + " set to " + val + " from brooklyn properties (no-op as continues to resolve to " + oldVal + ")");
                    continue;
                }
                LOG.debug("Enablement of " + property + " set to " + val + " from brooklyn properties (resolved value previously " + oldVal + ")");
            }
            if (!found) {
                LOG.debug("Init feature enablement did nothing, as no settings in brooklyn properties");
            }
        }
    }

    public static boolean enable(String property) {
        return BrooklynFeatureEnablement.setEnablement(property, true);
    }

    public static boolean disable(String property) {
        return BrooklynFeatureEnablement.setEnablement(property, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setEnablement(String property, boolean val) {
        Object object = MUTEX;
        synchronized (object) {
            boolean oldVal = BrooklynFeatureEnablement.isEnabled(property);
            FEATURE_ENABLEMENTS.put(property, val);
            if (val == oldVal) {
                LOG.debug("Enablement of " + property + " set to explicit " + val + " (no-op as resolved to same value previously)");
            } else {
                LOG.debug("Enablement of " + property + " set to explicit " + val + " (previously resolved to " + oldVal + ")");
            }
            return oldVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(String property, boolean val) {
        Object object = MUTEX;
        synchronized (object) {
            Boolean oldDefaultVal = FEATURE_ENABLEMENT_DEFAULTS.get(property);
            FEATURE_ENABLEMENT_DEFAULTS.put(property, val);
            if (oldDefaultVal != null) {
                if (oldDefaultVal.equals(val)) {
                    LOG.debug("Default enablement of " + property + " set to " + val + " (no-op as same as previous default value)");
                } else {
                    LOG.debug("Default enablement of " + property + " set to " + val + " (overwriting previous default of " + oldDefaultVal + ")");
                }
            } else {
                LOG.debug("Default enablement of " + property + " set to " + val);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void clearCache() {
        Object object = MUTEX;
        synchronized (object) {
            FEATURE_ENABLEMENTS.clear();
            FEATURE_ENABLEMENTS_PROPERTIES.clear();
            FEATURE_ENABLEMENT_DEFAULTS.clear();
            BrooklynFeatureEnablement.setDefaults();
        }
    }

    static {
        BrooklynFeatureEnablement.setDefaults();
    }
}

