/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.TypeLiteral;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.cloudstack.domain.AsyncJob;
import org.jclouds.cloudstack.functions.ParseTypedAsyncJob;
import org.jclouds.domain.JsonBall;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.json.internal.GsonWrapper;

@Singleton
public class ParseAsyncJobsFromHttpResponse
implements Function<HttpResponse, Set<AsyncJob<?>>> {
    private final ParseFirstJsonValueNamed<Set<AsyncJob<Map<String, JsonBall>>>> parser;
    private final ParseTypedAsyncJob parseTyped;

    @Inject
    public ParseAsyncJobsFromHttpResponse(ParseTypedAsyncJob parseTyped, GsonWrapper gsonView) {
        this.parseTyped = (ParseTypedAsyncJob)Preconditions.checkNotNull((Object)parseTyped, (Object)"parseTyped");
        this.parser = new ParseFirstJsonValueNamed((GsonWrapper)Preconditions.checkNotNull((Object)gsonView, (Object)"gsonView"), (TypeLiteral)new TypeLiteral<Set<AsyncJob<Map<String, JsonBall>>>>(){}, new String[]{"asyncjobs"});
    }

    public Set<AsyncJob<?>> apply(HttpResponse response) {
        Preconditions.checkNotNull((Object)response, (Object)"response");
        Set toParse = (Set)this.parser.apply(response);
        Preconditions.checkNotNull((Object)toParse, (String)"parsed result from %s", (Object)response);
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)toParse, (Function)this.parseTyped));
    }
}

